/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;

public class COSInteger
extends COSNumber {
    private final int value;

    public static COSInteger create(byte[] bytes, int start, int length) {
        int result = 0;
        int end = start + length;
        boolean negative = false;
        byte prefix = bytes[start];
        if (prefix == 43) {
            ++start;
        } else if (prefix == 45) {
            negative = true;
            ++start;
        }
        int i = start;
        while (i < end) {
            result = result * 10 + bytes[i] - 48;
            ++i;
        }
        if (negative) {
            return new COSInteger(-result);
        }
        return new COSInteger(result);
    }

    public static COSInteger create(int value) {
        return new COSInteger(value);
    }

    public static COSInteger createStrict(byte[] bytes, int start, int length) {
        long resultLong = 0L;
        int end = start + length;
        boolean negative = false;
        byte prefix = bytes[start];
        if (prefix == 43) {
            ++start;
        } else if (prefix == 45) {
            negative = true;
            ++start;
        }
        int i = start;
        while (i < end) {
            resultLong = resultLong * 10L + (long)bytes[i] - 48L;
            ++i;
        }
        if (negative) {
            resultLong = -resultLong;
        }
        if (resultLong > Integer.MAX_VALUE || resultLong < Integer.MIN_VALUE) {
            return null;
        }
        return new COSInteger((int)resultLong);
    }

    protected COSInteger(int newValue) {
        this.value = newValue;
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromInteger(this);
    }

    @Override
    public COSInteger asInteger() {
        return this;
    }

    @Override
    protected String basicToString() {
        return String.valueOf(this.intValue());
    }

    @Override
    protected COSObject copyBasic() {
        return new COSInteger(this.value);
    }

    public boolean equals(Object o) {
        if (!(o instanceof COSInteger)) {
            return false;
        }
        return this.value == ((COSInteger)o).intValue();
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    public Object saveState() {
        COSInteger result = new COSInteger(this.value);
        result.container = this.container.saveStateContainer();
        return result;
    }
}

