/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSCompositeObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectListener;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.filter.FilterFactory;
import de.intarsys.pdf.filter.IFilter;
import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class COSStream
extends COSCompositeObject {
    public static final COSName DK_DecodeParms = COSName.constant("DecodeParms");
    public static final COSName DK_DP = COSName.constant("DP");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_FDecodeParms = COSName.constant("FDecodeParms");
    public static final COSName DK_FFilter = COSName.constant("FFilter");
    public static final COSName DK_Filter = COSName.constant("Filter");
    public static final COSName DK_Length = COSName.constant("Length");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final Object SLOT_BYTES = new Object();
    private byte[] decodedBytes;
    private COSDictionary dict;
    private byte[] encodedBytes;

    public static COSStream create(COSDictionary dict) {
        COSStream result = new COSStream(dict);
        result.beIndirect();
        return result;
    }

    public static COSObject getDecodeParams(COSDictionary dict) {
        if (COSStream.isExternal(dict)) {
            return dict.get(DK_FDecodeParms);
        }
        COSObject result = dict.get(DK_DP);
        if (!result.isNull()) {
            return result;
        }
        return dict.get(DK_DecodeParms);
    }

    public static COSDictionary getDecodeParams(COSDictionary dict, COSName name) {
        COSObject basicFilters = COSStream.getFilters(dict);
        if (basicFilters instanceof COSName) {
            COSName filter = basicFilters.asName();
            if (filter.equals(name)) {
                return dict.get(DK_DecodeParms).asDictionary();
            }
        } else if (basicFilters instanceof COSArray) {
            COSArray filters = basicFilters.asArray();
            int i = 0;
            Iterator<COSObject> it = filters.iterator();
            while (it.hasNext()) {
                COSArray decodeParamsArray;
                COSName filter = it.next().asName();
                if (filter != null && filter.equals(name) && (decodeParamsArray = dict.get(DK_DecodeParms).asArray()) != null) {
                    return decodeParamsArray.get(i).asDictionary();
                }
                ++i;
            }
        }
        return null;
    }

    public static COSObject getFilters(COSDictionary dict) {
        if (COSStream.isExternal(dict)) {
            return dict.get(DK_FFilter);
        }
        COSObject result = dict.get(DK_F);
        if (!result.isNull()) {
            return result;
        }
        return dict.get(DK_Filter);
    }

    public static boolean hasFilter(COSDictionary dict, COSName name) {
        COSObject filters = COSStream.getFilters(dict);
        if (filters.isNull()) {
            return false;
        }
        if (filters instanceof COSName) {
            return filters.equals(name);
        }
        if (filters instanceof COSArray) {
            Iterator<COSObject> i = ((COSArray)filters).iterator();
            while (i.hasNext()) {
                COSName filterName = i.next().asName();
                if (filterName == null || !filterName.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isExternal(COSDictionary dict) {
        COSObject result = dict.get(DK_F);
        if (!result.isNull()) {
            return !(result instanceof COSName) && !(result instanceof COSArray);
        }
        return false;
    }

    protected COSStream() {
    }

    protected COSStream(COSDictionary newDict) {
        if (newDict == null) {
            newDict = COSDictionary.create();
        }
        this.setDict(newDict);
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromStream(this);
    }

    public void addFilter(COSName name) {
        this.addFilter(this.getFilterSize(), name, null);
    }

    public void addFilter(COSName name, COSDictionary dictionary) {
        this.addFilter(this.getFilterSize(), name, dictionary);
    }

    public void addFilter(int index, COSName name) {
        this.addFilter(index, name, null);
    }

    public void addFilter(int index, COSName name, COSDictionary dictionary) {
        this.getDecodedBytes();
        this.encodedBytes = null;
        COSObject filters = this.getFilters();
        if (filters.isNull()) {
            this.getDict().put(DK_Filter, name);
            this.getDict().put(DK_DecodeParms, dictionary);
        } else {
            COSArray newFilterArray;
            COSName filterName = filters.asName();
            if (filterName != null) {
                this.getDict().remove(DK_Filter);
                newFilterArray = COSArray.create(2);
                newFilterArray.add(filterName);
            } else {
                newFilterArray = filters.asArray();
            }
            newFilterArray.add(index, name);
            this.getDict().put(DK_Filter, newFilterArray);
            COSObject decodeParms = this.getDecodeParams();
            COSArray newDecodeParmsArray = null;
            if (decodeParms.isNull() && dictionary != null) {
                newDecodeParmsArray = COSArray.create(newFilterArray.size());
                int count = 0;
                while (count < newFilterArray.size() - 1) {
                    newDecodeParmsArray.add(COSNull.NULL);
                    ++count;
                }
            } else {
                COSDictionary decodeParmsDictionary = decodeParms.asDictionary();
                if (decodeParmsDictionary != null) {
                    this.getDict().remove(DK_DecodeParms);
                    newDecodeParmsArray = COSArray.create(newFilterArray.size());
                    newDecodeParmsArray.add(decodeParmsDictionary);
                } else {
                    newDecodeParmsArray = decodeParms.asArray();
                }
            }
            if (newDecodeParmsArray != null) {
                if (dictionary == null) {
                    newDecodeParmsArray.add(index, COSNull.NULL);
                } else {
                    newDecodeParmsArray.add(index, dictionary);
                }
            }
            this.getDict().put(DK_DecodeParms, newDecodeParmsArray);
        }
    }

    @Override
    public void addObjectListener(ICOSObjectListener listener) {
        super.addObjectListener(listener);
        if (this.dict != null) {
            this.dict.addObjectListener(listener);
        }
    }

    @Override
    public COSStream asStream() {
        return this;
    }

    public Iterator basicIterator() {
        return new SingleObjectIterator((Object)this.getDict());
    }

    public void basicSetDecodedBytes(byte[] newBytes) {
        this.decodedBytes = newBytes;
        this.encodedBytes = null;
    }

    public void basicSetEncodedBytes(byte[] newBytes) {
        this.encodedBytes = newBytes;
        this.decodedBytes = null;
        int length = this.encodedBytes == null ? 0 : this.encodedBytes.length;
        this.getDict().basicPutSilent(DK_Length, COSInteger.create(length));
    }

    @Override
    protected String basicToString() {
        byte[] decoded = this.getDecodedBytes();
        if (decoded == null) {
            return null;
        }
        return new String(decoded);
    }

    @Override
    protected COSObject copyBasic() {
        COSStream result = new COSStream();
        result.beIndirect();
        result.encodedBytes = this.encodedBytes;
        result.decodedBytes = this.decodedBytes;
        return result;
    }

    public COSStream copyDecodeFirst() throws IOException {
        COSArray filters;
        COSStream newStream = (COSStream)this.copyShallow();
        if (this.getFilters().isNull()) {
            return newStream;
        }
        newStream.basicSetDecodedBytes(null);
        newStream.getDict().remove(DK_DecodeParms);
        newStream.getDict().remove(DK_Filter);
        newStream.getDict().remove(DK_Length);
        byte[] bytes = this.getEncodedBytes();
        COSName filter = this.getFirstFilter();
        if (filter != null) {
            bytes = this.doDecode(filter, this.getFirstDecodeParam(), bytes, 0, this.getAnyLength());
        }
        if ((filters = this.getFilters().asArray()) != null) {
            COSArray decodeParmss = this.getDecodeParams().asArray();
            int index = filters.size() - 1;
            while (index > 0) {
                if (decodeParmss != null) {
                    COSDictionary dictionary = decodeParmss.get(index).asDictionary();
                    if (dictionary != null) {
                        dictionary = (COSDictionary)dictionary.copyShallow();
                    }
                    newStream.filter((COSName)filters.get(index).copyShallow(), dictionary);
                } else {
                    newStream.filter((COSName)filters.get(index).copyShallow());
                }
                --index;
            }
        }
        newStream.setEncodedBytes(bytes);
        return newStream;
    }

    @Override
    public COSObject copyDeep(Map copied) {
        COSStream result = (COSStream)super.copyDeep(copied);
        result.setDict((COSDictionary)this.getDict().copyDeep(copied));
        if (this.encodedBytes != null) {
            result.setEncodedBytes(this.encodedBytes);
        } else {
            result.setDecodedBytes(this.decodedBytes);
        }
        return result;
    }

    @Override
    public COSObject copyShallow() {
        COSStream result = (COSStream)super.copyShallow();
        result.setDict((COSDictionary)this.getDict().copyShallow());
        if (this.encodedBytes != null) {
            result.setEncodedBytes(this.encodedBytes);
        } else {
            result.setDecodedBytes(this.decodedBytes);
        }
        return result;
    }

    @Override
    protected COSObject copySubGraph(Map copied) {
        COSStream result = (COSStream)super.copySubGraph(copied);
        result.setDict((COSDictionary)this.getDict().copySubGraph(copied));
        if (this.encodedBytes != null) {
            result.setEncodedBytes(this.encodedBytes);
        } else {
            result.setDecodedBytes(this.decodedBytes);
        }
        return result;
    }

    protected byte[] doDecode() throws IOException {
        byte[] newBytes;
        if (this.isExternal() && this.isBytesArrayEmpty(this.encodedBytes)) {
            this.encodedBytes = null;
            this.parseFKeyedFile();
        }
        if (this.encodedBytes == null) {
            return null;
        }
        COSObject filters = this.getFilters();
        if (filters.isNull()) {
            byte[] newBytes2;
            int length = this.getLength();
            if (length != -1 && this.encodedBytes.length > length) {
                newBytes2 = new byte[length];
                System.arraycopy(this.encodedBytes, 0, newBytes2, 0, length);
            } else {
                newBytes2 = this.encodedBytes;
            }
            return newBytes2;
        }
        COSObject options = this.getDecodeParams();
        if (filters instanceof COSName) {
            newBytes = this.doDecode((COSName)filters, options.asDictionary(), this.encodedBytes, 0, this.getAnyLength());
        } else {
            byte[] temp = this.encodedBytes;
            int length = this.getAnyLength();
            int i = 0;
            while (i < ((COSArray)filters).size()) {
                COSName filter;
                COSObject option = COSNull.NULL;
                if (!options.isNull()) {
                    option = ((COSArray)options).get(i);
                }
                if ((temp = this.doDecode(filter = ((COSArray)filters).get(i).asName(), option.asDictionary(), temp, 0, length)) != null) {
                    length = temp.length;
                }
                ++i;
            }
            newBytes = temp;
        }
        return newBytes;
    }

    protected byte[] doDecode(COSName filterName, COSDictionary options, byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            return new byte[0];
        }
        IFilter filter = FilterFactory.get().createFilter(filterName, options);
        filter.setStream(this);
        return filter.decode(bytes, offset, length);
    }

    protected void doEncode() throws IOException {
        if (this.decodedBytes == null) {
            return;
        }
        COSObject filters = this.getFilters();
        if (filters.isNull()) {
            this.encodedBytes = this.decodedBytes;
            return;
        }
        COSObject options = this.getDecodeParams();
        if (filters instanceof COSName) {
            this.encodedBytes = this.doEncode((COSName)filters, options.asDictionary(), this.decodedBytes, 0, this.decodedBytes.length);
        } else {
            byte[] temp = this.decodedBytes;
            int length = this.decodedBytes.length;
            int i = ((COSArray)filters).size() - 1;
            while (i >= 0) {
                COSDictionary option = null;
                if (!options.isNull()) {
                    option = ((COSArray)options).get(i).asDictionary();
                }
                COSName filter = ((COSArray)filters).get(i).asName();
                temp = this.doEncode(filter, option, temp, 0, length);
                length = temp.length;
                --i;
            }
            this.encodedBytes = temp;
        }
    }

    protected byte[] doEncode(COSName filterName, COSDictionary options, byte[] bytes, int offset, int length) throws IOException {
        if (bytes == null) {
            return new byte[0];
        }
        IFilter filter = FilterFactory.get().createFilter(filterName, options);
        filter.setStream(this);
        return filter.encode(bytes, offset, length);
    }

    public boolean equals(Object o) {
        return this.equals(o, new COSDocumentElement.PairRegister());
    }

    @Override
    protected boolean equals(Object o, COSDocumentElement.PairRegister visited) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        COSStream other = (COSStream)o;
        if (visited.check(this, other)) {
            return true;
        }
        return this.getDict().equals(other.getDict(), visited) && Arrays.equals(this.getEncodedBytes(), other.getEncodedBytes());
    }

    public void filter(COSName name) {
        this.addFilter(0, name, null);
    }

    public void filter(COSName name, COSDictionary dictionary) {
        this.addFilter(0, name, dictionary);
    }

    public int getAnyLength() {
        int result = this.getLength();
        if (result == -1) {
            return this.encodedBytes.length;
        }
        return result;
    }

    public byte[] getDecodedBytes() {
        if (this.decodedBytes == null) {
            try {
                this.decodedBytes = this.doDecode();
            }
            catch (IOException e) {
                this.handleException(new COSRuntimeException("error decoding stream", e));
            }
        }
        return this.decodedBytes;
    }

    public byte[] getDecodedBytesWritable() {
        byte[] bytes;
        try {
            bytes = this.doDecode();
            if (bytes != this.encodedBytes) {
                return bytes;
            }
        }
        catch (IOException e) {
            this.handleException(new COSRuntimeException("error decoding stream", e));
            return new byte[0];
        }
        byte[] copiedBytes = new byte[bytes.length];
        System.arraycopy(bytes, 0, copiedBytes, 0, bytes.length);
        return copiedBytes;
    }

    public COSObject getDecodeParams() {
        return COSStream.getDecodeParams(this.getDict());
    }

    public COSDictionary getDecodeParams(COSName name) {
        return COSStream.getDecodeParams(this.getDict(), name);
    }

    public COSDictionary getDict() {
        return this.dict;
    }

    public byte[] getEncodedBytes() {
        if (this.encodedBytes == null) {
            try {
                this.doEncode();
            }
            catch (IOException e) {
                this.handleException(new COSRuntimeException("error encoding stream", e));
            }
            int length = this.encodedBytes == null ? 0 : this.encodedBytes.length;
            this.getDict().basicPutSilent(DK_Length, COSInteger.create(length));
        }
        return this.encodedBytes;
    }

    public COSObject getFilters() {
        return COSStream.getFilters(this.getDict());
    }

    public int getFilterSize() {
        COSObject filter = this.getFilters();
        if (filter.isNull()) {
            return 0;
        }
        if (filter.asName() != null) {
            return 1;
        }
        return filter.asArray().size();
    }

    public COSDictionary getFirstDecodeParam() {
        COSObject dictionaryOrArray = this.getDecodeParams();
        if (dictionaryOrArray.isNull()) {
            return null;
        }
        if (dictionaryOrArray instanceof COSDictionary) {
            return (COSDictionary)dictionaryOrArray;
        }
        if (dictionaryOrArray instanceof COSArray) {
            return ((COSArray)dictionaryOrArray).get(0).asDictionary();
        }
        return null;
    }

    public COSName getFirstFilter() {
        COSObject nameOrArray = this.getFilters();
        if (nameOrArray.isNull()) {
            return null;
        }
        if (nameOrArray instanceof COSName) {
            return (COSName)nameOrArray;
        }
        if (nameOrArray instanceof COSArray) {
            return ((COSArray)nameOrArray).get(0).asName();
        }
        return null;
    }

    public int getLength() {
        COSInteger length = this.dict.get(DK_Length).asInteger();
        if (length != null) {
            return ((COSNumber)length).intValue();
        }
        return -1;
    }

    public boolean hasFilter(COSName name) {
        return COSStream.hasFilter(this.getDict(), name);
    }

    private boolean isBytesArrayEmpty(byte[] toTest) {
        if (toTest == null || toTest.length == 0) {
            return true;
        }
        return toTest.length == 2 && toTest[0] == 13 && toTest[1] == 10;
    }

    public boolean isExternal() {
        return COSStream.isExternal(this.getDict());
    }

    @Override
    public Iterator<COSObject> iterator() {
        return new SingleObjectIterator((Object)this.getDict());
    }

    protected void parseFKeyedFile() {
        byte[] content;
        COSObject fileSpec = this.dict.get(DK_F);
        String filepath = "";
        if (!(fileSpec instanceof COSString)) {
            return;
        }
        filepath = ((COSString)fileSpec).stringValue();
        File externalFile = new File(filepath);
        if (!externalFile.exists()) {
            return;
        }
        try {
            content = FileTools.toBytes((File)externalFile);
        }
        catch (IOException e) {
            return;
        }
        if (content != null) {
            this.encodedBytes = content;
        }
    }

    public void removeFilters() {
        this.getDecodedBytes();
        this.encodedBytes = null;
        this.getDict().remove(DK_Filter);
    }

    @Override
    public void removeObjectListener(ICOSObjectListener listener) {
        super.removeObjectListener(listener);
        if (this.dict != null) {
            this.dict.removeObjectListener(listener);
        }
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        COSStream stream = (COSStream)object;
        this.encodedBytes = stream.encodedBytes;
        this.decodedBytes = stream.decodedBytes;
        this.triggerChanged(null, null, null);
    }

    public Object saveState() {
        COSStream result = new COSStream();
        result.encodedBytes = this.encodedBytes;
        result.decodedBytes = this.decodedBytes;
        result.container = this.container.saveStateContainer();
        return result;
    }

    public void setDecodedBytes(byte[] newBytes) {
        this.willChange(this);
        this.basicSetDecodedBytes(newBytes);
        this.getDict().remove(DK_Length);
        if (this.objectListeners != null) {
            this.triggerChanged(SLOT_BYTES, null, null);
        }
    }

    private void setDict(COSDictionary dictionary) {
        if (dictionary.isIndirect()) {
            throw new IllegalArgumentException("stream dictionary cannot be indirect");
        }
        this.dict = dictionary;
        this.dict.addContainer(this);
    }

    public void setEncodedBytes(byte[] newBytes) {
        this.willChange(this);
        this.basicSetEncodedBytes(newBytes);
        if (this.objectListeners != null) {
            this.triggerChanged(SLOT_BYTES, null, null);
        }
    }
}

