/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSPrimitiveObject;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.encoding.PDFDocEncoding;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.string.StringTools;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class COSString
extends COSPrimitiveObject
implements Comparable {
    private static String LINE_SEPARATOR = StringTools.LS;
    private String encoding;
    private byte[] bytes;
    private int hash = 0;
    private boolean hexMode = false;
    private byte offset = 0;
    private String string;

    public static COSString create(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        return new COSString(bytes, null);
    }

    public static COSString create(byte[] bytes, String encoding) {
        if (bytes == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        return new COSString(bytes, encoding);
    }

    public static COSString create(String string) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        if (PDFDocEncoding.UNIQUE.isEncodable(string)) {
            return new COSString(string, null);
        }
        return new COSString(string, "UTF-16BE");
    }

    public static COSString create(String string, String encoding) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        return new COSString(string, encoding);
    }

    public static COSString createHex(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        COSString result = new COSString(bytes, null);
        result.setHexMode(true);
        return result;
    }

    public static COSString createHex(byte[] bytes, String encoding) {
        if (bytes == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        COSString result = new COSString(bytes, encoding);
        result.setHexMode(true);
        return result;
    }

    public static COSString createHex(String string) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        if (PDFDocEncoding.UNIQUE.isEncodable(string)) {
            COSString result = new COSString(string, null);
            result.setHexMode(true);
            return result;
        }
        COSString result = new COSString(string, "UTF-16BE");
        result.setHexMode(true);
        return result;
    }

    public static COSString createHex(String string, String encoding) {
        if (string == null) {
            throw new NullPointerException("COSString value can't be null");
        }
        COSString result = new COSString(string, encoding);
        result.setHexMode(true);
        return result;
    }

    public static COSString createMultiLine(String string) {
        return COSString.create(COSString.toPDFString(string));
    }

    public static String toJavaString(String value) {
        StringBuilder result = new StringBuilder();
        int length = value.length();
        boolean crFound = false;
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (c == '\r') {
                if (crFound) {
                    result.append(LINE_SEPARATOR);
                }
                crFound = true;
            } else if (c == '\n') {
                result.append(LINE_SEPARATOR);
                crFound = false;
            } else {
                if (crFound) {
                    result.append(LINE_SEPARATOR);
                }
                result.append(c);
                crFound = false;
            }
            ++i;
        }
        if (crFound) {
            result.append(LINE_SEPARATOR);
        }
        return result.toString();
    }

    public static String toPDFString(String value) {
        StringBuilder result = new StringBuilder();
        int length = value.length();
        boolean ignoreLn = false;
        int i = 0;
        while (i < length) {
            char c = value.charAt(i);
            if (c == '\n') {
                if (!ignoreLn) {
                    result.append('\r');
                }
            } else {
                result.append(c);
            }
            ignoreLn = c == '\r';
            ++i;
        }
        return result.toString();
    }

    protected COSString() {
    }

    protected COSString(byte[] bytes, String encoding) {
        this.bytes = bytes;
        this.encoding = encoding;
    }

    protected COSString(String string, String encoding) {
        this.string = string;
        this.encoding = encoding;
    }

    @Override
    public Object accept(ICOSObjectVisitor visitor) throws COSVisitorException {
        return visitor.visitFromString(this);
    }

    @Override
    public COSString asString() {
        return this;
    }

    @Override
    protected String basicToString() {
        if (this.isHexMode()) {
            return "<" + this.hexStringValue() + ">";
        }
        return "(" + this.stringValue() + ")";
    }

    public byte[] byteValue() {
        if (this.bytes == null) {
            this.bytes = this.encode();
        }
        return this.bytes;
    }

    public void clearBytes() {
        if (this.bytes == null) {
            return;
        }
        this.decode();
        this.bytes = null;
    }

    public void clearString() {
        if (this.string == null) {
            return;
        }
        this.encode();
        this.string = null;
    }

    public int compareTo(Object o) {
        if (!(o instanceof COSString)) {
            throw new ClassCastException("must compare with a COSString");
        }
        byte[] thisBytes = this.byteValue();
        byte[] otherBytes = ((COSString)o).byteValue();
        int i = 0;
        while (i < thisBytes.length && i < otherBytes.length) {
            if (thisBytes[i] < otherBytes[i]) {
                return -1;
            }
            if (thisBytes[i] > otherBytes[i]) {
                return 1;
            }
            ++i;
        }
        if (thisBytes.length < otherBytes.length) {
            return -1;
        }
        if (thisBytes.length > otherBytes.length) {
            return 1;
        }
        return 0;
    }

    @Override
    protected COSObject copyBasic() {
        COSString result = new COSString();
        result.bytes = this.bytes;
        result.hash = this.hash;
        result.hexMode = this.hexMode;
        result.string = this.string;
        result.encoding = this.encoding;
        result.offset = this.offset;
        return result;
    }

    protected String decode() {
        this.testBuiltinEncoding();
        if (this.encoding != null) {
            try {
                return new String(this.bytes, (int)this.offset, this.bytes.length - this.offset, this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                return PDFDocEncoding.UNIQUE.decode(this.bytes);
            }
        }
        return PDFDocEncoding.UNIQUE.decode(this.bytes);
    }

    protected byte[] encode() {
        if (this.encoding != null) {
            if ("UTF-16BE".equals(this.encoding)) {
                byte[] tempBytes;
                try {
                    tempBytes = this.string.getBytes("UTF-16BE");
                }
                catch (UnsupportedEncodingException e) {
                    return PDFDocEncoding.UNIQUE.encode(this.string);
                }
                byte[] resultBytes = new byte[tempBytes.length + 2];
                resultBytes[0] = -2;
                resultBytes[1] = -1;
                System.arraycopy(tempBytes, 0, resultBytes, 2, tempBytes.length);
                return resultBytes;
            }
            if ("UTF-16LE".equals(this.encoding)) {
                byte[] tempBytes;
                try {
                    tempBytes = this.string.getBytes("UTF-16LE");
                }
                catch (UnsupportedEncodingException e) {
                    return PDFDocEncoding.UNIQUE.encode(this.string);
                }
                byte[] resultBytes = new byte[tempBytes.length + 2];
                resultBytes[0] = -1;
                resultBytes[1] = -2;
                System.arraycopy(tempBytes, 0, resultBytes, 2, tempBytes.length);
                return resultBytes;
            }
            try {
                return this.string.getBytes(this.encoding);
            }
            catch (UnsupportedEncodingException e) {
                return PDFDocEncoding.UNIQUE.encode(this.string);
            }
        }
        return PDFDocEncoding.UNIQUE.encode(this.string);
    }

    public boolean equals(Object o) {
        if (!(o instanceof COSString)) {
            return false;
        }
        return Arrays.equals(this.byteValue(), ((COSString)o).byteValue());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public int hashCode() {
        if (this.bytes == null) {
            return super.hashCode();
        }
        int h = this.hash;
        if (h == 0) {
            int i = 0;
            while (i < this.bytes.length) {
                h = 31 * h + this.bytes[i];
                ++i;
            }
            this.hash = h;
        }
        return h;
    }

    public String hexStringValue() {
        return HexTools.bytesToHexString((byte[])this.byteValue());
    }

    public boolean isHexMode() {
        return this.hexMode;
    }

    public String multiLineStringValue() {
        return COSString.toJavaString(this.stringValue());
    }

    @Override
    public void restoreState(Object object) {
        super.restoreState(object);
        COSString cosString = (COSString)object;
        this.bytes = cosString.bytes;
        this.hash = cosString.hash;
        this.hexMode = cosString.hexMode;
        this.string = cosString.string;
    }

    public Object saveState() {
        COSString result = new COSString();
        result.bytes = this.bytes;
        result.hash = this.hash;
        result.hexMode = this.hexMode;
        result.string = this.string;
        result.encoding = this.encoding;
        result.offset = this.offset;
        result.container = this.container.saveStateContainer();
        return result;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setHexMode(boolean newHexMode) {
        this.hexMode = newHexMode;
    }

    @Override
    public String stringValue() {
        if (this.string == null) {
            this.string = this.decode();
        }
        return this.string;
    }

    protected void testBuiltinEncoding() {
        if (this.bytes.length < 2) {
            return;
        }
        if (this.bytes[0] == -2 && this.bytes[1] == -1) {
            this.offset = (byte)2;
            this.encoding = "UTF-16BE";
        } else if (this.bytes[0] == -1 && this.bytes[1] == -2) {
            this.offset = (byte)2;
            this.encoding = "UTF-16LE";
        }
    }
}

