/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.crypt;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.crypt.COSEncryption;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISecurityHandlerFactory;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR2;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR3;
import de.intarsys.pdf.crypt.StandardSecurityHandlerR4;

public class StandardSecurityHandlerFactory
implements ISecurityHandlerFactory {
    public static final COSName CN_Standard = COSName.constant("Standard");
    public static final COSName DK_R = COSName.constant("R");

    protected StandardSecurityHandlerFactory() {
    }

    @Override
    public ISecurityHandler getSecurityHandler(COSEncryption encryption) throws COSSecurityException {
        COSName name = encryption.getFilter();
        if (name == null) {
            throw new COSSecurityException("security handler not specified");
        }
        if (name.equals(CN_Standard)) {
            int revision = encryption.getFieldInt(DK_R, 0);
            if (revision == 2) {
                return new StandardSecurityHandlerR2();
            }
            if (revision == 3) {
                return new StandardSecurityHandlerR3();
            }
            if (revision == 4) {
                return new StandardSecurityHandlerR4();
            }
            return new StandardSecurityHandlerR2();
        }
        throw new COSSecurityException("no security handler '" + name.stringValue() + "'");
    }
}

