/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.GlyphNameMap;
import java.util.HashMap;
import java.util.Map;

public class MappedEncoding
extends Encoding {
    private static final int ARRAY_MAPPING_SIZE = 256;
    private Map indexedEncoding = new HashMap();
    private Map namedEncoding = new HashMap();
    private int[] fastEncoding = new int[256];
    private int[] indexDecoding = new int[256];
    private String[] nameDecoding = new String[256];

    public MappedEncoding() {
        int i = 0;
        while (i < 256) {
            this.fastEncoding[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.indexDecoding.length) {
            this.indexDecoding[i] = -1;
            ++i;
        }
        i = 0;
        while (i < this.nameDecoding.length) {
            this.nameDecoding[i] = ".notdef";
            ++i;
        }
    }

    public void addEncoding(int codePoint, String name) {
        int unicode = GlyphNameMap.Standard.getUnicode(name);
        this.defineEntry(codePoint, unicode, name);
    }

    public void addEncoding(int codePoint, String name, int character) {
        this.defineEntry(codePoint, character, name);
    }

    @Override
    public COSObject cosGetObject() {
        return null;
    }

    protected void defineEntry(int codepoint, int character, String name) {
        this.nameDecoding[codepoint] = name;
        Integer codePointInteger = new Integer(codepoint);
        this.namedEncoding.put(name, codePointInteger);
        this.indexDecoding[codepoint] = character;
        this.indexedEncoding.put(new Integer(character), codePointInteger);
        if (character >= 0 && character < 256) {
            this.fastEncoding[character] = codepoint;
        }
    }

    @Override
    public int getDecoded(int byteValue) {
        return this.indexDecoding[byteValue];
    }

    @Override
    public int getEncoded(int character) {
        if (character >= 0 && character < 256) {
            return this.fastEncoding[character];
        }
        Integer ii = (Integer)this.indexedEncoding.get(new Integer(character));
        if (ii == null) {
            return -1;
        }
        return ii;
    }

    @Override
    public int getEncoded(String name) {
        Integer codePoint = (Integer)this.namedEncoding.get(name);
        if (codePoint == null) {
            return -1;
        }
        return codePoint;
    }

    @Override
    public String getGlyphName(int codePoint) {
        if (codePoint < 0 || codePoint > 255) {
            return ".notdef";
        }
        return this.nameDecoding[codePoint];
    }

    protected int[] getIndexDecoding() {
        return this.indexDecoding;
    }

    protected Map getIndexedEncoding() {
        return this.indexedEncoding;
    }

    @Override
    public String getName() {
        return "MappedEncoding";
    }

    protected String[] getNameDecoding() {
        return this.nameDecoding;
    }

    protected Map getNamedEncoding() {
        return this.namedEncoding;
    }
}

