/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.encoding;

import de.intarsys.pdf.encoding.Encoding;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class MappedReader
extends Reader {
    private Encoding encoding;
    private InputStream inStream;

    public MappedReader(InputStream is, Encoding encoding) {
        super(is);
        this.setInStream(is);
        this.setEncoding(encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.inStream == null) {
                return;
            }
            this.inStream.close();
            this.inStream = null;
        }
    }

    protected void ensureOpen() throws IOException {
        if (this.inStream == null) {
            throw new IOException("Stream closed");
        }
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            int stop = off + len;
            int c = 0;
            int i = off;
            while (true) {
                if (i >= stop) {
                    return len;
                }
                c = this.encoding.getNextDecoded(this.inStream);
                if (c == -1) {
                    if (i == off) {
                        return -1;
                    }
                    return i - off;
                }
                cbuf[i] = (char)c;
                ++i;
            }
        }
    }

    private void setEncoding(Encoding encoding) {
        this.encoding = encoding;
    }

    protected void setInStream(InputStream newInStream) {
        this.inStream = newInStream;
    }
}

