/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.fd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class FDObject
extends COSBasedObject {
    protected FDObject(COSObject object) {
        super(object);
    }

    protected void cosMoveField(COSName key, COSDictionary source, COSDictionary dest) {
        COSObject o = source.get(key);
        if (!o.isNull()) {
            source.remove(key);
            dest.put(key, o);
        }
    }

    protected List getFDObjects(COSName key, COSBasedObject.MetaClass metaclass) {
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            return null;
        }
        ArrayList<COSBasedObject> result = new ArrayList<COSBasedObject>();
        Iterator<COSObject> i = array.iterator();
        while (i.hasNext()) {
            result.add(metaclass.createFromCos(i.next()));
        }
        return result;
    }

    protected float[] getFloatArray(COSName key) {
        COSArray array = this.cosGetField(key).asArray();
        if (array == null) {
            return null;
        }
        float[] result = new float[array.size()];
        int i = 0;
        while (i < array.size()) {
            COSNumber num = (COSNumber)array.get(i);
            result[i] = num.floatValue();
            ++i;
        }
        return result;
    }

    protected void setFDObjects(COSName key, List list, boolean emptyArrayIfListEmpty) {
        if (list == null || list.isEmpty()) {
            if (emptyArrayIfListEmpty) {
                this.cosSetField(key, COSArray.create());
            } else {
                this.cosRemoveField(key);
            }
            return;
        }
        COSArray a = COSArray.create();
        this.cosSetField(key, a);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            a.add(((FDObject)i.next()).cosGetObject());
        }
    }

    protected void setFloatArray(COSName key, float[] array, boolean emptyArrayIfListEmpty) {
        if (array == null || array.length == 0) {
            if (emptyArrayIfListEmpty) {
                this.cosSetField(key, COSArray.create());
            } else {
                this.cosRemoveField(key);
            }
            return;
        }
        COSArray a = COSArray.create();
        this.cosSetField(key, a);
        int i = 0;
        while (i < array.length) {
            a.add(COSFixed.create(array[i]));
            ++i;
        }
    }

    @Override
    public String toString() {
        String result = "[]";
        if (this.cosGetObject().isIndirect()) {
            result = "[" + this.cosGetObject().getIndirectObject().toString() + "]";
        }
        return result;
    }

    public static abstract class MetaClass
    extends COSBasedObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }
    }
}

