/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ASCII85OutputStream
extends FilterOutputStream {
    private static final long HIGH_VALUE = 0xFFFFFFFFL;
    private static final long CONST_85 = 85L;
    private byte[] indata = new byte[4];
    private byte[] outdata = new byte[5];
    private boolean flushed = true;
    private int count = 0;
    private int lineBreak = 72;
    private int maxline = 72;

    public ASCII85OutputStream(OutputStream out) {
        super(out);
    }

    public void setLineLength(int l) {
        if (this.lineBreak > l) {
            this.lineBreak = l;
        }
        this.maxline = l;
    }

    public int getLineLength() {
        return this.maxline;
    }

    @Override
    public final void flush() throws IOException {
        if (this.flushed) {
            return;
        }
        if (this.count > 0) {
            int i = this.count;
            while (i < 4) {
                this.indata[i] = 0;
                ++i;
            }
            this.transform();
            if (this.outdata[0] == 122) {
                i = 0;
                while (i < 5) {
                    this.outdata[i] = 33;
                    ++i;
                }
            }
            i = 0;
            while (i < this.count + 1) {
                this.out.write(this.outdata[i]);
                if (--this.lineBreak == 0) {
                    this.out.write(10);
                    this.lineBreak = this.maxline;
                }
                ++i;
            }
        }
        if (--this.lineBreak == 0) {
            this.out.write(10);
        }
        this.count = 0;
        this.lineBreak = this.maxline;
        this.flushed = true;
        super.flush();
    }

    @Override
    public void write(int b) throws IOException {
        this.flushed = false;
        this.indata[this.count++] = (byte)b;
        if (this.count < 4) {
            return;
        }
        this.transform();
        int i = 0;
        while (i < 5) {
            if (this.outdata[i] == 0) break;
            this.out.write(this.outdata[i]);
            if (--this.lineBreak == 0) {
                this.out.write(10);
                this.lineBreak = this.maxline;
            }
            ++i;
        }
        this.count = 0;
    }

    @Override
    public final void write(byte[] b, int off, int sz) throws IOException {
        int i = 0;
        while (i < sz) {
            if (this.count < 3) {
                this.indata[this.count++] = b[off + i];
            } else {
                this.write(b[off + i]);
            }
            ++i;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
            this.out.write(126);
            this.out.write(62);
            this.out.write(10);
            super.close();
        }
        finally {
            this.indata = null;
            this.outdata = null;
        }
    }

    protected void transform() {
        long word = (long)((this.indata[0] << 8 | this.indata[1] & 0xFF) << 16 | (this.indata[2] & 0xFF) << 8 | this.indata[3] & 0xFF) & 0xFFFFFFFFL;
        if (word == 0L) {
            this.outdata[0] = 122;
            this.outdata[1] = 0;
            return;
        }
        long x = word / 52200625L;
        this.outdata[0] = (byte)(x + 33L);
        word -= x * 85L * 85L * 85L * 85L;
        x = word / 614125L;
        this.outdata[1] = (byte)(x + 33L);
        word -= x * 85L * 85L * 85L;
        x = word / 7225L;
        this.outdata[2] = (byte)(x + 33L);
        word -= x * 85L * 85L;
        x = word / 85L;
        this.outdata[3] = (byte)(x + 33L);
        this.outdata[4] = (byte)(word % 85L + 33L);
    }
}

