/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.filter.IPrediction;
import de.intarsys.pdf.filter.PredictionFactory;
import de.intarsys.pdf.filter.StreamBasedFilter;
import de.intarsys.tools.pool.GenericPool;
import de.intarsys.tools.pool.IPool;
import de.intarsys.tools.pool.IPoolObjectFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class FlateFilter
extends StreamBasedFilter {
    private static IPoolObjectFactory deflaterFactory = new IPoolObjectFactory(){

        public void destroyObject(Object obj) throws Exception {
            ((Deflater)obj).end();
        }

        public void deactivateObject(Object obj) throws Exception {
            ((Deflater)obj).reset();
        }

        public Object createObject() throws Exception {
            return new Deflater();
        }

        public void activateObject(Object obj) throws Exception {
        }
    };
    private static IPoolObjectFactory inflaterFactory = new IPoolObjectFactory(){

        public void destroyObject(Object obj) throws Exception {
            ((Inflater)obj).end();
        }

        public void deactivateObject(Object obj) throws Exception {
            ((Inflater)obj).reset();
        }

        public Object createObject() throws Exception {
            return new Inflater();
        }

        public void activateObject(Object obj) throws Exception {
        }
    };
    private static IPool DeflaterPool = new GenericPool(deflaterFactory);
    private static IPool InflaterPool = new GenericPool(inflaterFactory);

    public FlateFilter(COSDictionary options) {
        super(options);
    }

    @Override
    protected InputStream createInputFilterStream(InputStream is) throws IOException {
        Inflater inflater = FlateFilter.borrowInflater();
        return new PDFInflaterOutputStream(is, inflater, 1024);
    }

    @Override
    protected OutputStream createOutputFilterStream(OutputStream os) throws IOException {
        Deflater deflater = FlateFilter.borrowDeflater();
        return new PDFDeflaterOutputStream(os, deflater, 1024);
    }

    protected static Deflater borrowDeflater() throws IOException {
        try {
            return (Deflater)DeflaterPool.checkout(-1L);
        }
        catch (Exception e) {
            IOException ioe = new IOException("can't create deflater");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected static Inflater borrowInflater() throws IOException {
        try {
            return (Inflater)InflaterPool.checkout(-1L);
        }
        catch (Exception e) {
            IOException ioe = new IOException("can't create inflater");
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected static void returnInflater(Object inflater) {
        try {
            InflaterPool.checkin(inflater);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void returnDeflater(Object deflater) {
        try {
            DeflaterPool.checkin(deflater);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected byte[] decode(byte[] source) throws IOException {
        if (source == null || source.length == 0) {
            return new byte[0];
        }
        byte[] decoded = super.decode(source);
        if (this.getOptions() == null) {
            return decoded;
        }
        IPrediction prediction = PredictionFactory.get().createPrediction(this.getOptions());
        return prediction.decode(decoded);
    }

    static class PDFDeflaterOutputStream
    extends DeflaterOutputStream {
        public PDFDeflaterOutputStream(OutputStream out, Deflater def, int size) {
            super(out, def, size);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FlateFilter.returnDeflater(this.def);
        }
    }

    static class PDFInflaterOutputStream
    extends InflaterInputStream {
        public PDFInflaterOutputStream(InputStream in, Inflater inf, int size) {
            super(in, inf, size);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FlateFilter.returnInflater(this.inf);
        }
    }
}

