/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RunLengthInputStream
extends FilterInputStream {
    private byte[] buffer = new byte[128];
    private int length = 0;
    private int pos = 0;

    public RunLengthInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int available() throws IOException {
        throw new IOException("method not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.pos >= this.length) {
            int i = this.in.read();
            if (i == -1 || i == 128) {
                return -1;
            }
            this.pos = 0;
            if (i <= 127) {
                this.length = i + 1;
                int index = 0;
                while (index < this.length) {
                    int count = this.in.read(this.buffer, index, this.length - index);
                    if (count == -1) {
                        this.length = index;
                        continue;
                    }
                    index += count;
                }
            } else {
                this.length = 257 - i;
                int copy = this.in.read();
                if (copy == -1) {
                    this.length = 0;
                }
                int index = 0;
                while (index < this.length) {
                    this.buffer[index++] = (byte)copy;
                }
            }
            return this.read();
        }
        return this.buffer[this.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c != -1) {
                    if (b != null) {
                        b[off + i] = (byte)c;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return i;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("method not supported");
    }

    @Override
    public long skip(long n) throws IOException {
        throw new IOException("method not supported");
    }
}

