/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectWalkerDeep;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CIDFontType2;
import de.intarsys.pdf.font.CIDSystemInfo;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontOutlet;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.tools.attribute.Attribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PDFontTools {
    private static final Attribute ATTR_CIDFONT = new Attribute("cidfont");
    private static final Attribute ATTR_CREATEDFONTS = new Attribute("createdfonts");
    private static final Attribute ATTR_TYPE0FONT = new Attribute("type0font");

    protected static void collectFonts(Set fonts, CSContent content, PDResources resources, final boolean considerTR) {
        final HashSet fontNames = new HashSet();
        CSInterpreter collector = new CSInterpreter(new HashMap()){
            private COSName fontName;
            private int renderingMode;
            {
                super($anonymous0);
                this.renderingMode = 0;
            }

            @Override
            protected void handleError(CSError error) throws CSException {
            }

            protected void handleText() {
                if (this.renderingMode != 3 || !considerTR) {
                    fontNames.add(this.fontName);
                }
            }

            @Override
            protected void handleWarning(CSWarning warning) throws CSException {
            }

            @Override
            protected void notSupported(CSOperation operation) throws CSException {
            }

            @Override
            protected void render_DoubleQuote(CSOperation operation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_Quote(CSOperation operation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_Tf(CSOperation operation) throws CSException {
                if (operation.operandSize() == 2) {
                    this.fontName = operation.getOperand(0).asName();
                }
            }

            @Override
            protected void render_Tj(CSOperation operation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_TJ(CSOperation operation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_Tr(CSOperation operation) throws CSException {
                COSInteger mode = (COSInteger)operation.getOperand(0);
                this.renderingMode = mode.intValue();
            }
        };
        collector.process(content, resources);
        for (COSName fontName : fontNames) {
            fonts.add(resources.getFontResource(fontName));
        }
    }

    public static PDFont createBuiltinFont(String name) {
        PDFontType1 font = PDFontType1.createNew(name);
        if (font.getFontDescriptor().isNonsymbolic()) {
            font.setEncoding(WinAnsiEncoding.UNIQUE);
        }
        return font;
    }

    protected static CIDFont createCIDFont(PDFont font) {
        if (font instanceof PDFontTrueType) {
            CIDFontType2 result = (CIDFontType2)CIDFontType2.META.createNew();
            result.cosSetField(PDFont.DK_BaseFont, font.getBaseFont().copyShallow());
            CIDSystemInfo info = (CIDSystemInfo)CIDSystemInfo.META.createNew();
            int width = font.getMissingWidth();
            if (width == 0) {
                width = 1000;
            }
            result.setDefaultGlyphWidth(width);
            result.setCIDSystemInfo(info);
            result.setFontDescriptor(font.getFontDescriptor());
            return result;
        }
        boolean cfr_ignored_0 = font instanceof PDFontType1;
        return null;
    }

    protected static PDFont createType0Font(PDFont font) {
        PDFont result;
        if (font instanceof PDFontType0) {
            result = font;
        } else {
            CIDFont cidFont = PDFontTools.getCIDFont(font);
            if (cidFont == null) {
                result = font;
            } else {
                PDFontType0 type0Font = (PDFontType0)PDFontType0.META.createNew();
                type0Font.cosSetField(PDFont.DK_BaseFont, font.getBaseFont().copyShallow());
                type0Font.setDescendantFont(cidFont);
                result = type0Font;
            }
        }
        return result;
    }

    protected static CIDFont getCIDFont(PDFont font) {
        CIDFont cidFont = (CIDFont)font.getAttribute(ATTR_CIDFONT);
        if (cidFont == null) {
            cidFont = PDFontTools.createCIDFont(font);
            font.setAttribute(ATTR_CIDFONT, cidFont);
        }
        return cidFont;
    }

    public static PDFont getFont(PDDocument document, PDResources resources, COSName name) {
        PDFont font;
        if (resources != null && (font = resources.getFontResource(name)) != null) {
            return font;
        }
        if (name != null) {
            return PDFontTools.lookupFont(document, name.stringValue());
        }
        return null;
    }

    public static PDFont getFont(PDResources resources, COSName name) {
        return PDFontTools.getFont(resources.getDoc(), resources, name);
    }

    public static List getFonts(PDDocument doc) {
        final ArrayList result = new ArrayList();
        try {
            COSDictionary trailer = doc.cosGetDoc().stGetDoc().cosGetTrailer();
            COSObjectWalkerDeep visitor = new COSObjectWalkerDeep(){

                @Override
                protected void handleException(RuntimeException e) throws COSVisitorException {
                }

                @Override
                public Object visitFromDictionary(COSDictionary dict) throws COSVisitorException {
                    try {
                        PDFont font = (PDFont)PDFont.META.createFromCos(dict);
                        if (font != null) {
                            result.add(font);
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return super.visitFromDictionary(dict);
                }
            };
            trailer.accept(visitor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static float getGlyphHeight(PDFont font) {
        CDSRectangle rect = font.getFontDescriptor().getFontBB();
        float scaledHeight = rect.getUpperRightY() - rect.getLowerLeftY();
        return scaledHeight /= 1000.0f;
    }

    public static float getGlyphHeightScaled(PDFont font, float size) {
        CDSRectangle rect = font.getFontDescriptor().getFontBB();
        float scaledHeight = rect.getUpperRightY() - rect.getLowerLeftY();
        scaledHeight = size * scaledHeight / 1000.0f;
        return scaledHeight;
    }

    public static int getGlyphWidthEncoded(PDFont font, byte[] codepoints, int offset, int length) {
        ByteArrayInputStream is = new ByteArrayInputStream(codepoints, offset, length);
        Encoding encoding = font.getEncoding();
        int result = 0;
        try {
            int codepoint = encoding.getNextEncoded(is);
            while (codepoint != -1) {
                result += font.getGlyphWidthEncoded(codepoint);
                codepoint = encoding.getNextEncoded(is);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static float getGlyphWidthEncodedScaled(PDFont font, float size, byte[] codepoints, int offset, int length) {
        float width = PDFontTools.getGlyphWidthEncoded(font, codepoints, offset, length);
        return size * width / 1000.0f;
    }

    public static PDFont getType0Font(PDFont font) {
        PDFont result = (PDFont)font.getAttribute(ATTR_TYPE0FONT);
        if (result == null) {
            result = PDFontTools.createType0Font(font);
            font.setAttribute(ATTR_TYPE0FONT, result);
        }
        return result;
    }

    public static List getUsedFonts(PDDocument doc, boolean considerTR) {
        HashSet fonts = new HashSet();
        for (PDPage page = doc.getPageTree().getFirstPage(); page != null; page = page.getNextPage()) {
            CSContent contentstream = page.getContentStream();
            if (contentstream == null) continue;
            PDFontTools.collectFonts(fonts, contentstream, page.getResources(), considerTR);
        }
        Iterator<COSObject> it = doc.cosGetDoc().objects();
        while (it.hasNext()) {
            try {
                PDForm form;
                COSObject object = it.next();
                COSDictionary dict = COSTools.toDictionary(object);
                if (dict == null) continue;
                if (dict.get(PDObject.DK_Subtype).equals(PDForm.CN_Subtype_Form) && (form = (PDForm)PDForm.META.createFromCos(object)) != null) {
                    PDFontTools.collectFonts(fonts, form.getContentStream(), form.getResources(), considerTR);
                }
                if (!dict.get(PDPattern.DK_PatternType).equals(COSInteger.create(1))) continue;
                CSContent patternCS = CSContent.createFromCos((COSStream)object);
                COSDictionary r = dict.get(PDForm.DK_Resources).asDictionary();
                PDResources resources = (PDResources)PDResources.META.createFromCos(r);
                PDFontTools.collectFonts(fonts, patternCS, resources, considerTR);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return new ArrayList(fonts);
    }

    protected static PDFont lookupFont(PDDocument document, String name) {
        PDFont font = null;
        IFontFactory factory = FontOutlet.get().lookupFontFactory(document);
        FontQuery query = new FontQuery(name);
        try {
            font = factory.getFont(query);
        }
        catch (FontFactoryException fontFactoryException) {
            // empty catch block
        }
        if (font == null) {
            font = PDFontTools.createBuiltinFont(name);
            factory.registerFont(font);
        }
        return font;
    }
}

