/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.font.CMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;

public class PDGlyphs
implements IAttributeSupport {
    private final AttributeMap attributes = new AttributeMap();
    private final int codepoint;
    private final PDFont font;
    private Boolean whitespace;
    private float width;

    public PDGlyphs(PDFont font, int codepoint) {
        this.font = font;
        this.codepoint = codepoint;
        this.width = font.getGlyphWidthEncoded(codepoint);
    }

    public double getAscent() {
        return this.font.getFontDescriptor().getAscent();
    }

    public final Object getAttribute(Object key) {
        return this.attributes.getAttribute(key);
    }

    public char[] getChars() {
        CMap toUnicode = this.font.getToUnicode();
        if (toUnicode == null) {
            return new char[]{(char)this.font.getEncoding().getDecoded(this.codepoint)};
        }
        return toUnicode.getChars(this.codepoint);
    }

    public int getCodepoint() {
        return this.codepoint;
    }

    public int getDecoded() {
        return this.font.getEncoding().getDecoded(this.codepoint);
    }

    public double getDescent() {
        return this.font.getFontDescriptor().getDescent();
    }

    public PDFont getFont() {
        return this.font;
    }

    public String getGlyphName() {
        return this.font.getEncoding().getGlyphName(this.codepoint);
    }

    public int getUnicode() {
        try {
            CMap toUnicode = this.font.getToUnicode();
            if (toUnicode == null) {
                return this.font.getEncoding().getDecoded(this.codepoint);
            }
            return toUnicode.getDecoded(this.codepoint);
        }
        catch (Exception e) {
            return this.font.getEncoding().getDecoded(this.codepoint);
        }
    }

    public float getWidth() {
        return this.width;
    }

    public boolean isWhitespace() {
        if (this.whitespace != null) {
            return this.whitespace;
        }
        int c = this.getDecoded();
        this.whitespace = c == 0 || c == 32;
        return this.whitespace;
    }

    public final Object removeAttribute(Object key) {
        return this.attributes.removeAttribute(key);
    }

    public void reset() {
        this.width = this.font.getGlyphWidthEncoded(this.codepoint);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.attributes.setAttribute(key, o);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("glyph ");
        sb.append((char)this.getUnicode());
        sb.append(", cp ");
        sb.append(this.codepoint);
        sb.append(", uc ");
        sb.append(this.getUnicode());
        return sb.toString();
    }
}

