/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDGlyphs;
import java.io.ByteArrayInputStream;
import java.util.Arrays;

public abstract class PDSingleByteFont
extends PDFont {
    private PDGlyphs[] cachedGlyphs = new PDGlyphs[256];
    private int[] cachedWidths;

    public PDSingleByteFont(COSObject object) {
        super(object);
    }

    @Override
    public PDGlyphs getGlyphsEncoded(int codepoint) {
        PDGlyphs glyphs = this.cachedGlyphs[codepoint];
        if (glyphs == null) {
            this.cachedGlyphs[codepoint] = glyphs = new PDGlyphs(this, codepoint);
        }
        return glyphs;
    }

    @Override
    public int getGlyphWidthEncoded(int codepoint) {
        if (this.cachedWidths == null) {
            this.cachedWidths = this.createWidths();
        }
        if (codepoint < 0 || codepoint > this.cachedWidths.length) {
            return this.getMissingWidth();
        }
        return this.cachedWidths[codepoint];
    }

    public int[] getGlyphWidths() {
        if (this.cachedWidths == null) {
            this.cachedWidths = this.createWidths();
        }
        return this.cachedWidths;
    }

    @Override
    public PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream is) {
        int codepoint = is.read();
        if (codepoint == -1) {
            return null;
        }
        return this.getGlyphsEncoded(codepoint);
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedWidths = null;
        Arrays.fill(this.cachedGlyphs, null);
    }
}

