/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.parser;

import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.COSLoadWarning;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class COSDocumentParser
extends PDFParser {
    public static final int SEARCH_BUFFER_SIZE = 2048;
    private STDocument doc;

    public COSDocumentParser(STDocument doc) {
        this.doc = doc;
    }

    @Override
    protected COSIndirectObject createObjectReference(IRandomAccess input) throws IOException, COSLoadException {
        COSObject obj1 = this.lookaheadPop();
        COSObject obj2 = this.lookaheadPop();
        if (!(obj1 instanceof COSInteger) || !(obj2 instanceof COSInteger)) {
            COSLoadError e = new COSLoadError("illegal reference at character index " + input.getOffset());
            this.handleError(e);
        }
        int objectNumber = ((COSInteger)obj1).intValue();
        int generationNumber = ((COSInteger)obj2).intValue();
        return this.getDoc().getObjectReference(objectNumber, generationNumber);
    }

    public STDocument getDoc() {
        return this.doc;
    }

    public boolean isTokenXRefAt(IRandomAccess input, int offset) throws IOException {
        input.seek((long)offset);
        this.readSpaces(input);
        byte[] token = new byte[4];
        input.read(token);
        return Arrays.equals(token, PDFParser.TOKEN_xref);
    }

    public COSObject parseIndirectObject(IRandomAccess input, ISystemSecurityHandler securityHandler) throws IOException, COSLoadException {
        COSObjectKey key = this.parseIndirectObjectKey(input);
        COSObjectKey oldObjectKey = this.getObjectKey();
        ISystemSecurityHandler oldSecurityHandler = this.getSecurityHandler();
        try {
            this.setObjectKey(key);
            this.setSecurityHandler(securityHandler);
            COSObject object = this.parseIndirectObjectBody(input);
            if (object == null) {
                object = COSNull.NULL;
            }
            COSObject cOSObject = object;
            return cOSObject;
        }
        finally {
            this.setObjectKey(oldObjectKey);
            this.setSecurityHandler(oldSecurityHandler);
        }
    }

    protected COSObject parseIndirectObjectBody(IRandomAccess input) throws IOException, COSLoadException {
        COSDocumentElement element = this.parseObject(input);
        if (element == null) {
            COSLoadError e = new COSLoadError("object expected at character index " + input.getOffset());
            this.handleError(e);
        } else {
            byte[] token;
            COSLoadError e;
            if (element.isReference()) {
                e = new COSLoadError("object reference not allowed in a indirect object at character index " + input.getOffset());
                this.handleError(e);
            }
            if (this.check) {
                ArrayList messages = new ArrayList();
                token = this.readToken(input, messages, false);
                if (!(messages.size() <= 0 || messages.size() == 1 && messages.contains("additional whitespace before") || messages.size() == 1 && messages.contains("second add whitespace after"))) {
                    COSLoadWarning pwarn = new COSLoadWarning("618b");
                    pwarn.setHint(new Long(input.getOffset()));
                    this.handleWarning(pwarn);
                }
            } else {
                token = this.readToken(input);
            }
            if (token == null) {
                e = new COSLoadError("unexpected end of file");
                this.handleError(e);
            }
            if (!Arrays.equals(token, TOKEN_endobj)) {
                input.seekBy((long)(-token.length));
                COSLoadWarning w = new COSLoadWarning("618c");
                this.handleWarning(w);
            }
        }
        return (COSObject)element;
    }

    protected COSObjectKey parseIndirectObjectKey(IRandomAccess input) throws IOException, COSLoadException {
        COSLoadWarning pwarn;
        COSLoadError e;
        ArrayList messages = new ArrayList();
        byte[] token = this.check ? this.readToken(input, messages, true) : this.readToken(input);
        if (token == null) {
            COSLoadError e2 = new COSLoadError("unexpected end of file");
            this.handleError(e2);
        }
        int objNumber = 0;
        try {
            objNumber = Integer.parseInt(new String(token));
            if (messages.size() > 1) {
                COSLoadWarning pwarn2 = new COSLoadWarning("618a");
                pwarn2.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn2);
            }
        }
        catch (NumberFormatException ex) {
            e = new COSLoadError("invalid object number at character index " + input.getOffset());
            this.handleError(e);
        }
        messages.clear();
        token = this.check ? this.readToken(input, messages, true) : this.readToken(input);
        if (token == null) {
            COSLoadError e3 = new COSLoadError("unexpected end of file");
            this.handleError(e3);
        }
        int genNumber = 0;
        try {
            genNumber = Integer.parseInt(new String(token));
            if (messages.size() > 1) {
                pwarn = new COSLoadWarning("618a");
                pwarn.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn);
            }
        }
        catch (NumberFormatException ex) {
            COSLoadError e4 = new COSLoadError("invalid generation number at character index " + input.getOffset());
            this.handleError(e4);
        }
        messages.clear();
        token = this.check ? this.readToken(input, messages, true) : this.readToken(input);
        if (token == null) {
            e = new COSLoadError("unexpected end of file");
            this.handleError(e);
        }
        if (!Arrays.equals(token, TOKEN_obj)) {
            input.seekBy((long)(-token.length));
            e = new COSLoadError("file format error, obj expected at character index " + input.getOffset());
            this.handleError(e);
        }
        if (this.check) {
            if (messages.size() > 0) {
                pwarn = new COSLoadWarning("618a");
                pwarn.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn);
            }
            if (this.readEOL(input) > 1) {
                pwarn = new COSLoadWarning("618b");
                pwarn.setHint(new Long(input.getOffset()));
                this.handleWarning(pwarn);
            }
        } else {
            this.readSpaces(input);
        }
        return new COSObjectKey(objNumber, genNumber);
    }

    public int parseStartXRef(IRandomAccess input) throws IOException, COSLoadException {
        this.readSpaces(input);
        byte[] token = new byte[9];
        input.read(token);
        if (!Arrays.equals(token, PDFParser.TOKEN_startxref)) {
            COSLoadError e = new COSLoadError("file format error. 'startxref' expected at offset:" + (input.getOffset() - 9L));
            this.handleError(e);
        }
        return this.readInteger(input, true);
    }

    public COSDictionary parseTrailer(IRandomAccess input) throws IOException, COSLoadException {
        byte[] token = new byte[7];
        int bytesRead = input.read(token);
        if (!Arrays.equals(token, TOKEN_trailer)) {
            if (bytesRead > 0) {
                input.seekBy((long)(-bytesRead));
            }
            COSLoadError e = new COSLoadError("file format error. 'trailer' expected at character index " + input.getOffset());
            this.handleError(e);
        }
        this.readSpaces(input);
        COSDictionary trailerDict = (COSDictionary)this.parseObjectDictionary(input);
        this.readSpaces(input);
        return trailerDict;
    }

    public int searchLastStartXRef(IRandomAccess input) throws IOException, COSLoadException {
        long startOffset = input.getLength() - 2048L;
        if (startOffset < 0L) {
            startOffset = 0L;
        }
        input.seek(startOffset);
        byte[] buffer = new byte[2048];
        int bytesRead = input.read(buffer);
        boolean found = false;
        int bufferOffset = bytesRead - TOKEN_startxref.length;
        while (bufferOffset > 0) {
            int j = 0;
            while (j < TOKEN_startxref.length) {
                if (buffer[bufferOffset + j] != TOKEN_startxref[j]) {
                    found = false;
                    break;
                }
                found = true;
                ++j;
            }
            if (found) break;
            --bufferOffset;
        }
        if (found) {
            long startXRefOffset = startOffset + (long)bufferOffset;
            input.seek(startXRefOffset);
            return this.parseStartXRef(input);
        }
        COSLoadError e = new COSLoadError("no startxref found in the last 2048 bytes of the document");
        this.handleError(e);
        return -1;
    }

    @Deprecated
    public int searchLinearized(IRandomAccess input) throws IOException, COSLoadException {
        long oldOffset = input.getOffset();
        int result = -1;
        input.seek(0L);
        this.parseComment(input);
        int next = input.read();
        while (next != -1) {
            if (next == 32 || COSDocumentParser.isWhitespace(next)) {
                next = input.read();
                continue;
            }
            input.seekBy(-1L);
            if (COSDocumentParser.isDigit(next)) {
                result = (int)input.getOffset();
                COSObject cosobj = this.parseIndirectObject(input, null);
                COSName linearized = COSName.constant("Linearized");
                if (cosobj instanceof COSDictionary && ((COSDictionary)cosobj).containsKey(linearized)) {
                    return result;
                }
                result = -1;
                break;
            }
            if (next != 37) break;
            this.parseComment(input);
            next = input.read();
        }
        input.seek(oldOffset);
        return result;
    }
}

