/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSDeviceBasedInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.content.CSVirtualDevice;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTools;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDResources;
import java.util.HashSet;
import java.util.Set;

public class DefaultAppearance {
    private PDAcroFormNode node;
    protected COSName fontName;
    protected float fontSize;
    protected float[] nonStrokeColorValues;
    protected PDColorSpace nonStrokeColorSpace;
    protected float[] strokeColorValues;
    protected PDColorSpace strokeColorSpace;

    public DefaultAppearance(PDAcroFormNode node) {
        this.node = node;
        CSDeviceBasedInterpreter interpreter = new CSDeviceBasedInterpreter(null, new DefaultAppearanceDevice());
        interpreter.process(node.getDefaultAppearanceContent(), node.getAcroForm().getDefaultResources());
    }

    protected COSName addFontResource(PDAcroForm form, PDFont font) {
        COSDictionary fontResources;
        PDResources resources = form.getDefaultResources();
        if (resources == null) {
            resources = (PDResources)PDResources.META.createNew();
            form.setDefaultResources(resources);
        }
        if ((fontResources = resources.cosGetResources(PDResources.CN_RT_Font)) == null) {
            fontResources = resources.cosInitResources(PDResources.CN_RT_Font);
        }
        for (COSName fontKey : fontResources.keySet()) {
            COSObject fontValue = fontResources.get(fontKey);
            if (!fontValue.equals(font.cosGetObject())) continue;
            return fontKey;
        }
        return resources.createFontResource(font);
    }

    protected COSName addFontResource(PDFont font) {
        return this.addFontResource(this.node.getAcroForm(), font);
    }

    protected void cleanupFontResources(PDAcroForm form) {
        Set referencedKeys = this.getReferencedFontKeys(form);
        HashSet<COSName> overhead = new HashSet<COSName>();
        COSDictionary fontDict = form.getDefaultResources().cosGetResources(PDResources.CN_RT_Font);
        if (fontDict != null) {
            for (COSName key : fontDict.keySet()) {
                if (referencedKeys.contains(key)) continue;
                overhead.add(key);
            }
            for (COSName key : overhead) {
                fontDict.remove(key);
            }
        }
    }

    protected void collectDefaultAppearanceFonts(PDAcroFormNode pNode, Set keys) {
        COSName fontKey = pNode.getDefaultAppearanceFontName();
        if (fontKey != null) {
            keys.add(fontKey);
        }
        if (pNode.getGenericChildren() == null) {
            return;
        }
        for (PDAcroFormNode child : pNode.getGenericChildren()) {
            this.collectDefaultAppearanceFonts(child, keys);
        }
    }

    protected void contentReplaceColor(float[] color) {
        CSContent appearance = this.node.getDefaultAppearanceContent();
        CSContent content = CSContent.createNew();
        CSOperation op = null;
        switch (color.length) {
            case 1: {
                op = new CSOperation(CSOperators.CSO_g);
                break;
            }
            case 3: {
                op = new CSOperation(CSOperators.CSO_rg);
                break;
            }
            case 4: {
                op = new CSOperation(CSOperators.CSO_k);
            }
        }
        int index = 0;
        while (index < color.length) {
            op.addOperand(COSFixed.create(color[index]));
            ++index;
        }
        if (appearance == null) {
            content.addOperation(op);
        } else {
            int len = appearance.size();
            boolean replaced = false;
            int i = 0;
            while (i < len) {
                CSOperation operation = appearance.getOperation(i);
                if (operation.matchesOperator(CSOperators.CSO_g) || operation.matchesOperator(CSOperators.CSO_rg) || operation.matchesOperator(CSOperators.CSO_k)) {
                    content.addOperation(op);
                    replaced = true;
                } else {
                    content.addOperation(operation);
                }
                ++i;
            }
            if (!replaced) {
                content.addOperation(op);
            }
        }
        this.node.setDefaultAppearanceContent(content);
    }

    protected void contentReplaceFont(COSName pFontName) {
        CSContent appearance = this.node.getDefaultAppearanceContent();
        CSContent content = CSContent.createNew();
        CSOperation op = new CSOperation(CSOperators.CSO_Tf);
        op.addOperand(pFontName);
        op.addOperand(COSInteger.create(0));
        if (appearance == null) {
            content.addOperation(op);
        } else {
            int len = appearance.size();
            boolean replaced = false;
            int i = 0;
            while (i < len) {
                CSOperation operation = appearance.getOperation(i);
                if (operation.matchesOperator(CSOperators.CSO_Tf)) {
                    if (operation.operandSize() >= 2) {
                        op.setOperand(1, operation.getOperand(1));
                    }
                    content.addOperation(op);
                    replaced = true;
                } else {
                    content.addOperation(operation);
                }
                ++i;
            }
            if (!replaced) {
                content.addOperation(op);
            }
        }
        this.node.setDefaultAppearanceContent(content);
    }

    protected void contentReplaceSize(float pFontSize) {
        CSContent appearance = this.node.getDefaultAppearanceContent();
        CSContent content = CSContent.createNew();
        CSOperation op = new CSOperation(CSOperators.CSO_Tf);
        op.addOperand(COSName.create("Helv"));
        op.addOperand(COSFixed.create(pFontSize));
        if (appearance == null) {
            content.addOperation(op);
        } else {
            int len = appearance.size();
            boolean replaced = false;
            int i = 0;
            while (i < len) {
                CSOperation operation = appearance.getOperation(i);
                if (operation.matchesOperator(CSOperators.CSO_Tf)) {
                    if (operation.operandSize() >= 1) {
                        op.setOperand(0, operation.getOperand(0));
                    }
                    content.addOperation(op);
                    replaced = true;
                } else {
                    content.addOperation(operation);
                }
                ++i;
            }
            if (!replaced) {
                content.addOperation(op);
            }
        }
        this.node.setDefaultAppearanceContent(content);
    }

    public PDFont getFont() {
        PDResources resources = this.node.getAcroForm().getDefaultResources();
        if (resources == null) {
            return null;
        }
        return PDFontTools.getFont(resources, this.getFontName());
    }

    public float[] getFontColorValues() {
        return this.nonStrokeColorValues;
    }

    public COSName getFontName() {
        return this.fontName;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public PDAcroFormNode getNode() {
        return this.node;
    }

    protected Set getReferencedFontKeys(PDAcroForm form) {
        HashSet referencedKeys = new HashSet();
        this.collectDefaultAppearanceFonts(form, referencedKeys);
        return referencedKeys;
    }

    public void setFont(PDFont font) {
        COSName cosFontName = this.addFontResource(font);
        this.setFontName(cosFontName);
        this.cleanupFontResources(this.node.getAcroForm());
    }

    public void setFontColorValues(float[] color) {
        this.contentReplaceColor(color);
        this.nonStrokeColorValues = color;
    }

    public void setFontName(COSName pFontName) {
        this.contentReplaceFont(pFontName);
        this.fontName = pFontName;
    }

    public void setFontSize(float pFontSize) {
        this.contentReplaceSize(pFontSize);
        this.fontSize = pFontSize;
    }

    public class DefaultAppearanceDevice
    extends CSVirtualDevice {
        @Override
        protected void basicSetNonStrokeColorSpace(PDColorSpace colorSpace) {
            DefaultAppearance.this.nonStrokeColorSpace = colorSpace;
        }

        @Override
        protected void basicSetNonStrokeColorValues(float[] values) {
            DefaultAppearance.this.nonStrokeColorValues = values;
        }

        @Override
        protected void basicSetStrokeColorSpace(PDColorSpace colorSpace) {
            DefaultAppearance.this.strokeColorSpace = colorSpace;
        }

        @Override
        protected void basicSetStrokeColorValues(float[] values) {
            DefaultAppearance.this.strokeColorValues = values;
        }

        @Override
        public void textSetFont(COSName name, PDFont paramFont, float size) {
            DefaultAppearance.this.fontName = name;
            DefaultAppearance.this.fontSize = size;
        }
    }
}

