/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PDAFButtonField
extends PDAcroFormField {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Opt = COSName.constant("Opt");

    protected PDAFButtonField(COSObject object) {
        super(object);
    }

    @Override
    public COSName cosGetExpectedFieldType() {
        return CN_FT_Btn;
    }

    public COSArray cosGetOptions() {
        return this.cosGetField(DK_Opt).asArray();
    }

    @Override
    public COSObject cosSetValue(COSObject state) {
        if (this.isCheckbox() || this.isRadio()) {
            ArrayList<COSName> newStates = new ArrayList<COSName>();
            COSArray opts = this.cosGetOptions();
            if (opts != null && state != null) {
                int i = 0;
                while (i < opts.size()) {
                    COSString cosOption = opts.get(i).asString();
                    if (cosOption != null && cosOption.stringValue().equals(state.stringValue())) {
                        COSName newState = COSName.create(String.valueOf(i));
                        newStates.add(newState);
                    }
                    ++i;
                }
            }
            if (newStates.isEmpty()) {
                if (state instanceof COSName) {
                    newStates.add((COSName)state);
                } else if (state == null) {
                    newStates.add(PDWidgetAnnotation.CN_State_Off);
                } else {
                    newStates.add(COSName.create(state.stringValue()));
                }
            }
            COSName value = PDWidgetAnnotation.CN_State_Off;
            for (PDWidgetAnnotation annot : this.getAnnotations()) {
                COSObject newState = null;
                Set states = annot.getAppearanceStates();
                for (COSName currentState : newStates) {
                    if (!states.contains(currentState)) continue;
                    newState = currentState;
                    break;
                }
                if (newState == null) {
                    annot.setAppearanceState(PDWidgetAnnotation.CN_State_Off);
                    continue;
                }
                annot.setAppearanceState((COSName)newState.copyOptional());
                value = (COSName)newState.copyOptional();
            }
            return super.cosSetValue(value);
        }
        return COSNull.NULL;
    }

    public Set getAvailableButtonAppearanceStates() {
        HashSet availableStates = new HashSet();
        for (PDAnnotation child : this.getAnnotations()) {
            availableStates.addAll(child.getAppearanceStates());
        }
        return availableStates;
    }

    public Set getAvailableButtonAppearanceStatesNoOff() {
        Set availableStates = this.getAvailableButtonAppearanceStates();
        COSName offState = COSName.create("Off");
        availableStates.remove(offState);
        return availableStates;
    }

    public boolean isCheckbox() {
        return !this.isPushbutton() && !this.isRadio();
    }

    public boolean isChecked() {
        if (this.isCheckbox()) {
            return !PDWidgetAnnotation.CN_State_Off.equals(this.getAnyAnnotation().getAppearanceState());
        }
        return false;
    }

    public boolean isPushbutton() {
        return this.getFieldFlags().isPushbutton();
    }

    public boolean isRadio() {
        return this.getFieldFlags().isRadio();
    }

    @Override
    public boolean isTypeBtn() {
        return true;
    }

    @Override
    public void reset() {
        COSObject value = this.cosGetDefaultValue();
        value = value.isNull() ? COSString.create("") : value.copyOptional();
        this.cosSetValue(value);
    }

    protected COSName setButtonAppearanceState(PDAnnotation annot, String value) {
        COSName state = COSName.create(value);
        Set states = annot.getAppearanceStates();
        if (!states.contains(state)) {
            COSName offState;
            state = offState = COSName.create("Off");
            if ((value = value.toLowerCase().trim()).equals("1") || value.startsWith("t") || value.startsWith("y") || value.startsWith("w") || value.startsWith("j") || value.startsWith("x")) {
                for (COSName aState : states) {
                    if (aState.equals(offState)) continue;
                    state = (COSName)aState.copyOptional();
                    break;
                }
            }
        }
        annot.setAppearanceState(state);
        return state;
    }

    public void setPushbutton(boolean f) {
        this.getFieldFlags().setPushbutton(f);
    }

    @Override
    public void setValueString(String value) {
        if (value == null) {
            super.setValueString(value);
        }
        if (this.isCheckbox() || this.isRadio()) {
            if (value == null) {
                this.cosSetValue(null);
            } else {
                COSName state = COSName.create(value);
                this.cosSetValue(state);
            }
        }
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAFButtonField(object);
        }
    }
}

