/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAcroFormField;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PDAFChoiceField
extends PDAcroFormField {
    public static final COSName DK_Opt = COSName.constant("Opt");
    public static final COSName DK_TI = COSName.constant("TI");
    public static final COSName DK_I = COSName.constant("I");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private List cachedOptionNames;
    private List cachedExportValues;

    protected PDAFChoiceField(COSObject object) {
        super(object);
    }

    @Override
    public COSName cosGetExpectedFieldType() {
        return CN_FT_Ch;
    }

    protected void createOptions() {
        COSArray cosOptions = this.getOptions();
        if (cosOptions != null && cosOptions.size() > 0) {
            this.cachedOptionNames = new ArrayList(cosOptions.size());
            this.cachedExportValues = new ArrayList(cosOptions.size());
            for (COSObject cosOption : cosOptions) {
                String exportValue = "null";
                String optionName = "null";
                if (cosOption instanceof COSArray) {
                    COSArray cosOptionArray = (COSArray)cosOption;
                    exportValue = cosOptionArray.get(0).stringValue();
                    optionName = cosOptionArray.get(1).stringValue();
                } else if (cosOption instanceof COSString) {
                    COSString cosOptionString = (COSString)cosOption;
                    exportValue = cosOptionString.stringValue();
                    optionName = cosOptionString.stringValue();
                }
                this.cachedExportValues.add(exportValue);
                this.cachedOptionNames.add(optionName);
            }
        } else {
            this.cachedOptionNames = new ArrayList(0);
            this.cachedExportValues = this.cachedOptionNames;
        }
    }

    public List getExportValues() {
        if (this.cachedExportValues == null) {
            this.createOptions();
        }
        return this.cachedExportValues;
    }

    public List getOptionNames() {
        if (this.cachedOptionNames == null) {
            this.createOptions();
        }
        return this.cachedOptionNames;
    }

    protected COSArray getOptions() {
        return this.cosGetFieldInheritable(DK_Opt).asArray();
    }

    protected int getTopIndex() {
        return this.getFieldInt(DK_TI, 0);
    }

    public List getValueList() {
        ArrayList<String> result;
        COSObject cosValue = super.cosGetValue();
        if (cosValue.isNull()) {
            ArrayList result2 = new ArrayList(0);
            return result2;
        }
        if (cosValue instanceof COSArray) {
            result = new ArrayList(((COSArray)cosValue).size());
            Iterator<COSObject> i = ((COSArray)cosValue).iterator();
            while (i.hasNext()) {
                result.add(i.next().stringValue());
            }
        } else {
            result = new ArrayList<String>(1);
            result.add(cosValue.stringValue());
        }
        return result;
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedExportValues = null;
        this.cachedOptionNames = null;
    }

    public boolean isCombo() {
        return this.getFieldFlags().isCombo();
    }

    public boolean isCommitOnSelChange() {
        return this.getFieldFlags().isCommitOnSelChange();
    }

    public boolean isEdit() {
        return this.getFieldFlags().isEdit();
    }

    public boolean isMultiSelect() {
        return this.getFieldFlags().isMultiSelect();
    }

    @Override
    public boolean isTypeCh() {
        return true;
    }

    protected void setIndices(List newIndices) {
    }

    protected void setOptions(COSArray options) {
        this.cosSetFieldInheritable(DK_Opt, options);
    }

    public void setOptions(Map options) {
        COSArray cosOptions = COSArray.create(options.size());
        for (Map.Entry entry : options.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                value = name;
            }
            COSArray cosOption = COSArray.create(2);
            cosOption.add(COSString.create(name));
            cosOption.add(COSString.create(value));
            cosOptions.add(cosOption);
        }
        this.setOptions(cosOptions);
    }

    public void setOptions(String[] names, String[] values) {
        COSArray cosOptions = COSArray.create(names.length);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            String value = values[i];
            if (value == null) {
                cosOptions.add(COSString.create(name));
            } else {
                COSArray cosOption = COSArray.create(2);
                cosOption.add(COSString.create(value));
                cosOption.add(COSString.create(name));
                cosOptions.add(cosOption);
            }
            ++i;
        }
        this.setOptions(cosOptions);
    }

    protected void setTopIndex(int newTopIndex) {
        if (newTopIndex == 0) {
            this.cosRemoveField(DK_TI);
        } else {
            this.setFieldInt(DK_TI, newTopIndex);
        }
    }

    @Override
    public void setValueString(String value) {
        if (value == null) {
            super.setValueString(value);
        } else {
            value = value.replace('\r', ' ');
            value = value.replace('\n', '\r');
            super.setValueString(value);
        }
    }

    @Override
    public void setValueStrings(List values) {
        if (values == null || values.isEmpty()) {
            this.cosSetValue(null);
            return;
        }
        if (values.size() == 1) {
            this.setValueString((String)values.get(0));
            return;
        }
        COSArray array = COSArray.create(values.size());
        for (String value : values) {
            value = value.replace('\r', ' ');
            value = value.replace('\n', '\r');
            array.add(COSString.create(value));
        }
        this.cosSetValue(array);
    }

    public static class MetaClass
    extends PDAcroFormField.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDAFChoiceField(object);
        }
    }
}

