/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.AcroFormFieldFlags;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAFChoiceField;
import de.intarsys.pdf.pd.PDAFIntermediateNode;
import de.intarsys.pdf.pd.PDAFSignatureField;
import de.intarsys.pdf.pd.PDAFTextField;
import de.intarsys.pdf.pd.PDAcroForm;
import de.intarsys.pdf.pd.PDAcroFormNode;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PDAcroFormField
extends PDAcroFormNode
implements IAdditionalActionSupport {
    public static final COSName DK_FT = COSName.constant("FT");
    public static final COSName CN_FT_Btn = COSName.constant("Btn");
    public static final COSName CN_FT_Tx = COSName.constant("Tx");
    public static final COSName CN_FT_Ch = COSName.constant("Ch");
    public static final COSName CN_FT_Sig = COSName.constant("Sig");
    public static final COSName DK_Parent = COSName.constant("Parent");
    public static final COSName DK_Kids = COSName.constant("Kids");
    public static final COSName DK_T = COSName.constant("T");
    public static final COSName DK_TU = COSName.constant("TU");
    public static final COSName DK_TM = COSName.constant("TM");
    public static final COSName DK_Ff = COSName.constant("Ff");
    public static final COSName DK_V = COSName.constant("V");
    public static final COSName DK_DV = COSName.constant("DV");
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final COSName DK_DS = COSName.constant("DS");
    public static final COSName DK_RV = COSName.constant("RV");
    public static final Set ACROFORMFIELD_ACTION_TRIGGERS;
    public static final MetaClass META;
    public static final COSName DK_MaxLen;
    private AcroFormFieldFlags fieldFlags;
    private List cachedKids;

    static {
        META = new MetaClass(MetaClass.class.getDeclaringClass());
        DK_MaxLen = COSName.constant("MaxLen");
        ACROFORMFIELD_ACTION_TRIGGERS = new HashSet(5);
        ACROFORMFIELD_ACTION_TRIGGERS.add("K");
        ACROFORMFIELD_ACTION_TRIGGERS.add("F");
        ACROFORMFIELD_ACTION_TRIGGERS.add("V");
        ACROFORMFIELD_ACTION_TRIGGERS.add("C");
    }

    protected PDAcroFormField(COSObject object) {
        super(object);
    }

    public void addAnnotation(PDWidgetAnnotation annot) {
        this.cosAddKid(annot.cosGetDict());
    }

    @Override
    public void addField(PDAcroFormField field) {
        this.cosAddKid(field.cosGetDict());
        if (field.isTypeSig()) {
            this.getAcroForm().getSigFlags().setSignatureExists(true);
        }
    }

    public int basicGetFieldFlags() {
        COSInteger flags = this.cosGetFieldInheritable(DK_Ff).asInteger();
        if (flags != null) {
            return flags.intValue();
        }
        return 0;
    }

    public void basicSetFieldFlags(int newFlags) {
        COSInteger parentFlag;
        if (this.getParent() != null && (parentFlag = this.getParent().cosGetFieldInheritable(DK_Ff).asInteger()) != null && parentFlag.intValue() == newFlags) {
            this.cosRemoveField(DK_Ff);
            return;
        }
        this.cosSetField(DK_Ff, COSInteger.create(newFlags));
    }

    protected boolean checkFieldType(COSName checkType) {
        return checkType.equals(this.cosGetFieldType());
    }

    @Override
    protected List collectLeafFields(List result) {
        result.add(this);
        return result;
    }

    public PDAcroFormField copy() {
        COSDictionary dict = COSDictionary.create();
        dict.beIndirect();
        dict.put(DK_FT, this.cosGetField(DK_FT).copyShallow());
        PDAcroFormField copy = (PDAcroFormField)META.createFromCos(dict);
        copy.cosSetField(DK_T, this.cosGetField(DK_T).copyShallow());
        copy.cosSetField(DK_V, this.cosGetField(DK_V).copyShallow());
        copy.cosSetField(DK_TU, this.cosGetField(DK_TU).copyShallow());
        copy.cosSetField(DK_TM, this.cosGetField(DK_TM).copyShallow());
        copy.cosSetField(DK_Ff, this.cosGetField(DK_Ff).copyShallow());
        copy.cosSetField(DK_DV, this.cosGetField(DK_DV).copyShallow());
        copy.cosSetField(DK_DA, this.cosGetField(DK_DA).copyShallow());
        copy.cosSetField(DK_Q, this.cosGetField(DK_Q).copyShallow());
        copy.cosSetField(PDAFChoiceField.DK_Opt, this.cosGetField(PDAFChoiceField.DK_Opt).copyShallow());
        copy.cosSetField(DK_MaxLen, this.cosGetField(DK_MaxLen).copyShallow());
        copy.cosSetField(PDAFChoiceField.DK_TI, this.cosGetField(PDAFChoiceField.DK_TI).copyShallow());
        copy.cosSetField(PDAFChoiceField.DK_I, this.cosGetField(PDAFChoiceField.DK_I).copyShallow());
        return copy;
    }

    protected void cosAddKid(COSDictionary dict) {
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids == null) {
            cosKids = COSArray.create();
            this.cosSetField(DK_Kids, cosKids);
        }
        cosKids.add(dict);
        dict.put(DK_Parent, this.cosGetDict());
    }

    public COSObject cosGetDefaultValue() {
        return this.cosGetValueEntry(DK_DV);
    }

    public abstract COSName cosGetExpectedFieldType();

    public COSName cosGetFieldType() {
        return this.cosGetFieldInheritable(DK_FT).asName();
    }

    public COSObject cosGetValue() {
        return this.cosGetValueEntry(DK_V);
    }

    protected COSObject cosGetValueEntry(COSName key) {
        COSObject cosValue = this.cosGetField(key);
        if (cosValue.isNull()) {
            cosValue = this.getLogicalRoot().cosGetFieldDescendant(key);
        }
        return cosValue;
    }

    protected boolean cosRemoveKid(COSDictionary dict) {
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids == null) {
            return false;
        }
        if (cosKids.remove(dict)) {
            dict.remove(DK_Parent);
            return true;
        }
        return false;
    }

    protected COSObject cosSetDefaultValue(COSObject newDefaultValue) {
        return this.cosSetFieldInheritable(DK_DV, newDefaultValue);
    }

    protected COSObject cosSetFieldType(COSName newFieldType) {
        return this.cosSetFieldInheritable(DK_FT, newFieldType);
    }

    protected void cosSetMappingName(String newMappingName) {
        this.setFieldName(DK_TM, newMappingName);
    }

    protected void cosSetRichTextString(String newRichTextString) {
        this.setFieldName(DK_RV, newRichTextString);
    }

    public COSObject cosSetValue(COSObject newValue) {
        return this.cosSetFieldInheritable(DK_V, newValue);
    }

    @Deprecated
    public void dispose(boolean disposeEmptyAncestors) {
        PDAcroFormField removeTarget = null;
        removeTarget = this.getLogicalRoot().cosGetDict() == this.cosGetDict() ? this.getParent() : this.getLogicalRoot();
        if (removeTarget == null) {
            this.getAcroForm().removeField(this);
        } else {
            removeTarget.removeField(this);
            if (disposeEmptyAncestors && removeTarget.getKids().size() == 0) {
                removeTarget.dispose(disposeEmptyAncestors);
            }
        }
    }

    @Override
    public PDAcroForm getAcroForm() {
        PDDocument doc = this.getDoc();
        if (doc == null) {
            return null;
        }
        return doc.getAcroForm();
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary field = this.cosGetField(DK_AA).asDictionary();
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(field);
    }

    public String getAlternateFieldName() {
        return this.getFieldString(DK_TU, null);
    }

    @Override
    protected List getAnnotations(List annotations) {
        if (this.isAnnotation()) {
            annotations.add(PDAnnotation.META.createFromCos(this.cosGetDict()));
        }
        return super.getAnnotations(annotations);
    }

    @Deprecated
    public PDAnnotation getAnyAnnotation() {
        if (this.isAnnotation()) {
            return (PDAnnotation)PDAnnotation.META.createFromCos(this.cosGetDict());
        }
        for (PDAcroFormField kid : this.getGenericChildren()) {
            PDAnnotation result = kid.getAnyAnnotation();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected String getDefaultStyle() {
        return this.getFieldString(DK_DS, null);
    }

    public String getDefaultValueString() {
        COSObject value = this.cosGetDefaultValue();
        if (value.isNull()) {
            return null;
        }
        return value.stringValue();
    }

    public AcroFormFieldFlags getFieldFlags() {
        if (this.fieldFlags == null) {
            this.fieldFlags = new AcroFormFieldFlags(this);
        }
        return this.fieldFlags;
    }

    @Override
    public List getGenericChildren() {
        return this.getKids();
    }

    @Override
    public PDObject getGenericParent() {
        PDAcroFormField parent = this.getParent();
        if (parent == null) {
            return this.getAcroForm();
        }
        return parent;
    }

    public List getKids() {
        if (this.cachedKids == null) {
            this.cachedKids = this.getPDObjects(DK_Kids, META, true);
            if (this.cachedKids == null) {
                return Collections.EMPTY_LIST;
            }
        }
        return this.cachedKids;
    }

    public String getLocalName() {
        return this.getLocalName(false);
    }

    public String getLocalName(boolean canonical) {
        String name = this.getFieldString(DK_T, null);
        if (name != null && !name.trim().equals("")) {
            return canonical ? PDAcroFormField.canonicalize(name) : name;
        }
        return null;
    }

    public PDAcroFormNode getLogicalParent() {
        PDAcroFormField root = this.getLogicalRoot();
        if (root == null) {
            return this.getAcroForm();
        }
        PDAcroFormField p = root.getParent();
        if (p == null) {
            return this.getAcroForm();
        }
        return p;
    }

    public PDAcroFormField getLogicalRoot() {
        if (this.getLocalName(false) == null) {
            PDAcroFormField p = this.getParent();
            if (p == null) {
                return this;
            }
            return p.getLogicalRoot();
        }
        return this;
    }

    protected String getMappingName() {
        return this.getFieldString(DK_TM, null);
    }

    public Integer getMaxLen() {
        COSInteger cosBase = this.cosGetFieldInheritable(DK_MaxLen).asInteger();
        if (cosBase != null) {
            return cosBase.intValue();
        }
        cosBase = this.cosGetFieldDescendant(DK_MaxLen).asInteger();
        if (cosBase != null) {
            return cosBase.intValue();
        }
        return null;
    }

    public PDAcroFormField getParent() {
        COSDictionary dict = this.cosGetField(DK_Parent).asDictionary();
        if (dict != null) {
            return (PDAcroFormField)META.createFromCos(dict);
        }
        return null;
    }

    protected String getParentName(boolean canonical) {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getQualifiedName(canonical);
    }

    public String getQualifiedName() {
        return this.getQualifiedName(false);
    }

    public String getQualifiedName(boolean canonical) {
        String parentName;
        String partialName = this.getLocalName(canonical);
        String qualifiedName = parentName = this.getParentName(canonical);
        if (partialName != null) {
            qualifiedName = parentName == null ? partialName : String.valueOf(parentName) + "." + partialName;
        }
        return qualifiedName;
    }

    protected String getRichTextString() {
        return this.getFieldString(DK_RV, null);
    }

    @Override
    public Set getSupportedTriggerEvents() {
        return ACROFORMFIELD_ACTION_TRIGGERS;
    }

    public String getValueString() {
        COSObject value = this.cosGetValue();
        if (value.isNull()) {
            return null;
        }
        return value.stringValue();
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetFieldType(this.cosGetExpectedFieldType());
        this.cosSetField(DK_T, COSString.create(new byte[0]));
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        COSArray cosKids = this.cosGetField(DK_Kids).asArray();
        if (cosKids != null) {
            cosKids.removeObjectListener(this);
        }
        if (this.cachedKids != null) {
            for (PDAcroFormField field : this.cachedKids) {
                field.invalidateCaches();
            }
            this.cachedKids = null;
        }
    }

    public boolean isAlignmentCenter() {
        return this.getQuadding() == 1;
    }

    public boolean isAlignmentLeft() {
        return this.getQuadding() == 0;
    }

    public boolean isAlignmentRight() {
        return this.getQuadding() == 2;
    }

    public boolean isAnnotation() {
        return !this.cosGetDict().get(PDObject.DK_Subtype).isNull();
    }

    public boolean isComb() {
        return this.getFieldFlags().isComb();
    }

    public boolean isDoNotScroll() {
        return this.getFieldFlags().isDoNotScroll();
    }

    public boolean isMultiline() {
        return this.getFieldFlags().isMultiline();
    }

    public boolean isNoExport() {
        return this.getFieldFlags().isNoExport();
    }

    public boolean isReadOnly() {
        return this.getFieldFlags().isReadOnly();
    }

    public boolean isTypeBtn() {
        return false;
    }

    public boolean isTypeCh() {
        return false;
    }

    public boolean isTypeSig() {
        return false;
    }

    public boolean isTypeTx() {
        return false;
    }

    @Override
    public boolean removeField(PDAcroFormField field) {
        boolean removed = this.cosRemoveKid(field.cosGetDict());
        this.getAcroForm().getSigFlags().setSignatureExists(this.getAcroForm().isSignatureExists());
        return removed;
    }

    public void reset() {
        COSObject value = this.cosGetDefaultValue();
        if (value != null) {
            value = value.copyOptional();
        }
        this.cosSetValue(value);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions actions) {
        this.setFieldObject(DK_AA, actions);
    }

    public void setAlignmentCenter() {
        this.setQuadding(1);
    }

    public void setAlignmentLeft() {
        this.setQuadding(0);
    }

    public void setAlignmentRight() {
        this.setQuadding(2);
    }

    public void setAlternateFieldName(String newAlternateFieldName) {
        this.setFieldString(DK_TU, newAlternateFieldName);
    }

    public void setComb(boolean f) {
        this.getFieldFlags().setComb(f);
    }

    protected void setDefaultStyle(String newDefaultStyle) {
        this.setFieldName(DK_DS, newDefaultStyle);
    }

    public void setDefaultValue(String value) {
        if (value == null) {
            this.cosSetDefaultValue(null);
        } else {
            this.cosSetDefaultValue(COSString.create(value));
        }
    }

    public void setDoNotScroll(boolean f) {
        this.getFieldFlags().setDoNotScroll(f);
    }

    protected void setKids(List newKids) {
        this.setPDObjects(DK_Kids, newKids);
    }

    public void setLocalName(String newLocalName) {
        this.setFieldString(DK_T, newLocalName);
    }

    public void setMaxLength(Integer newMaxLength) {
        if (newMaxLength != null) {
            this.setFieldInt(DK_MaxLen, newMaxLength);
        } else {
            this.cosRemoveField(DK_MaxLen);
        }
    }

    public void setMultiline(boolean f) {
        this.getFieldFlags().setMultiline(f);
    }

    public void setNoExport(boolean f) {
        this.getFieldFlags().setNoExport(f);
    }

    protected void setParent(PDAcroFormField newParent) {
        this.setFieldObject(DK_Parent, newParent);
    }

    public void setReadOnly(boolean f) {
        this.getFieldFlags().setReadOnly(f);
    }

    public void setValueString(String value) {
        if (value == null) {
            this.cosSetValue(null);
        } else {
            this.cosSetValue(COSString.create(value));
        }
    }

    public void setValueStrings(List values) {
        if (values == null || values.isEmpty()) {
            this.cosSetValue(null);
        } else {
            this.cosSetValue(COSString.create((String)values.get(0)));
        }
    }

    @Override
    public String toString() {
        String qName = this.getQualifiedName();
        if (qName == null) {
            return "unnamed AcroFormField " + super.toString();
        }
        return "AcroFormField " + qName + " " + super.toString();
    }

    protected void triggerAnnotation(PDWidgetAnnotation annotation) {
    }

    public static class MetaClass
    extends PDAcroFormNode.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        protected COSName cosGetFieldType(COSDictionary dict) {
            COSDictionary parent;
            COSName type = dict.get(DK_FT).asName();
            if (type == null && (parent = dict.get(DK_Parent).asDictionary()) != null) {
                return this.cosGetFieldType(parent);
            }
            return type;
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            if (!(object instanceof COSDictionary)) {
                return null;
            }
            COSName fieldType = this.cosGetFieldType((COSDictionary)object);
            if (CN_FT_Tx.equals(fieldType)) {
                return PDAFTextField.META;
            }
            if (CN_FT_Btn.equals(fieldType)) {
                return PDAFButtonField.META;
            }
            if (CN_FT_Ch.equals(fieldType)) {
                return PDAFChoiceField.META;
            }
            if (CN_FT_Sig.equals(fieldType)) {
                return PDAFSignatureField.META;
            }
            return PDAFIntermediateNode.META;
        }
    }
}

