/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDActionAny;
import de.intarsys.pdf.pd.PDActionGoTo;
import de.intarsys.pdf.pd.PDActionGoToR;
import de.intarsys.pdf.pd.PDActionJavaScript;
import de.intarsys.pdf.pd.PDActionLaunch;
import de.intarsys.pdf.pd.PDActionNamed;
import de.intarsys.pdf.pd.PDActionRendition;
import de.intarsys.pdf.pd.PDActionResetForm;
import de.intarsys.pdf.pd.PDActionSubmitForm;
import de.intarsys.pdf.pd.PDActionURI;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.List;

public abstract class PDAction
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_S = COSName.constant("S");
    public static final COSName DK_Next = COSName.constant("Next");
    public static final COSName CN_Type_Action = COSName.constant("Action");

    protected PDAction(COSObject object) {
        super(object);
    }

    public void addNext(PDAction action) {
        COSArray nextArray = null;
        COSObject dictNext = this.cosGetField(DK_Next);
        if (dictNext.isNull()) {
            nextArray = COSArray.create(1);
            this.cosSetField(DK_Next, nextArray);
        } else if (dictNext instanceof COSArray) {
            nextArray = (COSArray)dictNext;
        } else if (dictNext instanceof COSDictionary) {
            nextArray = COSArray.create(2);
            nextArray.add(dictNext);
            this.cosSetField(DK_Next, nextArray);
        }
        nextArray.add(action.cosGetDict());
    }

    public COSName cosGetActionType() {
        if (this.cosGetObject() instanceof COSDictionary) {
            return this.cosGetField(DK_S).asName();
        }
        return this.cosGetExpectedActionType();
    }

    public abstract COSName cosGetExpectedActionType();

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Action;
    }

    public List getNext() {
        List<COSBasedObject> result = null;
        if (!(this.cosGetObject() instanceof COSDictionary)) {
            return null;
        }
        COSObject dictNext = this.cosGetField(DK_Next);
        if (dictNext instanceof COSDictionary) {
            result = new ArrayList<COSBasedObject>();
            result.add(META.createFromCos(dictNext));
        } else if (dictNext instanceof COSArray) {
            result = this.getPDObjects(DK_Next, META, false);
        }
        return result;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        COSName actionType = this.cosGetExpectedActionType();
        if (actionType != null) {
            this.cosSetField(DK_S, this.cosGetExpectedActionType().copyShallow());
        }
    }

    public void removeNext(PDAction action) {
        COSArray nextArray = null;
        COSObject dictNext = this.cosGetField(DK_Next);
        if (!dictNext.isNull()) {
            if (dictNext instanceof COSArray) {
                nextArray = (COSArray)dictNext;
                nextArray.remove(action.cosGetObject());
            } else if (dictNext instanceof COSDictionary && dictNext == action.cosGetObject()) {
                this.cosRemoveField(DK_Next);
            }
        }
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            if (object instanceof COSArray) {
                return PDActionGoTo.META;
            }
            COSName actionType = ((COSDictionary)object).get(DK_S).asName();
            if (actionType == null) {
                throw new IllegalArgumentException("action type not specified");
            }
            if (actionType.equals(PDActionSubmitForm.CN_ActionType_SubmitForm)) {
                return PDActionSubmitForm.META;
            }
            if (actionType.equals(PDActionResetForm.CN_ActionType_ResetForm)) {
                return PDActionResetForm.META;
            }
            if (actionType.equals(PDActionGoTo.CN_ActionType_GoTo)) {
                return PDActionGoTo.META;
            }
            if (actionType.equals(PDActionGoToR.CN_ActionType_GoToR)) {
                return PDActionGoToR.META;
            }
            if (actionType.equals(PDActionJavaScript.CN_ActionType_JavaScript)) {
                return PDActionJavaScript.META;
            }
            if (actionType.equals(PDActionNamed.CN_ActionType_Named)) {
                return PDActionNamed.META;
            }
            if (actionType.equals(PDActionURI.CN_ActionType_URI)) {
                return PDActionURI.META;
            }
            if (actionType.equals(PDActionLaunch.CN_ActionType_Launch)) {
                return PDActionLaunch.META;
            }
            if (actionType.equals(PDActionRendition.CN_ActionType_Rendition)) {
                return PDActionRendition.META;
            }
            return PDActionAny.META;
        }

        @Override
        public Class getRootClass() {
            return PDAction.class;
        }
    }
}

