/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.AnnotationFlags;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAction;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAnyAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDBorderStyle;
import de.intarsys.pdf.pd.PDCircleAnnotation;
import de.intarsys.pdf.pd.PDFileAttachmentAnnotation;
import de.intarsys.pdf.pd.PDHighlightAnnotation;
import de.intarsys.pdf.pd.PDInkAnnotation;
import de.intarsys.pdf.pd.PDLineAnnotation;
import de.intarsys.pdf.pd.PDLinkAnnotation;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPolygonAnnotation;
import de.intarsys.pdf.pd.PDPolylineAnnotation;
import de.intarsys.pdf.pd.PDPopupAnnotation;
import de.intarsys.pdf.pd.PDSquareAnnotation;
import de.intarsys.pdf.pd.PDSquigglyAnnotation;
import de.intarsys.pdf.pd.PDStampAnnotation;
import de.intarsys.pdf.pd.PDStrikeOutAnnotation;
import de.intarsys.pdf.pd.PDTextAnnotation;
import de.intarsys.pdf.pd.PDTextMarkupAnnotation;
import de.intarsys.pdf.pd.PDUnderlineAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class PDAnnotation
extends PDObject
implements IAdditionalActionSupport {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_Contents = COSName.constant("Contents");
    public static final COSName DK_P = COSName.constant("P");
    public static final COSName DK_Rect = COSName.constant("Rect");
    public static final COSName DK_NM = COSName.constant("NM");
    public static final COSName DK_M = COSName.constant("M");
    public static final COSName DK_F = COSName.constant("F");
    public static final COSName DK_BS = COSName.constant("BS");
    public static final COSName DK_Border = COSName.constant("Border");
    public static final COSName DK_AP = COSName.constant("AP");
    public static final COSName DK_AS = COSName.constant("AS");
    public static final COSName DK_C = COSName.constant("C");
    public static final COSName DK_CA = COSName.constant("CA");
    public static final COSName DK_IC = COSName.constant("IC");
    public static final COSName DK_A = COSName.constant("A");
    public static final COSName DK_StructParent = COSName.constant("StructParent");
    public static final COSName DK_OC = COSName.constant("OC");
    public static final COSName CN_Type_Annot = COSName.constant("Annot");
    public static final Set ANNOTATION_ACTION_TRIGGERS = new HashSet(11);
    private AnnotationFlags flags;
    private PDBorderStyle cachedBorderStyle;
    private CDSRectangle cachedRectangle;

    static {
        ANNOTATION_ACTION_TRIGGERS.add("E");
        ANNOTATION_ACTION_TRIGGERS.add("X");
        ANNOTATION_ACTION_TRIGGERS.add("D");
        ANNOTATION_ACTION_TRIGGERS.add("U");
        ANNOTATION_ACTION_TRIGGERS.add("Fo");
        ANNOTATION_ACTION_TRIGGERS.add("BI");
        ANNOTATION_ACTION_TRIGGERS.add("PO");
        ANNOTATION_ACTION_TRIGGERS.add("PC");
        ANNOTATION_ACTION_TRIGGERS.add("PV");
        ANNOTATION_ACTION_TRIGGERS.add("PI");
    }

    protected static COSDictionary copyAppearanceDict(COSDictionary appDict) {
        if (appDict == null) {
            return null;
        }
        COSDictionary result = COSDictionary.create();
        Iterator i = appDict.entryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSName key = (COSName)entry.getKey();
            COSObject value = (COSObject)entry.getValue();
            if (value instanceof COSDictionary) {
                COSDictionary oldDict = (COSDictionary)value;
                value = PDAnnotation.copyAppearanceDictInner(oldDict);
            } else if (value instanceof COSStream) {
                value = value.copyShallow();
            }
            result.put(key, value);
        }
        return result;
    }

    protected static COSDictionary copyAppearanceDictInner(COSDictionary stateDict) {
        COSDictionary result = COSDictionary.create();
        Iterator i = stateDict.entryIterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            COSName key = (COSName)entry.getKey();
            COSObject value = (COSObject)entry.getValue();
            if (value instanceof COSStream) {
                value = value.copyShallow();
            }
            result.put(key, value);
        }
        return result;
    }

    protected PDAnnotation(COSObject object) {
        super(object);
    }

    public void addAction(PDAction newAction) {
        if (newAction != null) {
            if (this.getAction() == null) {
                this.setAction(newAction);
            } else {
                this.getAction().addNext(newAction);
            }
        }
    }

    public int basicGetFlags() {
        return this.getFieldInt(DK_F, 0);
    }

    public void basicSetFlags(int newFlags) {
        if (newFlags != 0) {
            this.cosSetField(DK_F, COSInteger.create(newFlags));
        } else {
            this.cosRemoveField(DK_F);
        }
    }

    public boolean canReceiveFocus() {
        return !this.isReadOnly() && !this.isHidden() && !this.isNoView() && !this.isInvisible() && !this.isLocked();
    }

    protected void checkRectangle(CDSRectangle rect) {
        float newWidth = rect.getWidth();
        float newHeight = rect.getHeight();
        if (newWidth <= 0.0f && newHeight <= 0.0f) {
            newWidth = this.getDefaultWidth();
            newHeight = this.getDefaultHeight();
        }
        if (newWidth < this.getMinWidth()) {
            newWidth = this.getMinWidth();
        }
        if (newHeight < this.getMinHeight()) {
            newHeight = this.getMinHeight();
        }
        rect.resizeTo(newWidth, newHeight);
    }

    public PDAnnotation copy() {
        COSDictionary dict = (COSDictionary)this.cosGetDict().copyShallow();
        PDAnnotation copy = (PDAnnotation)META.createFromCos(dict);
        copy.cosRemoveField(DK_P);
        copy.cosRemoveField(PDAcroFormField.DK_Parent);
        copy.cosRemoveField(PDAcroFormField.DK_T);
        copy.cosRemoveField(PDAcroFormField.DK_TU);
        copy.cosRemoveField(DK_M);
        copy.cosRemoveField(PDAcroFormField.DK_V);
        COSDictionary newAppearance = PDAnnotation.copyAppearanceDict(this.cosGetField(DK_AP).asDictionary());
        copy.cosSetField(DK_AP, newAppearance);
        return copy;
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Annot;
    }

    @Deprecated
    public void dispose() {
        PDPage page = PDAnnotationTools.getPage(this);
        if (page != null) {
            page.removeAnnotation(this);
        }
    }

    public PDAction getAction() {
        COSObject cosObject = this.cosGetField(DK_A);
        if (cosObject.isNull()) {
            return null;
        }
        return (PDAction)PDAction.META.createFromCos(cosObject);
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary field = this.cosGetField(DK_AA).asDictionary();
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(field);
    }

    public PDAppearance getAppearance() {
        COSObject cosObject = this.cosGetField(DK_AP);
        if (cosObject.isNull()) {
            return null;
        }
        return (PDAppearance)PDAppearance.META.createFromCos(cosObject);
    }

    public COSName getAppearanceState() {
        return this.cosGetField(DK_AS).asName();
    }

    public Set getAppearanceStates() {
        HashSet result = new HashSet();
        COSDictionary ap = this.cosGetField(DK_AP).asDictionary();
        if (ap != null) {
            COSDictionary states = ap.get(PDAppearance.DK_N).asDictionary();
            if (states != null) {
                result.addAll(states.keySet());
            }
            if ((states = ap.get(PDAppearance.DK_D).asDictionary()) != null) {
                result.addAll(states.keySet());
            }
            if ((states = ap.get(PDAppearance.DK_N).asDictionary()) != null) {
                result.addAll(states.keySet());
            }
        }
        return result;
    }

    public PDBorderStyle getBorderStyle() {
        COSObject cosObject;
        if (this.cachedBorderStyle == null && !(cosObject = this.cosGetField(DK_BS)).isNull()) {
            this.cachedBorderStyle = (PDBorderStyle)PDBorderStyle.META.createFromCos(cosObject);
        }
        return this.cachedBorderStyle;
    }

    public COSName getBorderStyleName() {
        PDBorderStyle bs = this.getBorderStyle();
        if (bs == null) {
            return PDBorderStyle.DK_S;
        }
        return bs.getStyle();
    }

    public float getBorderStyleWidth() {
        PDBorderStyle bs = this.getBorderStyle();
        if (bs == null) {
            return 1.0f;
        }
        return bs.getWidth();
    }

    public float[] getColor() {
        return this.getFieldFixedArray(DK_C, null);
    }

    public String getContents() {
        return this.getFieldMLString(DK_Contents, "");
    }

    public float getDefaultHeight() {
        return 1.0f;
    }

    public float getDefaultWidth() {
        return 1.0f;
    }

    public AnnotationFlags getFlags() {
        if (this.flags == null) {
            this.flags = new AnnotationFlags(this);
        }
        return this.flags;
    }

    public float getMinHeight() {
        float width = this.getBorderStyleWidth();
        return 2.0f * width;
    }

    public float getMinWidth() {
        float width = this.getBorderStyleWidth();
        return 2.0f * width;
    }

    public CDSDate getModified() {
        return CDSDate.createFromCOS(this.cosGetField(DK_M).asString());
    }

    public String getName() {
        return this.getFieldString(DK_NM, null);
    }

    public CDSRectangle getNormalizedRectangle() {
        CDSRectangle tempRect = this.getRectangle();
        if (tempRect == null) {
            return null;
        }
        return tempRect.copy().normalize();
    }

    public PDPage getPage() {
        COSObject cosObject = this.cosGetField(DK_P);
        return (PDPage)PDPageNode.META.createFromCos(cosObject);
    }

    public CDSRectangle getRectangle() {
        if (this.cachedRectangle == null) {
            COSArray array = this.cosGetField(DK_Rect).asArray();
            if (array == null) {
                return null;
            }
            this.cachedRectangle = CDSRectangle.createFromCOS(array);
        }
        return this.cachedRectangle;
    }

    protected Integer getStructParent() {
        COSInteger cosObject = this.cosGetField(DK_StructParent).asInteger();
        if (cosObject != null) {
            new Integer(cosObject.intValue());
        }
        return null;
    }

    public abstract String getSubtypeLabel();

    @Override
    public Set getSupportedTriggerEvents() {
        return ANNOTATION_ACTION_TRIGGERS;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        CDSRectangle initialRect = new CDSRectangle(0.0f, 0.0f, 0.0f, 0.0f);
        this.setRectangle(initialRect);
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedBorderStyle = null;
        this.cachedRectangle = null;
    }

    public boolean isHidden() {
        return this.getFlags().isHidden();
    }

    public boolean isInvisible() {
        return this.getFlags().isInvisible();
    }

    public boolean isLocked() {
        return this.getFlags().isLocked();
    }

    public boolean isMarkupAnnotation() {
        return false;
    }

    public boolean isNoRotate() {
        return this.getFlags().isNoRotate();
    }

    public boolean isNoView() {
        return this.getFlags().isNoView();
    }

    public boolean isNoZoom() {
        return this.getFlags().isNoZoom();
    }

    public boolean isPrint() {
        return this.getFlags().isPrint();
    }

    public boolean isReadOnly() {
        return this.getFlags().isReadOnly();
    }

    public boolean isToggleNoView() {
        return this.getFlags().isToggleNoView();
    }

    public boolean isWidgetAnnotation() {
        return false;
    }

    public void setAction(PDAction newAction) {
        this.setFieldObject(DK_A, newAction);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions actions) {
        this.setFieldObject(DK_AA, actions);
    }

    public void setAppearance(PDAppearance newAppearance) {
        this.setFieldObject(DK_AP, newAppearance);
    }

    public void setAppearanceState(COSName newAppearanceState) {
        this.cosSetField(DK_AS, newAppearanceState);
    }

    public void setBorderStyle(PDBorderStyle newBorderStyle) {
        this.setFieldObject(DK_BS, newBorderStyle);
    }

    public void setBorderStyleName(COSName newStyle) {
        PDBorderStyle bs = this.getBorderStyle();
        if (bs == null) {
            bs = (PDBorderStyle)PDBorderStyle.META.createNew();
            this.setBorderStyle(bs);
        }
        bs.setStyle(newStyle);
    }

    public void setBorderStyleWidth(float newWidth) {
        PDBorderStyle bs = this.getBorderStyle();
        if (bs == null) {
            bs = (PDBorderStyle)PDBorderStyle.META.createNew();
            this.setBorderStyle(bs);
        }
        bs.setWidth(newWidth);
    }

    public void setColor(float[] color) {
        this.setFieldFixedArray(DK_C, color);
    }

    public void setContents(String newContents) {
        this.setFieldString(DK_Contents, newContents);
    }

    public void setHidden(boolean f) {
        this.getFlags().setHidden(f);
    }

    public void setInvisible(boolean f) {
        this.getFlags().setInvisible(f);
    }

    public void setLocked(boolean f) {
        this.getFlags().setLocked(f);
    }

    protected void setModified(String newModified) {
        this.setFieldString(DK_M, newModified);
    }

    public void setName(String newName) {
        this.setFieldString(DK_NM, newName);
    }

    public void setNoRotate(boolean f) {
        this.getFlags().setNoRotate(f);
    }

    public void setNoView(boolean f) {
        this.getFlags().setNoView(f);
    }

    public void setNoZoom(boolean f) {
        this.getFlags().setNoZoom(f);
    }

    protected void setPage(PDPage newPage) {
        this.setFieldObject(DK_P, newPage);
    }

    public void setPrint(boolean f) {
        this.getFlags().setPrint(f);
    }

    public void setReadOnly(boolean readOnly) {
        this.getFlags().setReadOnly(readOnly);
    }

    public void setRectangle(CDSRectangle newRectangle) {
        this.checkRectangle(newRectangle);
        COSObject oldValue = this.setFieldObject(DK_Rect, newRectangle);
        CDSRectangle oldRectangle = CDSRectangle.createFromCOS(oldValue.asArray());
        if (oldRectangle != null) {
            this.updateStateRectangle(oldRectangle, newRectangle);
        }
    }

    protected void setStructParent(Integer newStructParent) {
        if (newStructParent != null) {
            this.setFieldInt(DK_StructParent, newStructParent);
        } else {
            this.cosRemoveField(DK_StructParent);
        }
    }

    public void setToggleNoView(boolean f) {
        this.getFlags().setToggleNoView(f);
    }

    public boolean supportsPrint() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Annotation: ");
        sb.append(this.cosGetSubtype());
        sb.append(" ");
        if (this.isWidgetAnnotation()) {
            PDAcroFormField field = (PDAcroFormField)PDAcroFormField.META.createFromCos(this.cosGetDict());
            sb.append(field.getQualifiedName());
            sb.append(" ");
        }
        sb.append(super.toString());
        return sb.toString();
    }

    public void touch() {
        this.setFieldObject(DK_M, new CDSDate());
    }

    protected void updateStateRectangle(CDSRectangle oldRectangle, CDSRectangle newRectangle) {
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            if (!(object instanceof COSDictionary)) {
                return null;
            }
            COSName type = ((COSDictionary)object).get(DK_Subtype).asName();
            if (PDWidgetAnnotation.CN_Subtype_Widget.equals(type)) {
                return PDWidgetAnnotation.META;
            }
            if (PDLinkAnnotation.CN_Subtype_Link.equals(type)) {
                return PDLinkAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Ink.equals(type)) {
                return PDInkAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Square.equals(type)) {
                return PDSquareAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Circle.equals(type)) {
                return PDCircleAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Line.equals(type)) {
                return PDLineAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_Polygon.equals(type)) {
                return PDPolygonAnnotation.META;
            }
            if (PDMarkupAnnotation.CN_Subtype_PolyLine.equals(type)) {
                return PDPolylineAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_Highlight.equals(type)) {
                return PDHighlightAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_Underline.equals(type)) {
                return PDUnderlineAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_Squiggly.equals(type)) {
                return PDSquigglyAnnotation.META;
            }
            if (PDTextMarkupAnnotation.CN_Subtype_StrikeOut.equals(type)) {
                return PDStrikeOutAnnotation.META;
            }
            if (PDPopupAnnotation.CN_Subtype_Popup.equals(type)) {
                return PDPopupAnnotation.META;
            }
            if (PDTextAnnotation.CN_Subtype_Text.equals(type)) {
                return PDTextAnnotation.META;
            }
            if (PDFileAttachmentAnnotation.CN_Subtype_FileAttachment.equals(type)) {
                return PDFileAttachmentAnnotation.META;
            }
            if (PDStampAnnotation.CN_Subtype_Stamp.equals(type)) {
                return PDStampAnnotation.META;
            }
            return PDAnyAnnotation.META;
        }

        @Override
        public Class getRootClass() {
            return PDAnnotation.class;
        }
    }
}

