/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAppearance;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDMarkupAnnotation;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPopupAnnotation;
import de.intarsys.pdf.pd.PDWidgetAnnotation;
import de.intarsys.pdf.st.STDocument;
import java.util.List;

public class PDAnnotationTools {
    public static final String CAPTION_CHECK = "4";
    public static final String CAPTION_CIRCLE = "l";
    public static final String CAPTION_CROSS = "8";
    public static final String CAPTION_DIAMOND = "u";
    public static final String CAPTION_SQUARE = "n";
    public static final String CAPTION_STAR = "H";

    public static void adjustRectangleToAppearance(PDAnnotation annotation) {
        PDAppearance appearance = annotation.getAppearance();
        if (appearance == null) {
            return;
        }
        PDAnnotationTools.adjustRectangleToAppearance(annotation, appearance);
    }

    public static void adjustRectangleToAppearance(PDAnnotation annotation, PDAppearance appearance) {
        List<PDForm> forms = appearance.getForms();
        Float maxWidth = null;
        Float maxHeight = null;
        for (PDForm form : forms) {
            CDSRectangle formRect = form.getBoundingBox();
            float width = formRect.getWidth();
            float height = formRect.getHeight();
            if (maxWidth == null || width > maxWidth.floatValue()) {
                maxWidth = Float.valueOf(width);
            }
            if (maxHeight != null && !(height > maxHeight.floatValue())) continue;
            maxHeight = Float.valueOf(height);
        }
        boolean changedRect = false;
        CDSRectangle rect = annotation.getNormalizedRectangle();
        if (maxWidth != null && maxWidth.floatValue() != rect.getWidth()) {
            rect.setWidth(maxWidth.floatValue());
            changedRect = true;
        }
        if (maxHeight != null && maxHeight.floatValue() != rect.getHeight()) {
            rect.setHeight(maxHeight.floatValue());
            changedRect = true;
        }
        if (changedRect) {
            STDocument stDoc = PDAnnotationTools.getSTDocument(annotation);
            boolean wasDirty = stDoc == null || stDoc.isDirty();
            annotation.setRectangle(rect);
            if (!wasDirty) {
                stDoc.setDirty(false);
            }
        }
    }

    private static STDocument getSTDocument(PDAnnotation annotation) {
        COSDocument cosDoc = annotation.cosGetDoc();
        return cosDoc == null ? null : cosDoc.stGetDoc();
    }

    public static PDAppearance getAppearance(PDAnnotation annotation) {
        PDAppearance appearance = annotation.getAppearance();
        if (appearance == null) {
            appearance = (PDAppearance)PDAppearance.META.createNew();
        }
        return appearance;
    }

    public static float[] getBorderColor(PDWidgetAnnotation annotation) {
        PDAppearanceCharacteristics appearanceCharacteristics = annotation.getAppearanceCharacteristics();
        if (appearanceCharacteristics == null) {
            return null;
        }
        return appearanceCharacteristics.getBorderColor();
    }

    public static float[] getBorderColorNegative(PDWidgetAnnotation annotation) {
        float[] borderColor = PDAnnotationTools.getBorderColor(annotation);
        if (borderColor == null) {
            return null;
        }
        float[] borderColorNegative = new float[borderColor.length];
        int i = 0;
        while (i < borderColor.length) {
            borderColorNegative[i] = Math.max(Math.min(borderColorNegative[i] + 0.25f, 1.0f), 0.0f);
            ++i;
        }
        return borderColorNegative;
    }

    public static float[] getFillColor(PDWidgetAnnotation annotation) {
        PDAppearanceCharacteristics appearanceCharacteristics = annotation.getAppearanceCharacteristics();
        if (appearanceCharacteristics == null) {
            return null;
        }
        return appearanceCharacteristics.getBackgroundColor();
    }

    public static float[] getFillColorNegative(PDWidgetAnnotation annotation) {
        float[] fillColor = PDAnnotationTools.getFillColor(annotation);
        if (fillColor == null) {
            return null;
        }
        float[] fillColorNegative = new float[fillColor.length];
        int i = 0;
        while (i < fillColor.length) {
            fillColorNegative[i] = Math.max(Math.min(fillColor[i] - 0.25f, 1.0f), 0.0f);
            ++i;
        }
        return fillColorNegative;
    }

    public static PDAnnotation getNextAnnotation(PDAnnotation annotation) {
        PDPage page = PDAnnotationTools.getPage(annotation);
        if (page == null) {
            return null;
        }
        return page.getNextAnnotation(annotation);
    }

    public static PDAnnotation getNextAnnotationAllPages(PDAnnotation annotation) {
        PDPage page = PDAnnotationTools.getPage(annotation);
        if (page == null) {
            return null;
        }
        PDAnnotation result = PDAnnotationTools.getNextAnnotation(annotation);
        while (result == null) {
            if ((page = page.getNextPage()) == null) {
                return null;
            }
            result = page.getFirstAnnotation();
        }
        return result;
    }

    public static PDPage getPage(PDAnnotation annotation) {
        PDPage page = annotation.getPage();
        if (page != null) {
            return page;
        }
        PDDocument doc = annotation.getDoc();
        if (doc == null) {
            return null;
        }
        page = doc.getPageTree().getFirstPage();
        while (page != null) {
            List<PDAnnotation> pageAnnots = page.getAnnotations();
            if (pageAnnots != null) {
                for (PDAnnotation current : pageAnnots) {
                    if (current.cosGetObject() != annotation.cosGetObject()) continue;
                    return page;
                }
            }
            page = page.getNextPage();
        }
        return null;
    }

    public static PDAnnotation getPreviousAnnotation(PDAnnotation annotation) {
        PDPage page = PDAnnotationTools.getPage(annotation);
        if (page == null) {
            return null;
        }
        return page.getPreviousAnnotation(annotation);
    }

    public static PDAnnotation getPreviousAnnotationAllPages(PDAnnotation annotation) {
        PDPage page = PDAnnotationTools.getPage(annotation);
        if (page == null) {
            return null;
        }
        PDAnnotation result = PDAnnotationTools.getPreviousAnnotation(annotation);
        while (result == null) {
            if ((page = page.getPreviousPage()) == null) {
                return null;
            }
            result = page.getLastAnnotation();
        }
        return result;
    }

    public static COSName getStateChecked(PDWidgetAnnotation annotation) {
        for (COSName state : annotation.getAppearanceStates()) {
            if (!PDAnnotationTools.isStateChecked(state)) continue;
            return state;
        }
        return null;
    }

    public static boolean isAnnotationSpec14(COSDictionary dict) {
        COSName subtype = dict.get(PDObject.DK_Subtype).asName();
        if (subtype == null) {
            return false;
        }
        if (subtype.equals(PDWidgetAnnotation.CN_Subtype_Widget)) {
            return true;
        }
        if (subtype.equals(PDMarkupAnnotation.CN_Subtype_Ink)) {
            return true;
        }
        if (subtype.equals(PDMarkupAnnotation.CN_Subtype_Square)) {
            return true;
        }
        if (subtype.equals(PDMarkupAnnotation.CN_Subtype_Circle)) {
            return true;
        }
        if (subtype.equals(PDMarkupAnnotation.CN_Subtype_Line)) {
            return true;
        }
        if (subtype.equals(PDMarkupAnnotation.CN_Subtype_Polygon)) {
            return true;
        }
        if (subtype.equals(PDMarkupAnnotation.CN_Subtype_PolyLine)) {
            return true;
        }
        if (subtype.equals(PDPopupAnnotation.CN_Subtype_Popup)) {
            return true;
        }
        if (subtype.equals(COSName.constant("Link"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("FreeText"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("Highlight"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("Underline"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("Squiggly"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("StrikeOut"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("Stamp"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("FileAttachment"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("Sound"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("Movie"))) {
            return true;
        }
        if (subtype.equals(COSName.constant("PrinterMark"))) {
            return true;
        }
        return subtype.equals(COSName.constant("TrapNet"));
    }

    public static boolean isStateChecked(COSName state) {
        return !PDWidgetAnnotation.CN_State_Off.equals(state);
    }

    public static void transform(CDSRectangle rect, CDSMatrix matrix, int rotation) {
        if (rotation == 90) {
            matrix.setTransformation(CDSMatrix.MATRIX_90);
        } else if (rotation == 180) {
            matrix.setTransformation(CDSMatrix.MATRIX_180);
        } else if (rotation == 270) {
            matrix.setTransformation(CDSMatrix.MATRIX_270);
        }
        float[] vec = new float[]{rect.getWidth(), rect.getHeight()};
        float[] tVec = matrix.transform(vec);
        if (rotation == 90) {
            matrix.setE(rect.getWidth());
        } else if (rotation == 180) {
            matrix.setE(rect.getWidth());
            matrix.setF(rect.getHeight());
        } else if (rotation == 270) {
            matrix.setF(rect.getHeight());
        }
        rect.setCorners(0.0f, 0.0f, tVec[0], tVec[1]);
        rect.normalize();
    }

    private PDAnnotationTools() {
    }
}

