/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDDestination;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPageNode;

public class PDExplicitDestination
extends PDDestination {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_DISPLAY_MODE_XYZ = COSName.constant("XYZ");
    public static final COSName CN_DISPLAY_MODE_Fit = COSName.constant("Fit");
    public static final COSName CN_DISPLAY_MODE_FitH = COSName.constant("FitH");
    public static final COSName CN_DISPLAY_MODE_FitV = COSName.constant("FitV");
    public static final COSName CN_DISPLAY_MODE_FitR = COSName.constant("FitR");
    public static final COSName CN_DISPLAY_MODE_FitB = COSName.constant("FitB");
    public static final COSName CN_DISPLAY_MODE_FitBH = COSName.constant("FitBH");
    public static final COSName CN_DISPLAY_MODE_FitBV = COSName.constant("FitBV");

    protected PDExplicitDestination(COSObject object) {
        super(object);
    }

    public COSName getDisplayMode() {
        COSArray definition = this.cosGetArray();
        if (definition.size() < 2) {
            return null;
        }
        return definition.get(1).asName();
    }

    public PDPage getPage(PDDocument doc) {
        COSArray definition = this.cosGetArray();
        COSObject page = definition.get(0);
        if (page.asNumber() != null) {
            int pageIndex = page.asNumber().intValue();
            return doc.getPageTree().getPageAt(pageIndex);
        }
        if (page.asDictionary() != null) {
            return (PDPage)PDPageNode.META.createFromCos(page.asDictionary());
        }
        return null;
    }

    public float[] getParameters() {
        COSArray definition = this.cosGetArray();
        int size = definition.size() - 2;
        if (size < 0) {
            return new float[0];
        }
        float[] result = new float[size];
        int i = 0;
        while (i < size) {
            COSNumber param = definition.get(i + 2).asNumber();
            result[i] = param == null ? 0.0f : param.floatValue();
            ++i;
        }
        return result;
    }

    @Override
    public PDExplicitDestination getResolvedDestination(PDDocument doc) {
        return this;
    }

    public void setDisplayMode(COSName mode) {
        COSArray definition = this.cosGetArray();
        if (definition.size() == 0) {
            definition.add(COSNull.NULL);
            definition.add(mode);
        } else if (definition.size() == 1) {
            definition.add(mode);
        } else {
            definition.set(1, mode);
        }
    }

    public void setPage(PDPage page) {
        COSArray definition = this.cosGetArray();
        if (definition.size() == 0) {
            definition.add(page.cosGetObject());
        } else {
            definition.set(0, page.cosGetObject());
        }
    }

    public void setParameters(double[] parameters) {
        COSArray definition = this.cosGetArray();
        while (definition.size() < 2 + parameters.length) {
            definition.add(COSNull.NULL);
        }
        int i = 0;
        while (i < parameters.length) {
            definition.set(i + 2, COSFixed.create(parameters[i]));
            ++i;
        }
    }

    public void setParameters(float[] parameters) {
        COSArray definition = this.cosGetArray();
        while (definition.size() < 2 + parameters.length) {
            definition.add(COSNull.NULL);
        }
        int i = 2;
        while (i < 2 + parameters.length) {
            definition.set(i, COSFixed.create(parameters[i]));
            ++i;
        }
    }

    public static class MetaClass
    extends PDDestination.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDExplicitDestination(object);
        }
    }
}

