/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDApplicationData;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.pdf.pd.PDXObject;
import java.awt.geom.Rectangle2D;

public class PDForm
extends PDXObject
implements IContentStreamProvider {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Subtype_Form = COSName.constant("Form");
    public static final COSName DK_BBox = COSName.constant("BBox");
    public static final COSName DK_Matrix = COSName.constant("Matrix");
    public static final COSName DK_PieceInfo = COSName.constant("PieceInfo");
    public static final COSName DK_FormType = COSName.constant("FormType");
    public static final COSName DK_OPI = COSName.constant("OPI");
    public static final COSName DK_PS = COSName.constant("PS");
    public static final COSName DK_Ref = COSName.constant("Ref");
    public static final COSName DK_Subtype2 = COSName.constant("Subtype2");
    public static final COSName DK_Group = COSName.constant("Group");
    private CSContent cachedContent;
    private Rectangle2D cachedTransformedBBox;

    protected PDForm(COSObject object) {
        super(object);
    }

    public void setApplicationData(COSName name, PDApplicationData data) {
        COSDictionary pid = this.cosGetPieceInfo();
        if (pid == null) {
            pid = COSDictionary.create();
            this.cosSetPieceInfo(pid);
        }
        pid.put(name, data.cosGetDict());
    }

    public PDApplicationData getApplicationData(COSName name) {
        COSDictionary pid = this.cosGetPieceInfo();
        if (pid == null) {
            return null;
        }
        COSDictionary pi = pid.get(name).asDictionary();
        if (pi == null) {
            return null;
        }
        return (PDApplicationData)PDApplicationData.META.createFromCos(pi);
    }

    public void setBoundingBox(CDSRectangle rect) {
        this.setFieldObject(DK_BBox, rect);
    }

    public CDSRectangle getBoundingBox() {
        COSArray array = this.cosGetField(DK_BBox).asArray();
        if (array == null) {
            return null;
        }
        return CDSRectangle.createFromCOS(array);
    }

    @Override
    public CSContent getContentStream() {
        if (this.cachedContent == null) {
            this.cachedContent = CSContent.createFromCos(this.cosGetStream());
        }
        return this.cachedContent;
    }

    @Override
    public void setContentStream(CSContent content) {
        this.setBytes(content.toByteArray());
    }

    @Override
    public boolean isForm() {
        return true;
    }

    public void setMarkedContent(byte[] content) {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        CSContent contentStream = CSContent.createFromBytes(bytes);
        contentStream.setMarkedContent(CSOperation.OPERAND_Tx, content);
        this.setBytes(contentStream.toByteArray());
    }

    public void setMatrix(CDSMatrix matrix) {
        this.setFieldObject(DK_Matrix, matrix);
    }

    public CDSMatrix getMatrix() {
        return CDSMatrix.createFromCOS(this.cosGetField(DK_Matrix).asArray());
    }

    @Override
    public PDResources getResources() {
        COSDictionary r = this.cosGetField(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(r);
    }

    @Override
    public void setResources(PDResources resources) {
        this.setFieldObject(DK_Resources, resources);
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Form;
    }

    public Rectangle2D getTransformedBBox() {
        if (this.cachedTransformedBBox == null) {
            float[] vec;
            Rectangle2D.Float bbox = (Rectangle2D.Float)this.getBoundingBox().toRectangle();
            CDSMatrix matrix = this.getMatrix();
            float[] tvec = vec = new float[]{bbox.x, bbox.y, bbox.x + bbox.width, bbox.y, bbox.x + bbox.width, bbox.y + bbox.height, bbox.x, bbox.y + bbox.height};
            if (matrix != null) {
                tvec = matrix.transform(vec);
            }
            float minX = tvec[0];
            float minY = tvec[1];
            float maxX = tvec[0];
            float maxY = tvec[1];
            minX = Math.min(minX, tvec[2]);
            minY = Math.min(minY, tvec[3]);
            maxX = Math.max(maxX, tvec[2]);
            maxY = Math.max(maxY, tvec[3]);
            minX = Math.min(minX, tvec[4]);
            minY = Math.min(minY, tvec[5]);
            maxX = Math.max(maxX, tvec[4]);
            maxY = Math.max(maxY, tvec[5]);
            minX = Math.min(minX, tvec[6]);
            minY = Math.min(minY, tvec[7]);
            maxX = Math.max(maxX, tvec[6]);
            maxY = Math.max(maxY, tvec[7]);
            this.cachedTransformedBBox = new Rectangle2D.Float(minX, minY, maxX - minX, maxY - minY);
        }
        return this.cachedTransformedBBox;
    }

    public void addMarkedContent(byte[] content) {
        byte[] bytes = this.getBytes();
        if (bytes == null) {
            bytes = new byte[]{};
        }
        CSContent contentStream = CSContent.createFromBytes(bytes);
        contentStream.addMarkedContent(CSOperation.OPERAND_Tx, content);
        this.setBytes(contentStream.toByteArray());
    }

    public COSDictionary cosGetPieceInfo() {
        return this.cosGetField(DK_PieceInfo).asDictionary();
    }

    public COSDictionary cosSetPieceInfo(COSDictionary dict) {
        if (dict != null) {
            dict.beIndirect();
        }
        return this.cosSetField(DK_PieceInfo, dict).asDictionary();
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedContent = null;
        this.cachedTransformedBBox = null;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setBoundingBox(new CDSRectangle());
        this.setMatrix(new CDSMatrix());
        this.cosSetField(DK_Resources, COSDictionary.create());
        this.cosSetField(DK_FormType, COSInteger.create(1));
        this.setBytes(new byte[0]);
    }

    public static class MetaClass
    extends PDXObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDForm(object);
        }
    }
}

