/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNumber;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDInterpolationFunction;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPostScriptFunction;
import de.intarsys.pdf.pd.PDSampledFunction;
import de.intarsys.pdf.pd.PDStitchingFunction;

public abstract class PDFunction
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_FunctionType = COSName.constant("FunctionType");
    public static final COSName DK_Domain = COSName.constant("Domain");
    public static final COSName DK_Range = COSName.constant("Range");

    protected PDFunction(COSObject object) {
        super(object);
    }

    public abstract float[] evaluate(float[] var1);

    public float getDomainMax(int dimension) {
        return ((COSNumber)this.cosGetDomain().get(dimension * 2 + 1)).floatValue();
    }

    public float getDomainMin(int dimension) {
        return ((COSNumber)this.cosGetDomain().get(dimension * 2)).floatValue();
    }

    public int getInputSize() {
        return this.cosGetDomain().size() / 2;
    }

    public abstract int getOutputSize();

    public COSArray cosGetDomain() {
        return this.cosGetDict().get(DK_Domain).asArray();
    }

    public COSArray getRange() {
        return this.cosGetDict().get(DK_Range).asArray();
    }

    public float getRangeMax(int dimension) {
        return ((COSNumber)this.getRange().get(dimension * 2 + 1)).floatValue();
    }

    public float getRangeMin(int dimension) {
        return ((COSNumber)this.getRange().get(dimension * 2)).floatValue();
    }

    protected float clip(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    protected float[] dummyResult() {
        float[] result = new float[this.getOutputSize()];
        int i = 0;
        while (i < result.length) {
            result[i] = 0.5f;
            ++i;
        }
        return result;
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        public Class getRootClass() {
            return PDFunction.class;
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject object) {
            COSDictionary dict = null;
            if (object instanceof COSStream) {
                dict = ((COSStream)object).getDict();
            } else if (object instanceof COSDictionary) {
                dict = (COSDictionary)object;
            }
            if (dict == null) {
                throw new IllegalArgumentException("No Function dictionary available");
            }
            COSInteger type = dict.get(DK_FunctionType).asInteger();
            if (type == null) {
                throw new IllegalArgumentException("Function dictionary has no type");
            }
            if (type.intValue() == 0) {
                return PDSampledFunction.META;
            }
            if (type.intValue() == 2) {
                return PDInterpolationFunction.META;
            }
            if (type.intValue() == 3) {
                return PDStitchingFunction.META;
            }
            if (type.intValue() == 4) {
                return PDPostScriptFunction.META;
            }
            throw new IllegalArgumentException("Function type " + type + " not supported");
        }
    }
}

