/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.IContentStreamProvider;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.IAdditionalActionSupport;
import de.intarsys.pdf.pd.PDAdditionalActions;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDApplicationData;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPageNode;
import de.intarsys.pdf.pd.PDPageTree;
import de.intarsys.pdf.pd.PDResources;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PDPage
extends PDPageNode
implements IAdditionalActionSupport,
IContentStreamProvider {
    public static String COPY_SUFFIX = "_copy";
    public static final COSName DK_Annots = COSName.constant("Annots");
    public static final COSName DK_Contents = COSName.constant("Contents");
    public static final COSName DK_MediaBox = COSName.constant("MediaBox");
    public static final COSName DK_CropBox = COSName.constant("CropBox");
    public static final COSName DK_BleedBox = COSName.constant("BleedBox");
    public static final COSName DK_TrimBox = COSName.constant("TrimBox");
    public static final COSName DK_ArtBox = COSName.constant("ArtBox");
    public static final COSName DK_Metadata = COSName.constant("Metadata");
    public static final COSName DK_PieceInfo = COSName.constant("PieceInfo");
    public static final COSName DK_Resources = COSName.constant("Resources");
    public static final COSName DK_TemplateInstantiated = COSName.constant("TemplateInstantiated");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static final List NULL = new ArrayList();
    public static final Set PAGE_ACTION_TRIGGERS = new HashSet(3);
    private SoftReference cachedAnnotations = null;
    private SoftReference cachedContentStream = null;

    static {
        PAGE_ACTION_TRIGGERS.add("O");
        PAGE_ACTION_TRIGGERS.add("C");
    }

    protected PDPage(COSObject object) {
        super(object);
    }

    public void addAnnotation(PDAnnotation annot) {
        COSArray cosAnnots = this.cosGetField(DK_Annots).asArray();
        if (cosAnnots == null) {
            cosAnnots = COSArray.create();
            cosAnnots.beIndirect();
            this.cosSetField(DK_Annots, cosAnnots);
            this.cachedAnnotations = null;
        }
        cosAnnots.add(annot.cosGetDict());
        annot.setPage(this);
    }

    public void addContentStream(CSContent contentStream) {
        this.cosAddContents(contentStream.createStream());
    }

    @Override
    protected void collectAnnotations(List annotations) {
        if (this.getAnnotations() != null) {
            annotations.addAll(this.getAnnotations());
        }
    }

    public void cosAddContents(COSStream content) {
        COSArray array;
        COSObject contents = this.cosGetField(DK_Contents);
        if (contents.isNull()) {
            this.cosSetField(DK_Contents, content);
        }
        if (contents instanceof COSStream) {
            array = COSArray.create(2);
            array.add(contents);
            array.add(content);
            this.cosSetField(DK_Contents, array);
        }
        if (contents instanceof COSArray) {
            array = (COSArray)contents;
            array.add(content);
        }
    }

    public COSObject cosGetContents() {
        return this.cosGetField(DK_Contents);
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_Page;
    }

    public COSDictionary cosGetPieceInfo() {
        return this.cosGetField(DK_PieceInfo).asDictionary();
    }

    public COSName cosGetTemplateInstantiated() {
        return this.cosGetField(DK_TemplateInstantiated).asName();
    }

    public void cosPrependContents(COSStream content) {
        COSArray array;
        COSObject contents = this.cosGetField(DK_Contents);
        if (contents.isNull()) {
            this.cosSetField(DK_Contents, content);
        }
        if (contents instanceof COSStream) {
            array = COSArray.create(2);
            array.add(content);
            array.add(contents);
            this.cosSetField(DK_Contents, array);
        }
        if (contents instanceof COSArray) {
            array = (COSArray)contents;
            array.add(0, content);
        }
    }

    public COSObject cosSetContents(COSObject content) {
        return this.cosSetField(DK_Contents, content);
    }

    public COSDictionary cosSetPieceInfo(COSDictionary dict) {
        if (dict != null) {
            dict.beIndirect();
        }
        return this.cosSetField(DK_PieceInfo, dict).asDictionary();
    }

    public void cosSetTemplateInstantiated(COSName templateName) {
        this.cosSetField(DK_TemplateInstantiated, templateName);
    }

    @Override
    public void dispose() {
        if (this.getAnnotations() != null) {
            for (PDAnnotation annotation : this.getAnnotations()) {
                annotation.dispose();
            }
        }
        super.dispose();
    }

    protected void getAcroFormFields(PDObject parent, List result) {
        List elements = parent.getGenericChildren();
        List<PDAnnotation> annotations = this.getAnnotations();
        if (elements == null) {
            return;
        }
        for (PDObject object : elements) {
            if (annotations.contains(object)) {
                result.add(object);
            }
            this.getAcroFormFields(object, result);
        }
    }

    @Override
    public PDAdditionalActions getAdditionalActions() {
        COSDictionary field = this.cosGetField(DK_AA).asDictionary();
        return (PDAdditionalActions)PDAdditionalActions.META.createFromCos(field);
    }

    public List<PDAnnotation> getAnnotations() {
        List annotations = null;
        if (this.cachedAnnotations != null) {
            annotations = (List)this.cachedAnnotations.get();
        }
        if (annotations == null) {
            annotations = this.getPDObjects(DK_Annots, PDAnnotation.META, true);
            if (annotations == null) {
                annotations = NULL;
            }
            this.cachedAnnotations = new SoftReference<List>(annotations);
        }
        if (annotations == NULL) {
            return null;
        }
        return annotations;
    }

    public PDApplicationData getApplicationData(String name) {
        COSDictionary pid = this.cosGetPieceInfo();
        if (pid == null) {
            return null;
        }
        COSName cosName = COSName.createUTF8(name);
        COSDictionary pi = pid.get(cosName).asDictionary();
        if (pi == null) {
            return null;
        }
        return (PDApplicationData)PDApplicationData.META.createFromCos(pi);
    }

    protected int getContentsSize() {
        COSObject contents = this.cosGetContents();
        if (contents.isNull()) {
            return 0;
        }
        if (contents instanceof COSStream) {
            return 1;
        }
        return ((COSArray)contents).size();
    }

    @Override
    public CSContent getContentStream() {
        COSObject contents;
        CSContent contentStream = null;
        if (this.cachedContentStream != null) {
            contentStream = (CSContent)this.cachedContentStream.get();
        }
        if (contentStream == null && !(contents = this.cosGetContents()).isNull()) {
            contentStream = contents instanceof COSStream ? CSContent.createFromCos(contents.asStream()) : CSContent.createFromCos(contents.asArray());
            contents.removeObjectListener(this);
            contents.addObjectListener(this);
            this.cachedContentStream = new SoftReference<CSContent>(contentStream);
        }
        return contentStream;
    }

    @Override
    public int getCount() {
        return 1;
    }

    @Override
    public PDAnnotation getFirstAnnotation() {
        if (this.getAnnotations() == null) {
            return null;
        }
        if (this.getAnnotations().size() == 0) {
            return null;
        }
        return this.getAnnotations().get(0);
    }

    @Override
    public PDPageNode getFirstNode() {
        return this;
    }

    @Override
    public PDPage getFirstPage() {
        return this;
    }

    @Override
    public PDAnnotation getLastAnnotation() {
        if (this.getAnnotations() == null) {
            return null;
        }
        int size = this.getAnnotations().size();
        if (size == 0) {
            return null;
        }
        return this.getAnnotations().get(size - 1);
    }

    @Override
    public PDPageNode getLastNode() {
        return this;
    }

    @Override
    public PDPage getLastPage() {
        return this;
    }

    public PDAnnotation getNextAnnotation(PDAnnotation annot) {
        if (this.getAnnotations() == null) {
            return null;
        }
        int resultIndex = this.getAnnotations().indexOf(annot);
        if (resultIndex == -1) {
            return null;
        }
        if (resultIndex + 1 < this.getAnnotations().size()) {
            return this.getAnnotations().get(resultIndex + 1);
        }
        return null;
    }

    public PDPage getNextPage() {
        PDPageTree tmpParent = this.getParent();
        if (tmpParent == null) {
            return null;
        }
        return tmpParent.getNextPage(this);
    }

    @Override
    public PDPage getPageAt(int index) {
        if (index == 0) {
            return this;
        }
        return super.getPageAt(index);
    }

    public PDAnnotation getPreviousAnnotation(PDAnnotation annot) {
        if (this.getAnnotations() == null) {
            return null;
        }
        int resultIndex = this.getAnnotations().indexOf(annot);
        if (resultIndex == -1) {
            return null;
        }
        if (resultIndex - 1 >= 0) {
            return this.getAnnotations().get(resultIndex - 1);
        }
        return null;
    }

    public PDPage getPreviousPage() {
        PDPageTree tmpParent = this.getParent();
        if (tmpParent == null) {
            return null;
        }
        return tmpParent.getPreviousPage(this);
    }

    @Override
    public PDResources getResources() {
        COSDictionary dict = this.cosGetFieldInheritable(DK_Resources).asDictionary();
        return (PDResources)PDResources.META.createFromCos(dict);
    }

    @Override
    public Set getSupportedTriggerEvents() {
        return PAGE_ACTION_TRIGGERS;
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.setMediaBox(new CDSRectangle(CDSRectangle.SIZE_A4));
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedAnnotations = null;
        this.cachedContentStream = null;
        COSObject cosAnnotations = this.cosGetField(DK_Annots);
        cosAnnotations.removeObjectListener(this);
        COSObject cosContents = this.cosGetField(DK_Contents);
        cosContents.removeObjectListener(this);
    }

    @Override
    public boolean isPage() {
        return true;
    }

    @Override
    public boolean isValid() {
        PDPageTree tempParent = this.getParent();
        if (tempParent == null) {
            return false;
        }
        return tempParent.isValid();
    }

    public void prependContentStream(CSContent contentStream) {
        this.cosPrependContents(contentStream.createStream());
    }

    public void removeAnnotation(PDAnnotation annot) {
        COSArray cosAnnots = this.cosGetField(DK_Annots).asArray();
        if (cosAnnots != null) {
            cosAnnots.remove(annot.cosGetDict());
            if (cosAnnots.isEmpty()) {
                this.cosRemoveField(DK_Annots);
            }
        }
    }

    public void removeApplicationData(String name) {
        COSDictionary pid = this.cosGetPieceInfo();
        if (pid == null) {
            return;
        }
        COSName cosName = COSName.createUTF8(name);
        pid.remove(cosName);
    }

    @Override
    public void setAdditionalActions(PDAdditionalActions actions) {
        this.setFieldObject(DK_AA, actions);
    }

    public void setApplicationData(String name, PDApplicationData data) {
        COSDictionary pid = this.cosGetPieceInfo();
        if (pid == null) {
            pid = COSDictionary.create();
            this.cosSetPieceInfo(pid);
        }
        COSName cosName = COSName.createUTF8(name);
        pid.put(cosName, data.cosGetDict());
    }

    @Override
    public void setContentStream(CSContent contentStream) {
        if (contentStream != null) {
            this.cosSetContents(contentStream.createStream());
        } else {
            this.cosSetContents(null);
        }
    }

    @Override
    public void setResources(PDResources resources) {
        this.cosSetField(DK_Resources, resources.cosGetDict());
    }

    public void setBleedBox(CDSRectangle rect) {
        this.setFieldObject(DK_BleedBox, rect);
    }

    public CDSRectangle getBleedBox() {
        COSArray array = this.cosGetField(DK_BleedBox).asArray();
        if (array == null) {
            return this.getCropBox();
        }
        return CDSRectangle.createFromCOS(array);
    }

    public void setTrimBox(CDSRectangle rect) {
        this.setFieldObject(DK_TrimBox, rect);
    }

    public CDSRectangle getTrimBox() {
        COSArray array = this.cosGetField(DK_TrimBox).asArray();
        if (array == null) {
            return this.getCropBox();
        }
        return CDSRectangle.createFromCOS(array);
    }

    public void setArtBox(CDSRectangle rect) {
        this.setFieldObject(DK_ArtBox, rect);
    }

    public CDSRectangle getArtBox() {
        COSArray array = this.cosGetField(DK_ArtBox).asArray();
        if (array == null) {
            return this.getCropBox();
        }
        return CDSRectangle.createFromCOS(array);
    }

    public static class MetaClass
    extends PDPageNode.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDPage(object);
        }
    }
}

