/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.encoding.PDFDocEncoding;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.postscript.Handler;
import de.intarsys.pdf.postscript.ParseException;
import de.intarsys.pdf.postscript.Parser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class PDPostScriptFunction
extends PDFunction {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private String code;

    protected PDPostScriptFunction(COSObject object) {
        super(object);
    }

    @Override
    public COSDictionary cosGetDict() {
        return this.cosGetStream().getDict();
    }

    @Override
    public float[] evaluate(float[] values) {
        Handler handler = new Handler();
        ArrayList<Double> argList = new ArrayList<Double>(values.length);
        int index = 0;
        while (index < values.length) {
            argList.add(new Double(values[index]));
            ++index;
        }
        handler.pushArgs(argList);
        try {
            new Parser(new StringReader(this.getCode())).parse(handler);
        }
        catch (ParseException ex) {
            return this.dummyResult();
        }
        catch (UnsupportedOperationException ex) {
            return this.dummyResult();
        }
        List resultList = handler.popResult();
        float[] result = new float[this.getOutputSize()];
        index = 0;
        while (index < result.length) {
            result[index] = ((Number)resultList.get(index)).floatValue();
            ++index;
        }
        return result;
    }

    public String getCode() {
        if (this.code == null) {
            byte[] bytes = this.cosGetStream().getDecodedBytes();
            String string = PDFDocEncoding.UNIQUE.decode(bytes);
            int start = string.indexOf(123);
            int stop = string.lastIndexOf(125);
            this.code = start != -1 && stop != -1 ? string.substring(start + 1, stop) : string;
        }
        return this.code;
    }

    @Override
    public int getOutputSize() {
        return this.getRange().size() / 2;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDPostScriptFunction(object);
        }

        @Override
        protected COSObject doCreateCOSObject() {
            return COSStream.create(null);
        }
    }
}

