/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDObject;
import java.util.ArrayList;
import java.util.List;

public class PDTransformParams
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName CN_Type_TransformParams = COSName.constant("TransformParams");
    public static final COSName DK_P = COSName.constant("P");
    public static final COSName DK_V = COSName.constant("V");
    public static final COSName DK_Action = COSName.constant("Action");
    public static final COSName DK_Fields = COSName.constant("Fields");
    public static final COSName CN_All = COSName.constant("All");
    public static final COSName CN_Include = COSName.constant("Include");
    public static final COSName CN_Exclude = COSName.constant("Exclude");
    public static final COSName CN_Version_1_2 = COSName.constant("1.2");

    protected PDTransformParams(COSObject object) {
        super(object);
    }

    public COSName cosGetAction() {
        return this.cosGetField(DK_Action).asName();
    }

    @Override
    protected COSName cosGetExpectedType() {
        return CN_Type_TransformParams;
    }

    public COSArray cosGetFields() {
        return this.cosGetField(DK_Fields).asArray();
    }

    public void cosSetAction(COSName action) {
        this.cosSetField(DK_Action, action);
    }

    public void cosSetFields(COSArray fields) {
        this.cosSetField(DK_Fields, fields);
    }

    public List<String> getFields() {
        ArrayList<String> fields = new ArrayList<String>();
        COSArray cosFields = this.cosGetFields();
        if (cosFields != null) {
            int i = 0;
            while (i < cosFields.size()) {
                COSString cosFieldName = cosFields.get(i).asString();
                fields.add(cosFieldName.stringValue());
                ++i;
            }
        }
        return fields;
    }

    public int getPermissions() {
        return this.getFieldInt(DK_P, 2);
    }

    @Override
    protected void initializeFromScratch() {
        super.initializeFromScratch();
        this.cosSetField(DK_V, CN_Version_1_2);
    }

    public boolean isActionAll() {
        return CN_All.equals(this.cosGetAction());
    }

    public boolean isActionExclude() {
        return CN_Exclude.equals(this.cosGetAction());
    }

    public boolean isActionInclude() {
        return CN_Include.equals(this.cosGetAction());
    }

    public void setPermissions(int permissions) {
        this.cosSetField(DK_P, COSInteger.create(permissions));
    }

    public void setVersion(String version) {
        this.cosSetField(DK_V, COSName.create(version));
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDTransformParams(object);
        }
    }
}

