/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.pd.PDAFButtonField;
import de.intarsys.pdf.pd.PDAcroFormField;
import de.intarsys.pdf.pd.PDAnnotation;
import de.intarsys.pdf.pd.PDAnnotationTools;
import de.intarsys.pdf.pd.PDAppearanceCharacteristics;
import java.util.Set;

public class PDWidgetAnnotation
extends PDAnnotation {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_H = COSName.constant("H");
    public static final COSName CN_H_N = COSName.constant("N");
    public static final COSName CN_H_I = COSName.constant("I");
    public static final COSName CN_H_O = COSName.constant("O");
    public static final COSName CN_H_P = COSName.constant("P");
    public static final COSName CN_H_T = COSName.constant("T");
    public static final COSName DK_MK = COSName.constant("MK");
    public static final COSName CN_Subtype_Widget = COSName.constant("Widget");
    public static final COSName CN_State_Off = COSName.constant("Off");

    protected PDWidgetAnnotation(COSObject object) {
        super(object);
    }

    @Override
    public boolean canReceiveFocus() {
        if (super.canReceiveFocus()) {
            PDAcroFormField field = this.getAcroFormField();
            return !field.isReadOnly() && (field.isTypeTx() || field.isTypeBtn() || field.isTypeCh());
        }
        return false;
    }

    @Override
    protected COSName cosGetExpectedSubtype() {
        return CN_Subtype_Widget;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getAcroFormField().dispose(true);
    }

    public PDAcroFormField getAcroFormField() {
        return (PDAcroFormField)PDAcroFormField.META.createFromCos(this.cosGetDict());
    }

    public COSName getAltAppearanceState() {
        PDAFButtonField field;
        COSArray opts;
        COSName newState = null;
        COSName oldState = this.getAppearanceState();
        Set states = this.getAppearanceStates();
        states.add(COSName.create("Off"));
        for (COSName state : states) {
            if (state.equals(oldState)) continue;
            newState = state;
            break;
        }
        if (this.getAcroFormField().isTypeBtn() && (opts = (field = (PDAFButtonField)this.getAcroFormField().getLogicalRoot()).cosGetOptions()) != null && !CN_State_Off.equals(newState)) {
            COSString optionValue = opts.get(Integer.parseInt(newState.stringValue())).asString();
            newState = COSName.create(optionValue.stringValue());
        }
        return newState;
    }

    public PDAppearanceCharacteristics getAppearanceCharacteristics() {
        return (PDAppearanceCharacteristics)PDAppearanceCharacteristics.META.createFromCos(this.cosGetField(DK_MK));
    }

    public COSName getHighlightingMode() {
        COSName mode = this.cosGetField(DK_H).asName();
        if (mode != null) {
            return mode;
        }
        return CN_H_I;
    }

    @Override
    public String getSubtypeLabel() {
        return "Widget";
    }

    public boolean isOff() {
        COSName state = this.getAppearanceState();
        return state == null || state.equals(CN_State_Off);
    }

    @Override
    public boolean isWidgetAnnotation() {
        return true;
    }

    public void setAppearanceCharacteristics(PDAppearanceCharacteristics newAppearanceCharacteristics) {
        this.setFieldObject(DK_MK, newAppearanceCharacteristics);
    }

    public void setHighlightingMode(COSName newHighlightingMode) {
        if (newHighlightingMode == null || CN_H_I.equals(newHighlightingMode)) {
            this.cosRemoveField(DK_H);
        } else {
            this.cosSetField(DK_H, newHighlightingMode);
        }
    }

    public void transform(CDSRectangle rect, CDSMatrix matrix) {
        int rotation = 0;
        PDAppearanceCharacteristics ac = this.getAppearanceCharacteristics();
        if (ac != null) {
            rotation = ac.getRotation();
        }
        PDAnnotationTools.transform(rect, matrix, rotation);
    }

    public static class MetaClass
    extends PDAnnotation.MetaClass {
        protected MetaClass(Class instanceClass) {
            super(instanceClass);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject object) {
            return new PDWidgetAnnotation(object);
        }
    }
}

