/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cds.CDSDate;
import de.intarsys.pdf.cos.COSCatalog;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInfoDict;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSObjectWalkerDeep;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.crypt.AccessPermissionsFull;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.IAccessPermissions;
import de.intarsys.pdf.crypt.IAccessPermissionsSupport;
import de.intarsys.pdf.crypt.ISecurityHandler;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.crypt.SystemSecurityHandler;
import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.EnumWriteMode;
import de.intarsys.pdf.st.PACKAGE;
import de.intarsys.pdf.st.STDocType;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.XRefFallbackParser;
import de.intarsys.pdf.st.XRefStreamParser;
import de.intarsys.pdf.st.XRefTrailerParser;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.event.INotificationSupport;
import de.intarsys.tools.exception.ExceptionTools;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.TransientLocator;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.randomaccess.BufferedRandomAccess;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.stream.StreamTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class STDocument
implements INotificationSupport,
IAttributeSupport,
ILocatorSupport {
    public static final String ATTR_LOCATOR = "locator";
    public static final String ATTR_XREF_SECTION = "xRefSection";
    public static final String ATTR_SYSTEM_SECURITY_HANDLER = "systemSecurityHandler";
    private static int COUNTER = 0;
    public static final STDocType DOCTYPE_FDF = new STDocType("FDF", "1.2");
    public static final STDocType DOCTYPE_PDF = new STDocType("PDF", "1.4");
    private static Logger Log = PACKAGE.Log;
    private static final MessageBundle Msg = PACKAGE.Messages;
    public static final String OPTION_WRITEMODEHINT = "writeModeHint";
    private EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private Object accessLock = new Object();
    private final AttributeMap attributes = new AttributeMap();
    private final Set<COSIndirectObject> changes = new HashSet<COSIndirectObject>();
    private boolean closed = false;
    private boolean dirty = false;
    private COSDocument doc;
    private STDocType docType;
    private COSIndirectObject[] objects = new COSIndirectObject[100];
    private ILocator locator;
    private COSObjectKey nextKey;
    private COSDocumentParser parser;
    private IRandomAccess randomAccess;
    private ISystemSecurityHandler readSecurityHandler;
    private EnumWriteMode writeModeHint = (EnumWriteMode)EnumWriteMode.META.getDefault();
    private ISystemSecurityHandler writeSecurityHandler;
    private STXRefSection xRefSection;
    private boolean autoUpdate = true;

    public static STDocument createFromLocator(ILocator locator) throws IOException, COSLoadException {
        return STDocument.createFromLocator(locator, null);
    }

    public static STDocument createFromLocator(ILocator locator, Map options) throws IOException, COSLoadException {
        if (!locator.exists()) {
            throw new FileNotFoundException("'" + locator.getFullName() + "' not found");
        }
        STDocument result = new STDocument(locator);
        if (options != null) {
            for (Map.Entry entry : options.entrySet()) {
                result.setAttribute(entry.getKey(), entry.getValue());
            }
        }
        result.initializeFromLocator();
        return result;
    }

    protected static String createName(String typeName) {
        return Msg.getString("STDocument.documentName.new", new Object[]{typeName, new Integer(++COUNTER)});
    }

    public static STDocument createNew() {
        return STDocument.createNew(DOCTYPE_PDF);
    }

    public static STDocument createNew(STDocType docType) {
        STDocument doc = new STDocument();
        doc.initializeFromScratch(docType);
        return doc;
    }

    protected STDocument() {
    }

    protected STDocument(ILocator locator) {
        this.setLocator(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangedReference(COSIndirectObject object) {
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            this.setDirty(true);
            this.changes.add(object);
        }
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObjectReference(COSIndirectObject newRef) {
        COSIndirectObject[] cOSIndirectObjectArray = this.objects;
        synchronized (this.objects) {
            int index = newRef.getObjectNumber();
            this.ensureLength(index);
            this.objects[index] = newRef;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkConsistency() throws COSLoadError {
        if (this.getDocType() == null) {
            throw new COSLoadError("unknown document type");
        }
        if (this.getDocType().isPDF()) {
            if (this.getXRefSection() == null) {
                throw new COSLoadError("x ref section missing");
            }
            if (this.getXRefSection().cosGetDict() == null) {
                throw new COSLoadError("trailer missing");
            }
            COSDictionary dict = this.getTrailer().getRoot().cosGetDict();
            if (dict == null || !COSCatalog.CN_Type_Catalog.equals(dict.get(PDObject.DK_Type))) {
                throw new COSLoadError("catalog invalid");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            if (this.getRandomAccess() != null) {
                this.getRandomAccess().close();
                this.setClosed(true);
                this.setRandomAccess(null);
            }
        }
    }

    public STDocument copyDeep() {
        STDocument result = STDocument.createNew();
        COSDictionary newTrailer = (COSDictionary)this.cosGetTrailer().copyDeep();
        newTrailer.remove(COSTrailer.DK_Prev);
        newTrailer.remove(COSTrailer.DK_Size);
        newTrailer.remove(STXRefSection.DK_XRefStm);
        ((STTrailerXRefSection)result.getXRefSection()).cosSetDict(newTrailer);
        result.readSecurityHandler = this.readSecurityHandler;
        result.writeSecurityHandler = this.writeSecurityHandler;
        String name = Msg.getString("STDocument.documentName.copyOf", new Object[]{this.getName()});
        result.locator = new TransientLocator(name, this.getDocType().getTypeName());
        return result;
    }

    public COSDictionary cosGetTrailer() {
        return this.getXRefSection().cosGetDict();
    }

    public STXRefSection createNewXRefSection() {
        if (this.getXRefSection().getOffset() != -1L) {
            return this.getXRefSection().createSuccessor();
        }
        return this.getXRefSection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COSObjectKey createObjectKey() {
        COSObjectKey cOSObjectKey = this.nextKey;
        synchronized (cOSObjectKey) {
            this.nextKey = this.nextKey.createNextKey();
            return this.nextKey;
        }
    }

    protected IRandomAccess createRandomAccess(ILocator pLocator) throws IOException {
        if (pLocator == null) {
            return null;
        }
        IRandomAccess baseAccess = pLocator.getRandomAccess();
        if (baseAccess.isReadOnly()) {
            pLocator.setReadOnly();
        }
        BufferedRandomAccess bufferedAccess = new BufferedRandomAccess(baseAccess, 4096);
        return bufferedAccess;
    }

    protected void ensureLength(int index) {
        if (index >= this.objects.length) {
            int newLength = this.objects.length + 100;
            if (index >= newLength) {
                newLength = index + 100;
            }
            COSIndirectObject[] tempObjects = new COSIndirectObject[newLength];
            System.arraycopy(this.objects, 0, tempObjects, 0, this.objects.length);
            this.objects = tempObjects;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void garbageCollect() {
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            this.changes.clear();
        }
        COSObjectWalkerDeep walker = new COSObjectWalkerDeep(){

            @Override
            public Object visitFromIndirectObject(COSIndirectObject io) throws COSVisitorException {
                if (this.getVisited().contains(io)) {
                    return null;
                }
                super.visitFromIndirectObject(io);
                COSObject tempObject = io.dereference();
                io.setDirty(true);
                return null;
            }
        };
        try {
            this.cosGetTrailer().accept(walker);
        }
        catch (COSVisitorException cOSVisitorException) {
            // empty catch block
        }
        STTrailerXRefSection emptyXRefSection = new STTrailerXRefSection(this);
        COSDictionary emptyTrailer = emptyXRefSection.cosGetDict();
        emptyTrailer.addAll(this.cosGetTrailer());
        emptyTrailer.remove(COSTrailer.DK_Prev);
        emptyTrailer.remove(COSTrailer.DK_Size);
        emptyTrailer.remove(STXRefSection.DK_XRefStm);
        this.setXRefSection(emptyXRefSection);
        Object object = this.objects;
        synchronized (this.objects) {
            Arrays.fill(this.objects, null);
            // ** MonitorExit[var4_5 /* !! */ ] (shouldn't be in output)
            object = this.nextKey;
            synchronized (object) {
                this.nextKey = new COSObjectKey(0, 0);
            }
            for (COSIndirectObject o : walker.getVisited()) {
                o.setKey(null);
                this.addObjectReference(o);
            }
            return;
        }
    }

    public Object getAccessLock() {
        return this.accessLock;
    }

    public IAccessPermissions getAccessPermissions() {
        ISecurityHandler basicSecurityHandler;
        if (this.getReadSecurityHandler() != null && (basicSecurityHandler = this.getReadSecurityHandler().getSecurityHandler()) instanceof IAccessPermissionsSupport) {
            return ((IAccessPermissionsSupport)((Object)basicSecurityHandler)).getAccessPermissions();
        }
        return AccessPermissionsFull.get();
    }

    public final synchronized Object getAttribute(Object key) {
        return this.attributes.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<COSIndirectObject> getChanges() {
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            return this.changes;
        }
    }

    public COSDocument getDoc() {
        return this.doc;
    }

    public STDocType getDocType() {
        return this.docType;
    }

    public int getIncrementalCount() {
        return this.getXRefSection().getIncrementalCount();
    }

    public COSDictionary getLinearizedDict() {
        int objectNumber = 0;
        Iterator it = this.getXRefSection().entryIterator();
        while (it.hasNext()) {
            STXRefEntry entry = (STXRefEntry)it.next();
            if (entry.getObjectNumber() == 0) continue;
            objectNumber = entry.getObjectNumber();
            break;
        }
        try {
            COSObject version;
            COSObject result = this.load(objectNumber);
            if (result != null && result.asDictionary() != null && !(version = result.asDictionary().get(COSName.constant("Linearized"))).isNull()) {
                return result.asDictionary();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getName() {
        return this.getLocator().getLocalName();
    }

    public COSIndirectObject getObjectReference(COSObjectKey key) {
        return this.getObjectReference(key.getObjectNumber(), key.getGenerationNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public COSIndirectObject getObjectReference(int objectNumber, int generationNumber) {
        COSIndirectObject[] cOSIndirectObjectArray = this.objects;
        synchronized (this.objects) {
            COSIndirectObject result = null;
            if (objectNumber < this.objects.length) {
                result = this.objects[objectNumber];
            }
            if (result == null) {
                result = COSIndirectObject.create(this, objectNumber, generationNumber);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return result;
        }
    }

    public COSDocumentParser getParser() {
        return this.parser;
    }

    public IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    public ISystemSecurityHandler getReadSecurityHandler() {
        return this.readSecurityHandler;
    }

    public COSTrailer getTrailer() {
        return (COSTrailer)COSTrailer.META.createFromCos(this.cosGetTrailer());
    }

    public String getVersion() {
        return this.getDocType().toString();
    }

    public EnumWriteMode getWriteModeHint() {
        return this.writeModeHint;
    }

    public ISystemSecurityHandler getWriteSecurityHandler() {
        return this.writeSecurityHandler;
    }

    public STXRefSection getXRefSection() {
        return this.xRefSection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementalGarbageCollect() {
        HashSet<COSIndirectObject> unknown;
        Set<COSIndirectObject> set = this.changes;
        synchronized (set) {
            unknown = new HashSet<COSIndirectObject>(this.changes);
        }
        COSObjectWalkerDeep stripper = new COSObjectWalkerDeep(true, false){

            @Override
            public Object visitFromIndirectObject(COSIndirectObject io) throws COSVisitorException {
                unknown.remove(io);
                return super.visitFromIndirectObject(io);
            }
        };
        try {
            this.cosGetTrailer().accept(stripper);
        }
        catch (COSVisitorException cOSVisitorException) {
            // empty catch block
        }
        Set<COSIndirectObject> set2 = this.changes;
        synchronized (set2) {
            this.changes.removeAll(unknown);
        }
    }

    protected void initEncryption() throws IOException {
        this.readSecurityHandler = null;
        this.writeSecurityHandler = null;
        try {
            this.readSecurityHandler = SystemSecurityHandler.createFromSt(this);
            if (this.readSecurityHandler != null) {
                this.readSecurityHandler.authenticate();
            }
        }
        catch (COSSecurityException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        this.writeSecurityHandler = this.readSecurityHandler;
    }

    protected void initializeFromLocator() throws IOException, COSLoadException {
        this.parser = new COSDocumentParser(this);
        this.streamLoad();
    }

    protected void initializeFromScratch(STDocType pDocType) {
        this.setDocType(pDocType);
        String name = STDocument.createName(this.getDocType().getTypeName());
        this.locator = new TransientLocator(name, pDocType.getTypeName());
        this.parser = new COSDocumentParser(this);
        this.setXRefSection(new STTrailerXRefSection(this));
        this.nextKey = new COSObjectKey(0, 0);
        this.cosGetTrailer().put(COSTrailer.DK_Root, COSCatalog.META.createNew().cosGetDict());
        this.setDirty(true);
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isEncrypted() {
        return this.getReadSecurityHandler() != null;
    }

    public boolean isLinearized() {
        return this.getLinearizedDict() != null;
    }

    public boolean isNew() {
        return this.getXRefSection().getOffset() == -1L && this.getXRefSection().getPrevious() == null;
    }

    public boolean isReadOnly() {
        return this.getRandomAccess() == null || this.getRandomAccess().isReadOnly();
    }

    public boolean isStreamed() {
        if (this.getXRefSection() != null) {
            return this.getXRefSection().isStreamed();
        }
        return false;
    }

    public COSObject load(COSIndirectObject ref) throws IOException, COSLoadException {
        int objectNumber = ref.getKey().getObjectNumber();
        return this.load(objectNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected COSObject load(int objectNumber) throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.isClosed()) {
                return COSNull.NULL;
            }
            return this.getXRefSection().load(objectNumber, this.getReadSecurityHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAll() throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.isClosed()) {
                return;
            }
            int i = 0;
            while (i < this.getXRefSection().getSize()) {
                this.getXRefSection().load(i, this.getReadSecurityHandler());
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadedSize() {
        int result = 0;
        COSIndirectObject[] cOSIndirectObjectArray = this.objects;
        synchronized (this.objects) {
            COSIndirectObject[] cOSIndirectObjectArray2 = this.objects;
            int n = this.objects.length;
            int n2 = 0;
            while (n2 < n) {
                COSIndirectObject io = cOSIndirectObjectArray2[n2];
                if (!io.isSwapped()) {
                    ++result;
                }
                ++n2;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public Iterator objects() {
        return new Iterator(){
            int i = 1;
            int size;
            {
                this.size = STDocument.this.getXRefSection().getSize();
            }

            @Override
            public boolean hasNext() {
                return this.i < this.size;
            }

            public Object next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("");
                }
                return STDocument.this.getObjectReference(this.i++, 0);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove not supported");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws IOException {
        Object object = this.getAccessLock();
        synchronized (object) {
            if (this.randomAccess != null && !this.isClosed()) {
                throw new IllegalStateException("can't open an open document");
            }
            this.setRandomAccess(this.createRandomAccess(this.getLocator()));
        }
    }

    public final synchronized Object removeAttribute(Object key) {
        Object oldValue = this.attributes.remove(key);
        this.triggerChanged(key, oldValue, null);
        return oldValue;
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reparseFromLocator() throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        synchronized (object) {
            int offset = this.getParser().searchLastStartXRef(this.getRandomAccess());
            AbstractXRefParser xRefParser = this.getParser().isTokenXRefAt(this.getRandomAccess(), offset) ? new XRefTrailerParser(this, this.getParser()) : new XRefStreamParser(this, this.getParser());
            this.getRandomAccess().seek((long)offset);
            xRefParser.parse(this.getRandomAccess());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void replaceLocator(ILocator newLocator) throws IOException {
        ILocator oldLocator = this.getLocator();
        if (newLocator.equals(oldLocator)) {
            return;
        }
        Object object = this.getAccessLock();
        synchronized (object) {
            IRandomAccess oldRandomAccess = this.getRandomAccess();
            try {
                this.setLocator(newLocator);
                this.setRandomAccess(null);
                this.open();
                IRandomAccess newRandomAccess = this.getRandomAccess();
                if (newRandomAccess.isReadOnly()) {
                    throw new FileNotFoundException();
                }
                if (oldRandomAccess != null) {
                    newRandomAccess.setLength(oldRandomAccess.getLength());
                    InputStream is = oldRandomAccess.asInputStream();
                    OutputStream os = newRandomAccess.asOutputStream();
                    oldRandomAccess.seek(0L);
                    StreamTools.copyStream((InputStream)is, (boolean)false, (OutputStream)os, (boolean)false);
                } else {
                    newRandomAccess.setLength(0L);
                }
                StreamTools.close((IRandomAccess)oldRandomAccess);
            }
            catch (Exception e) {
                StreamTools.close((IRandomAccess)this.getRandomAccess());
                this.setLocator(oldLocator);
                this.setRandomAccess(oldRandomAccess);
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw ExceptionTools.createIOException((String)("unexpected exception saving '" + newLocator.getFullName() + "'"), (Throwable)e);
            }
        }
        this.triggerChanged(ATTR_LOCATOR, oldLocator, newLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void restore(ILocator newLocator) throws IOException, COSLoadException {
        Object object = this.getAccessLock();
        // MONITORENTER : object
        ILocator oldLocator = this.getLocator();
        if (newLocator.equals(oldLocator)) {
            // MONITOREXIT : object
            return;
        }
        IRandomAccess oldRandomAccess = this.getRandomAccess();
        StreamTools.close((IRandomAccess)oldRandomAccess);
        this.setRandomAccess(null);
        this.setLocator(newLocator);
        COSIndirectObject[] cOSIndirectObjectArray = this.changes;
        // MONITORENTER : this.changes
        this.changes.clear();
        // MONITOREXIT : cOSIndirectObjectArray
        cOSIndirectObjectArray = this.objects;
        // MONITORENTER : this.objects
        Arrays.fill(this.objects, null);
        // MONITOREXIT : cOSIndirectObjectArray
        this.closed = false;
        this.dirty = false;
        this.streamLoad();
        // MONITOREXIT : object
        this.getDoc().triggerChangedAll();
    }

    public void save() throws IOException {
        this.save(this.getLocator(), null);
    }

    public void save(ILocator pLocator) throws IOException {
        this.save(pLocator, null);
    }

    public void save(ILocator pLocator, Map options) throws IOException {
        IRandomAccess tempRandomAccess;
        Object tempHint;
        if (options == null) {
            options = new HashMap();
        }
        if (pLocator != null && pLocator != this.getLocator()) {
            this.replaceLocator(pLocator);
        }
        boolean incremental = true;
        EnumWriteMode writeMode = this.doc.getWriteModeHint();
        this.doc.setWriteModeHint(EnumWriteMode.UNDEFINED);
        if (writeMode.isUndefined() && (tempHint = options.get(OPTION_WRITEMODEHINT)) instanceof EnumWriteMode) {
            writeMode = (EnumWriteMode)((Object)tempHint);
        }
        if (writeMode.isFull()) {
            incremental = false;
        }
        if ((tempRandomAccess = this.getRandomAccess()) == null) {
            throw new IOException("nowhere to write to");
        }
        if (tempRandomAccess.isReadOnly()) {
            throw new FileNotFoundException("destination is read only");
        }
        COSWriter writer = new COSWriter(tempRandomAccess, this.getWriteSecurityHandler());
        writer.setAutoUpdate(this.isAutoUpdate());
        writer.setIncremental(incremental);
        writer.writeDocument(this);
        this.readSecurityHandler = this.writeSecurityHandler;
    }

    public final synchronized Object setAttribute(Object key, Object value) {
        Object oldValue = this.attributes.put(key, value);
        this.triggerChanged(key, oldValue, value);
        return oldValue;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    protected void setClosed(boolean closed) {
        this.closed = closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (!dirty) {
            Set<COSIndirectObject> set = this.changes;
            synchronized (set) {
                this.changes.clear();
            }
        }
    }

    public void setDoc(COSDocument doc) {
        this.doc = doc;
        this.getXRefSection().setCOSDoc(this.getDoc());
    }

    protected void setDocType(STDocType docType) {
        this.docType = docType;
    }

    protected void setLocator(ILocator pLocator) {
        this.locator = pLocator;
    }

    public void setName(String name) {
        if (this.getLocator() instanceof TransientLocator) {
            ((TransientLocator)this.getLocator()).setLocalName(name);
        }
    }

    protected void setRandomAccess(IRandomAccess randomAccess) {
        this.randomAccess = randomAccess;
    }

    public void setSystemSecurityHandler(ISystemSecurityHandler handler) throws COSSecurityException {
        ISystemSecurityHandler oldValue = this.writeSecurityHandler;
        if (this.writeSecurityHandler != null) {
            this.writeSecurityHandler.detach(this);
        }
        this.writeSecurityHandler = handler;
        if (this.writeSecurityHandler != null) {
            this.writeSecurityHandler.attach(this);
        }
        this.triggerChanged(ATTR_SYSTEM_SECURITY_HANDLER, oldValue, this.writeSecurityHandler);
    }

    public void setWriteModeHint(EnumWriteMode writeMode) {
        if (writeMode == null) {
            throw new IllegalArgumentException("write mode can't be null");
        }
        this.writeModeHint = writeMode;
    }

    public void setXRefSection(STXRefSection pXRefSection) {
        STXRefSection oldValue = this.xRefSection;
        this.xRefSection = pXRefSection;
        if (this.getDoc() != null) {
            this.xRefSection.setCOSDoc(this.getDoc());
        }
        this.triggerChanged(ATTR_XREF_SECTION, oldValue, this.xRefSection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void streamLoad() throws IOException, COSLoadException {
        try {
            STXRefSection initialXRefSection;
            this.open();
            this.setDocType(this.getParser().parseHeader(this.getRandomAccess()));
            try {
                int offset = this.getParser().searchLastStartXRef(this.getRandomAccess());
                AbstractXRefParser xRefParser = this.getParser().isTokenXRefAt(this.getRandomAccess(), offset) ? new XRefTrailerParser(this, this.getParser()) : new XRefStreamParser(this, this.getParser());
                this.getRandomAccess().seek((long)offset);
                initialXRefSection = xRefParser.parse(this.getRandomAccess());
                this.setXRefSection(initialXRefSection);
                this.checkConsistency();
            }
            catch (Exception ex) {
                Log.log(Level.FINEST, "error parsing " + this.getLocator().getFullName(), ex);
                COSIndirectObject[] cOSIndirectObjectArray = this.objects;
                // MONITORENTER : this.objects
                Arrays.fill(this.objects, null);
                // MONITOREXIT : cOSIndirectObjectArray
                initialXRefSection = new XRefFallbackParser(this, this.getParser()).parse(this.getRandomAccess());
                this.setXRefSection(initialXRefSection);
                this.checkConsistency();
            }
            int size = initialXRefSection.getSize();
            this.nextKey = new COSObjectKey(size - 1, 0);
            this.ensureLength(size);
            this.initEncryption();
            return;
        }
        catch (IOException e) {
            try {
                this.close();
                throw e;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        catch (COSLoadException e) {
            try {
                this.close();
                throw e;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
    }

    protected void triggerChanged(Object attribute, Object oldValue, Object newValue) {
        AttributeChangedEvent event = new AttributeChangedEvent((Object)this, attribute, oldValue, newValue);
        this.triggerEvent((Event)event);
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    public void updateModificationDate() {
        COSDictionary infoDict = this.cosGetTrailer().get(COSTrailer.DK_Info).asDictionary();
        if (infoDict == null) {
            return;
        }
        infoDict.put(COSInfoDict.DK_ModDate, new CDSDate().cosGetObject());
    }
}

