/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTrailer;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.XRefStreamWriter;
import de.intarsys.pdf.writer.COSWriter;

public class STStreamXRefSection
extends STXRefSection {
    public static final COSName DK_Type = COSName.constant("Type");
    public static final COSName CN_Type_XRef = COSName.constant("XRef");
    public static final COSName DK_Index = COSName.constant("Index");
    public static final COSName DK_W = COSName.constant("W");
    private COSStream stream;

    public STStreamXRefSection(STDocument doc) {
        super(doc);
        this.stream = COSStream.create(COSDictionary.create());
        this.cosGetDict().put(DK_Type, CN_Type_XRef);
    }

    public STStreamXRefSection(STDocument doc, long offset, COSStream stream) {
        super(doc, offset);
        this.stream = stream;
    }

    @Override
    public COSDictionary cosGetDict() {
        return this.stream.getDict();
    }

    @Override
    public COSObject cosGetObject() {
        return this.stream;
    }

    public COSStream cosGetStream() {
        return this.stream;
    }

    protected void cosSetStream(COSStream pStream) {
        this.stream = pStream;
    }

    @Override
    public STXRefSection createSuccessor() {
        STStreamXRefSection newXRefSection = new STStreamXRefSection(this.getDoc());
        newXRefSection.cosGetDict().put(COSTrailer.DK_ID, this.cosGetDict().get(COSTrailer.DK_ID).copyShallow());
        newXRefSection.cosGetDict().put(COSTrailer.DK_Root, this.cosGetDict().get(COSTrailer.DK_Root));
        newXRefSection.cosGetDict().put(COSTrailer.DK_Info, this.cosGetDict().get(COSTrailer.DK_Info));
        COSObject encrypt = this.cosGetDict().get(COSTrailer.DK_Encrypt);
        if (!encrypt.isIndirect()) {
            encrypt = encrypt.copyShallow();
        }
        newXRefSection.cosGetDict().put(COSTrailer.DK_Encrypt, encrypt);
        newXRefSection.setPrevious(this);
        return newXRefSection;
    }

    protected COSArray getIndex() {
        COSArray index = this.cosGetDict().get(DK_Index).asArray();
        if (index == null) {
            index = COSArray.create(2);
            index.add(COSInteger.create(0));
            index.add(COSInteger.create(this.getSize()));
        }
        return index;
    }

    protected COSArray getW() {
        return this.cosGetDict().get(DK_W).asArray();
    }

    @Override
    public AbstractXRefWriter getWriter(COSWriter cosWriter) {
        return new XRefStreamWriter(cosWriter);
    }

    @Override
    protected boolean isStreamed() {
        return true;
    }

    public void setIndex(COSArray index) {
        this.cosGetDict().put(DK_Index, index);
    }

    protected void setW(COSArray wArray) {
        this.cosGetDict().put(DK_W, wArray);
    }
}

