/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class STTools {
    public static List<STXRefEntry> getOccupiedEntries(STXRefSection section) throws IOException {
        EntryCollector collector = new EntryCollector();
        STTools.visitEntries(section, collector);
        return collector.getEntries();
    }

    public static void visitEntries(STXRefSection section, IXRefEntryVisitor visitor) throws IOException {
        Iterator i = section.subsectionIterator();
        while (i.hasNext()) {
            STXRefSubsection subsection = (STXRefSubsection)i.next();
            Iterator ie = subsection.getEntries().iterator();
            while (ie.hasNext()) {
                try {
                    ((STXRefEntry)ie.next()).accept(visitor);
                }
                catch (XRefEntryVisitorException e) {
                    throw (IOException)e.getCause();
                }
            }
        }
    }

    public static class EntryCollector
    implements IXRefEntryVisitor {
        private List<STXRefEntry> entries = new ArrayList<STXRefEntry>();

        public List<STXRefEntry> getEntries() {
            return this.entries;
        }

        @Override
        public void visitFromCompressed(STXRefEntryCompressed entry) throws XRefEntryVisitorException {
        }

        @Override
        public void visitFromFree(STXRefEntryFree entry) throws XRefEntryVisitorException {
        }

        @Override
        public void visitFromOccupied(STXRefEntryOccupied entry) throws XRefEntryVisitorException {
            if (entry.getObjectNumber() == 0) {
                return;
            }
            this.entries.add(entry);
        }
    }
}

