/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.XRefEntryVisitorException;

public class STXRefEntryFree
extends STXRefEntry {
    private STXRefEntryFree next = this;
    private STXRefEntryFree prev = this;
    private int nextFreeObject;

    public STXRefEntryFree(int objectNumber, int generationNumber, int nextFreeObject) {
        super(objectNumber, generationNumber);
        this.nextFreeObject = nextFreeObject;
    }

    @Override
    public void accept(IXRefEntryVisitor visitor) throws XRefEntryVisitorException {
        visitor.visitFromFree(this);
    }

    @Override
    public STXRefEntry copy() {
        return new STXRefEntryFree(this.getObjectNumber(), this.getGenerationNumber(), this.getNextFreeObjectNumber());
    }

    public void enqueue(STXRefEntryFree entry) {
        int prevIndex = this.getPrev().getObjectNumber();
        if (prevIndex == 0 || prevIndex < entry.getObjectNumber()) {
            entry.setNext(this);
            entry.setPrev(this.getPrev());
            this.getPrev().setNext(entry);
            this.setPrev(entry);
        } else {
            this.getPrev().enqueue(entry);
        }
    }

    @Override
    public STXRefEntryOccupied fill(int pos) {
        this.unlink();
        return null;
    }

    @Override
    public long getColumn1() {
        return this.getNextFreeObjectNumber();
    }

    @Override
    public int getColumn2() {
        return this.getGenerationNumber();
    }

    protected STXRefEntryFree getNext() {
        return this.next;
    }

    public int getNextFreeObjectNumber() {
        return this.nextFreeObject;
    }

    protected STXRefEntryFree getPrev() {
        return this.prev;
    }

    @Override
    public boolean isFree() {
        return true;
    }

    @Override
    public COSObject load(STDocument doc, ISystemSecurityHandler securityHandler) {
        return null;
    }

    private void setNext(STXRefEntryFree free) {
        this.next = free;
    }

    private void setPrev(STXRefEntryFree free) {
        this.prev = free;
    }

    @Override
    protected void unlink() {
        this.getPrev().setNext(this.getNext());
        this.getNext().setPrev(this.getPrev());
        this.setPrev(this);
        this.setNext(this);
    }
}

