/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.parser.COSDocumentParser;
import de.intarsys.pdf.parser.COSLoadError;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.parser.COSLoadWarning;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefParser;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STStreamXRefSection;
import de.intarsys.pdf.st.STTrailerXRefSection;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.XRefStreamParser;
import de.intarsys.tools.randomaccess.IRandomAccess;
import java.io.IOException;
import java.util.Arrays;

public class XRefTrailerParser
extends AbstractXRefParser {
    public XRefTrailerParser(STDocument doc, COSDocumentParser parser) {
        super(doc, parser);
    }

    protected void loadPrevious(IRandomAccess randomAccess, STXRefSection xRefSection) throws IOException, COSLoadException {
        int offset;
        int xrefStreamOffset = xRefSection.getXRefStmOffset();
        if (xrefStreamOffset != -1) {
            XRefStreamParser parser = new XRefStreamParser(this.getDoc(), this.getParser());
            randomAccess.seek((long)xrefStreamOffset);
            try {
                STStreamXRefSection xrefStream = (STStreamXRefSection)((AbstractXRefParser)parser).parse(randomAccess);
                ((STTrailerXRefSection)xRefSection).setXRefStream(xrefStream);
            }
            catch (Exception xrefStream) {
                // empty catch block
            }
        }
        if ((offset = xRefSection.getPreviousOffset()) != -1) {
            XRefTrailerParser parser = new XRefTrailerParser(this.getDoc(), this.getParser());
            randomAccess.seek((long)offset);
            STXRefSection trailer = ((AbstractXRefParser)parser).parse(randomAccess);
            xRefSection.setPrevious(trailer);
        }
    }

    @Override
    public STXRefSection parse(IRandomAccess randomAcces) throws IOException, COSLoadException {
        STXRefSection xRefSection = this.parseXRef(randomAcces);
        this.loadPrevious(randomAcces, xRefSection);
        return xRefSection;
    }

    private STXRefEntry parseEntry(int objectNumber, byte[] entryBytes) {
        boolean inuse;
        int offset = 0;
        int i = 0;
        while (i < 10) {
            offset = offset * 10 + (entryBytes[i] - 48);
            ++i;
        }
        int generation = 0;
        int i2 = 11;
        while (i2 < 16) {
            generation = generation * 10 + (entryBytes[i2] - 48);
            ++i2;
        }
        boolean bl = inuse = entryBytes[17] == 110;
        if (inuse) {
            return new STXRefEntryOccupied(objectNumber, generation, offset);
        }
        return new STXRefEntryFree(objectNumber, generation, offset);
    }

    protected STXRefSection parseXRef(IRandomAccess randomAccess) throws IOException, COSLoadException {
        STTrailerXRefSection xRefSection = new STTrailerXRefSection(this.getDoc(), randomAccess.getOffset());
        this.parseXRefSection(randomAccess, xRefSection);
        xRefSection.cosSetDict(this.getDoc().getParser().parseTrailer(randomAccess));
        return xRefSection;
    }

    protected void parseXRefSection(IRandomAccess randomAccess, STTrailerXRefSection xRef) throws IOException, COSLoadException {
        this.getDoc().getParser().readSpaces(randomAccess);
        byte[] token = new byte[4];
        randomAccess.read(token);
        if (Arrays.equals(token, PDFParser.TOKEN_xref)) {
            token = new byte[PDFParser.TOKEN_trailer.length];
            long oldpos = -1L;
            long pos = randomAccess.getOffset();
            while (oldpos != pos) {
                oldpos = pos;
                this.parseXRefSubsection(randomAccess, xRef);
                this.getDoc().getParser().readSpaces(randomAccess);
                int c = randomAccess.read();
                randomAccess.seekBy(-1L);
                if (c != -1 && PDFParser.isDigit(c)) {
                    pos = randomAccess.getOffset();
                    continue;
                }
                break;
            }
        } else {
            COSLoadError e = new COSLoadError("no 'xref' key found at character index " + randomAccess.getOffset());
            this.handleError(e);
        }
    }

    protected void parseXRefSubsection(IRandomAccess randomAccess, STTrailerXRefSection xRef) throws IOException, COSLoadException {
        COSLoadWarning pwarn;
        int beginningObject = this.getDoc().getParser().readInteger(randomAccess, false);
        int c = randomAccess.read();
        if (c == -1) {
            return;
        }
        if (c != 32) {
            pwarn = new COSLoadWarning("614a");
            pwarn.setHint(new Long(randomAccess.getOffset()));
            this.getParser().handleWarning(pwarn);
        }
        if ((c = randomAccess.read()) == -1) {
            return;
        }
        randomAccess.seekBy(-1L);
        if (!PDFParser.isDigit(c)) {
            pwarn = new COSLoadWarning("614a");
            pwarn.setHint(new Long(randomAccess.getOffset()));
            this.getParser().handleWarning(pwarn);
        }
        int numEntries = this.getDoc().getParser().readInteger(randomAccess, true);
        this.getDoc().getParser().readSpaces(randomAccess);
        byte[] buffer = new byte[20];
        int i = 0;
        while (i < numEntries) {
            c = randomAccess.read(buffer);
            if (c == -1) {
                return;
            }
            STXRefEntry entry = this.parseEntry(beginningObject + i, buffer);
            xRef.addEntry(entry);
            ++i;
        }
    }
}

