/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.tools.kernel;

import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.LocatorFactory;
import de.intarsys.tools.locator.URLLocator;
import de.intarsys.tools.system.SystemTools;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class PDFFileTools {
    protected static ILocator getRoot(ILocator locator) {
        ILocator root = locator;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public static ILocator resolveLocator(String osIndependentPath, ILocator baseLocator) throws IOException {
        if (osIndependentPath.contains("://")) {
            return new URLLocator(new URL(osIndependentPath));
        }
        String result = PDFFileTools.toOSPath(osIndependentPath);
        if (baseLocator == null) {
            return LocatorFactory.get().createLocator(result);
        }
        if (result.startsWith("\\") && !result.startsWith("\\\\")) {
            return PDFFileTools.getRoot(baseLocator).getChild(result);
        }
        File resultFile = new File(result);
        if (resultFile.isAbsolute()) {
            return LocatorFactory.get().createLocator(result);
        }
        return baseLocator.getChild(result);
    }

    public static String toOSIndependentPath(String osPath) {
        if (SystemTools.isWindows()) {
            return PDFFileTools.windowsToOSIndependentPath(osPath);
        }
        return osPath;
    }

    public static String toOSPath(String osIndependentPath) {
        if (SystemTools.isWindows()) {
            return PDFFileTools.toWindowsPath(osIndependentPath);
        }
        return osIndependentPath;
    }

    protected static String toWindowsPath(String osIndependentPath) {
        if (File.separatorChar == '/') {
            return osIndependentPath;
        }
        if (osIndependentPath.startsWith("///")) {
            return "\\\\" + osIndependentPath.substring(3).replace("/", "\\");
        }
        if (osIndependentPath.startsWith("//")) {
            return "\\" + osIndependentPath.substring(2).replace("/", "\\");
        }
        if (osIndependentPath.startsWith("/")) {
            File drive;
            String windows = osIndependentPath.substring(1).replace("/", "\\");
            int index = windows.indexOf("\\");
            if (index < 0) {
                index = windows.length();
            }
            windows = (drive = new File(String.valueOf(windows.substring(0, index)) + ":")).isDirectory() ? String.valueOf(windows.substring(0, index)) + ":" + windows.substring(index) : "\\\\" + windows;
            return windows;
        }
        return osIndependentPath.replace("/", "\\");
    }

    protected static String windowsToOSIndependentPath(String osPath) {
        String osIndependentPath = osPath.replaceAll("\\\\", "/");
        int index = osIndependentPath.indexOf(":");
        if (index >= 0 && index < osIndependentPath.indexOf("/")) {
            osIndependentPath = "/" + osIndependentPath.substring(0, index) + osIndependentPath.substring(index + 1);
        }
        return osIndependentPath;
    }
}

