/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.writer;

import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBoolean;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSFixed;
import de.intarsys.pdf.cos.COSIndirectObject;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectProxy;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.cos.ICOSProxyVisitor;
import de.intarsys.pdf.crypt.COSSecurityException;
import de.intarsys.pdf.crypt.ISystemSecurityHandler;
import de.intarsys.pdf.parser.PDFParser;
import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class COSWriter
implements ICOSObjectVisitor,
ICOSProxyVisitor {
    public static final byte[] ARRAY_CLOSE = "]".getBytes();
    public static final byte[] ARRAY_OPEN = "[".getBytes();
    public static final byte[] COMMENT = "%".getBytes();
    public static final byte[] CRLF = "\r\n".getBytes();
    public static final byte[] DICT_CLOSE = ">>".getBytes();
    public static final byte[] DICT_OPEN = "<<".getBytes();
    protected static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '9'};
    public static final byte[] ENDOBJ = "endobj".getBytes();
    public static final byte[] ENDSTREAM = "endstream".getBytes();
    public static final byte[] EOF = "%%EOF".getBytes();
    public static final byte[] EOL = StringTools.LS.getBytes();
    public static final byte[] FALSE = "false".getBytes();
    public static final byte[] GARBAGE = new byte[]{-10, -28, -4, -33};
    public static final byte[] LF = "\n".getBytes();
    public static final byte[] LITERAL_ESCAPED_BS = "\\b".getBytes();
    public static final byte[] LITERAL_ESCAPED_CR = "\\r".getBytes();
    public static final byte[] LITERAL_ESCAPED_FF = "\\f".getBytes();
    public static final byte[] LITERAL_ESCAPED_HT = "\\t".getBytes();
    public static final byte[] LITERAL_ESCAPED_LF = "\\n".getBytes();
    public static final byte[] NAME_ESCAPE = "#".getBytes();
    public static final byte[] NAME_PREFIX = "/".getBytes();
    public static final byte[] NULL = "null".getBytes();
    public static final byte[] OBJ = "obj".getBytes();
    public static final byte[] PDF_ESCAPE = "\\".getBytes();
    public static final byte[] REFERENCE = "R".getBytes();
    public static final byte[] SPACE = " ".getBytes();
    public static final byte[] STREAM = "stream".getBytes();
    public static final byte[] STRING_CLOSE = ")".getBytes();
    public static final byte[] STRING_HEX_CLOSE = ">".getBytes();
    public static final byte[] STRING_HEX_OPEN = "<".getBytes();
    public static final byte[] STRING_OPEN = "(".getBytes();
    public static final byte[] TRAILER = "trailer".getBytes();
    public static final byte[] TRUE = "true".getBytes();
    private static final NumberFormat formatFixed = NumberFormat.getIntegerInstance(Locale.US);
    private COSIndirectObject currentObject;
    private final ISystemSecurityHandler securityHandler;
    private boolean incremental = true;
    private boolean autoUpdate = true;
    private boolean onNewLine = false;
    private final List proxies = new ArrayList();
    private final IRandomAccess randomAccess;

    public static synchronized void basicWriteFixed(IRandomAccess randomAccess, float value, int precision) throws IOException {
        formatFixed.setGroupingUsed(false);
        formatFixed.setMaximumFractionDigits(precision);
        randomAccess.write(StringTools.toByteArray((String)formatFixed.format(value)));
    }

    public static void basicWriteInteger(IRandomAccess randomAccess, int value) throws IOException {
        randomAccess.write(StringTools.toByteArray((String)Integer.toString(value)));
    }

    public static void basicWriteName(IRandomAccess randomAccess, byte[] name) throws IOException {
        randomAccess.write(NAME_PREFIX);
        int i = 0;
        while (i < name.length) {
            int current = name[i] & 0xFF;
            if (current <= 32 || current >= 127 || PDFParser.isDelimiter(current) || current == 35) {
                randomAccess.write(NAME_ESCAPE);
                randomAccess.write(HexTools.ByteToHex[current]);
            } else {
                randomAccess.write(current);
            }
            ++i;
        }
    }

    public static void basicWriteStringHex(IRandomAccess randomAccess, byte[] string) throws IOException {
        randomAccess.write(STRING_HEX_OPEN);
        int i = 0;
        while (i < string.length) {
            randomAccess.write(HexTools.ByteToHex[string[i] & 0xFF]);
            ++i;
        }
        randomAccess.write(STRING_HEX_CLOSE);
    }

    public static void basicWriteStringLiteral(IRandomAccess randomAccess, byte[] string) throws IOException {
        randomAccess.write(STRING_OPEN);
        int i = 0;
        while (i < string.length) {
            byte b = string[i];
            if (b == 10) {
                randomAccess.write(LITERAL_ESCAPED_LF);
            } else if (b == 13) {
                randomAccess.write(LITERAL_ESCAPED_CR);
            } else if (b == 9) {
                randomAccess.write(LITERAL_ESCAPED_HT);
            } else if (b == 12) {
                randomAccess.write(LITERAL_ESCAPED_FF);
            } else if (b == 8) {
                randomAccess.write(LITERAL_ESCAPED_BS);
            } else if (b == 40 || b == 41 || b == 92) {
                randomAccess.write(PDF_ESCAPE);
                randomAccess.write((int)b);
            } else {
                randomAccess.write((int)b);
            }
            ++i;
        }
        randomAccess.write(STRING_CLOSE);
    }

    public static final byte[] toByteArray(COSObject object) {
        RandomAccessByteArray tempRandom = new RandomAccessByteArray(null);
        COSWriter writer = new COSWriter((IRandomAccess)tempRandom, null);
        try {
            writer.writeObject(object);
        }
        catch (IOException e) {
            return "*** not printable ***".getBytes();
        }
        return tempRandom.toByteArray();
    }

    public COSWriter(IRandomAccess randomAccess, ISystemSecurityHandler securityHandler) {
        this.securityHandler = securityHandler;
        this.randomAccess = randomAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void basicWriteDocument(STDocument doc) throws IOException {
        if (doc.isDirty() && this.isAutoUpdate()) {
            doc.updateModificationDate();
            doc.getTrailer().updateFileID();
        }
        if (doc.isNew()) {
            this.setIncremental(false);
        }
        if (doc.isClosed()) {
            return;
        }
        if (!this.isIncremental()) {
            doc.garbageCollect();
        } else {
            doc.incrementalGarbageCollect();
        }
        Object object = doc.getAccessLock();
        synchronized (object) {
            Collection<COSIndirectObject> changes;
            if (!this.isIncremental()) {
                this.getRandomAccess().setLength(0L);
                this.writeHeader(doc);
            }
            if ((changes = doc.getChanges()).size() > 0) {
                this.seekToEnd();
                STXRefSection xrefSection = doc.createNewXRefSection();
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().updateTrailer(xrefSection.cosGetDict());
                }
                for (COSIndirectObject object2 : changes) {
                    this.writeEntry(xrefSection, object2);
                    object2.setDirty(false);
                }
                this.seekToEnd();
                this.writeXRef(xrefSection);
                this.writeEOF();
                doc.setXRefSection(xrefSection);
                doc.setDirty(false);
            }
            for (COSObjectProxy proxy : this.getProxies()) {
                proxy.ended(this);
            }
            this.getRandomAccess().flush();
        }
    }

    protected void close(STDocument doc) throws IOException {
    }

    protected byte[] encryptStream(COSDictionary dict, byte[] bytes) throws IOException {
        if (this.getSecurityHandler() != null && this.getCurrentObject() != null) {
            try {
                return this.getSecurityHandler().encryptStream(this.getCurrentObject().getKey(), dict, bytes);
            }
            catch (COSSecurityException e) {
                IOException ioe = new IOException("error encrypting data");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return bytes;
    }

    protected byte[] encryptString(COSString obj) throws IOException {
        byte[] bytes = obj.byteValue();
        if (this.getSecurityHandler() != null && this.getCurrentObject() != null) {
            try {
                return this.getSecurityHandler().encryptString(this.getCurrentObject().getKey(), bytes);
            }
            catch (COSSecurityException e) {
                IOException ioe = new IOException("error encrypting data");
                ioe.initCause(e);
                throw ioe;
            }
        }
        return bytes;
    }

    protected COSIndirectObject getCurrentObject() {
        return this.currentObject;
    }

    public List getProxies() {
        return this.proxies;
    }

    public IRandomAccess getRandomAccess() {
        return this.randomAccess;
    }

    protected ISystemSecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    protected boolean isOnNewLine() {
        return this.onNewLine;
    }

    protected void reset() {
        this.onNewLine = false;
    }

    public void seekToEnd() throws IOException {
        this.randomAccess.seek(this.randomAccess.getLength());
        this.reset();
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    protected void setCurrentObject(COSIndirectObject currentObject) {
        this.currentObject = currentObject;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    @Override
    public Object visitFromArray(COSArray obj) throws COSVisitorException {
        try {
            try {
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().pushContextObject(obj);
                }
                int count = 0;
                this.write(ARRAY_OPEN);
                Iterator<COSDocumentElement> i = obj.basicIterator();
                while (i.hasNext()) {
                    COSDocumentElement current = i.next();
                    current.accept(this);
                    ++count;
                    if (!i.hasNext()) continue;
                    if (count % 10 == 0) {
                        this.writeEOL();
                        continue;
                    }
                    this.write(SPACE);
                }
                this.write(ARRAY_CLOSE);
                this.writeEOL();
            }
            catch (IOException e) {
                throw new COSVisitorException(e);
            }
        }
        finally {
            if (this.getSecurityHandler() != null) {
                this.getSecurityHandler().popContextObject();
            }
        }
        return null;
    }

    @Override
    public Object visitFromBoolean(COSBoolean obj) throws COSVisitorException {
        try {
            if (obj.booleanValue()) {
                this.write(TRUE);
            } else {
                this.write(FALSE);
            }
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    @Override
    public Object visitFromDictionary(COSDictionary obj) throws COSVisitorException {
        try {
            try {
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().pushContextObject(obj);
                }
                this.write(DICT_OPEN);
                this.writeEOL();
                Iterator i = obj.basicEntryIterator();
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    COSName name = (COSName)entry.getKey();
                    COSDocumentElement current = (COSDocumentElement)entry.getValue();
                    if (current == null) continue;
                    COSWriter.basicWriteName(this.randomAccess, name.byteValue());
                    this.write(SPACE);
                    current.accept(this);
                    this.writeEOL();
                }
                this.write(DICT_CLOSE);
                this.writeEOL();
            }
            catch (IOException e) {
                throw new COSVisitorException(e);
            }
        }
        finally {
            if (this.getSecurityHandler() != null) {
                this.getSecurityHandler().popContextObject();
            }
        }
        return null;
    }

    @Override
    public Object visitFromFixed(COSFixed obj) throws COSVisitorException {
        try {
            COSWriter.basicWriteFixed(this.randomAccess, obj.floatValue(), obj.getPrecision());
            this.onNewLine = false;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    @Override
    public Object visitFromIndirectObject(COSIndirectObject obj) throws COSVisitorException {
        this.reset();
        try {
            this.write(StringTools.toByteArray((String)Integer.toString(obj.getObjectNumber())));
            this.write(SPACE);
            this.write(StringTools.toByteArray((String)Integer.toString(obj.getGenerationNumber())));
            this.write(SPACE);
            this.write(REFERENCE);
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    @Override
    public Object visitFromInteger(COSInteger obj) throws COSVisitorException {
        try {
            COSWriter.basicWriteInteger(this.randomAccess, obj.intValue());
            this.onNewLine = false;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    @Override
    public Object visitFromName(COSName obj) throws COSVisitorException {
        try {
            COSWriter.basicWriteName(this.randomAccess, obj.byteValue());
            this.onNewLine = false;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    @Override
    public Object visitFromNull(COSNull obj) throws COSVisitorException {
        try {
            this.write(NULL);
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    @Override
    public Object visitFromProxy(COSObjectProxy obj) throws COSVisitorException {
        try {
            obj.setPosition(this.getRandomAccess().getOffset());
            this.randomAccess.seekBy((long)obj.getLength());
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        this.proxies.add(obj);
        return null;
    }

    @Override
    public Object visitFromStream(COSStream obj) throws COSVisitorException {
        try {
            try {
                byte[] encrypted;
                if (this.getSecurityHandler() != null) {
                    this.getSecurityHandler().pushContextObject(obj);
                }
                byte[] bytes = new byte[]{};
                if (!obj.isExternal()) {
                    bytes = obj.getEncodedBytes();
                }
                int length = (encrypted = this.encryptStream(obj.getDict(), bytes)) == null ? 0 : encrypted.length;
                obj.getDict().basicPutSilent(COSStream.DK_Length, COSInteger.create(length));
                obj.getDict().accept(this);
                length = bytes == null ? 0 : bytes.length;
                obj.getDict().basicPutSilent(COSStream.DK_Length, COSInteger.create(length));
                this.writeCRLF();
                this.writeStreamContent(encrypted);
            }
            catch (IOException e) {
                throw new COSVisitorException(e);
            }
        }
        finally {
            if (this.getSecurityHandler() != null) {
                this.getSecurityHandler().popContextObject();
            }
        }
        return null;
    }

    @Override
    public Object visitFromString(COSString obj) throws COSVisitorException {
        try {
            if (obj.isHexMode()) {
                this.writeStringHex(this.encryptString(obj));
            } else {
                this.writeStringLiteral(this.encryptString(obj));
            }
            this.onNewLine = false;
        }
        catch (IOException e) {
            throw new COSVisitorException(e);
        }
        return null;
    }

    public void write(byte[] b) throws IOException {
        this.onNewLine = false;
        this.randomAccess.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.onNewLine = false;
        this.randomAccess.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.onNewLine = false;
        this.randomAccess.write(b);
    }

    public void writeContentStream(CSContent contentStream) throws IOException {
        int len = contentStream.size();
        int i = 0;
        while (i < len) {
            CSOperation operation = contentStream.getOperation(i);
            try {
                this.writeOperation(operation);
            }
            catch (COSVisitorException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
            this.write(32);
            ++i;
        }
    }

    protected void writeCRLF() throws IOException {
        this.randomAccess.write(CRLF);
    }

    public void writeDocument(STDocument doc) throws IOException {
        this.basicWriteDocument(doc);
        this.close(doc);
    }

    protected void writeEntry(STXRefSection xrefSection, COSIndirectObject object) throws IOException {
        STXRefEntryOccupied entry = new STXRefEntryOccupied(object.getObjectNumber(), object.getGenerationNumber(), this.getRandomAccess().getOffset());
        xrefSection.addEntry(entry);
        this.writeIndirectObject(object);
    }

    protected void writeEOF() throws IOException {
        this.write(EOF);
        this.writeEOL();
    }

    public void writeEOL() throws IOException {
        if (!this.isOnNewLine()) {
            this.randomAccess.write(EOL);
            this.onNewLine = true;
        }
    }

    protected void writeHeader(STDocument stdoc) throws IOException {
        this.write(COMMENT);
        this.write(stdoc.getVersion().getBytes());
        this.writeEOL();
        this.write(COMMENT);
        this.write(GARBAGE);
        this.writeEOL();
    }

    protected void writeImageData(COSObject imageData) throws IOException {
        if (imageData instanceof COSString) {
            this.randomAccess.write(((COSString)imageData).byteValue());
        } else if (imageData instanceof COSStream) {
            this.randomAccess.write(((COSStream)imageData).getDecodedBytes());
        } else if (imageData instanceof COSName) {
            this.randomAccess.write(((COSName)imageData).byteValue());
        }
        this.randomAccess.write(10);
    }

    public void writeIndirectObject(COSIndirectObject obj) throws IOException {
        this.setCurrentObject(obj);
        this.reset();
        this.write(StringTools.toByteArray((String)Integer.toString(obj.getObjectNumber())));
        this.write(SPACE);
        this.write(StringTools.toByteArray((String)Integer.toString(obj.getGenerationNumber())));
        this.write(SPACE);
        this.write(OBJ);
        this.writeEOL();
        try {
            obj.dereference().accept(this);
        }
        catch (COSVisitorException e) {
            Throwable cause = e.getCause() == null ? e : e.getCause();
            IOException ioe = new IOException(cause.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        this.writeEOL();
        this.write(ENDOBJ);
        this.writeEOL();
        this.setCurrentObject(null);
    }

    public void writeObject(COSObject object) throws IOException {
        try {
            object.accept(this);
        }
        catch (COSVisitorException e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
    }

    protected void writeOperation(CSOperation obj) throws COSVisitorException, IOException {
        if (obj.matchesOperator(CSOperators.CSO_EI) && obj.operandSize() == 1) {
            this.writeImageData(obj.getOperand(0));
        } else {
            Iterator i = obj.getOperands();
            while (i.hasNext()) {
                COSObject operand = (COSObject)i.next();
                operand.accept(this);
                this.write(32);
            }
        }
        this.write(obj.getOperatorToken());
    }

    protected void writeStreamContent(byte[] bytes) throws IOException {
        this.write(STREAM);
        this.writeCRLF();
        if (bytes != null) {
            this.write(bytes);
        }
        this.writeCRLF();
        this.write(ENDSTREAM);
        this.writeEOL();
    }

    protected void writeStringHex(byte[] bytes) throws IOException {
        COSWriter.basicWriteStringHex(this.randomAccess, bytes);
    }

    protected void writeStringLiteral(byte[] bytes) throws IOException {
        COSWriter.basicWriteStringLiteral(this.randomAccess, bytes);
    }

    protected void writeXRef(STXRefSection xrefSection) throws IOException {
        AbstractXRefWriter xrefWriter = xrefSection.getWriter(this);
        xrefWriter.writeXRef(xrefSection);
    }
}

