/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Arrays;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSDeviceN;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSDeviceN extends AwtCSSpecial {

	private class DeviceNColorSpace extends ColorSpace {

		private static final long serialVersionUID = 1L;

		private ColorSpace alternateColorSpace;
		private TintTransform tintTransform;

		DeviceNColorSpace() {
			super(getColorSpaceType(), getColorSpaceNumComponents());
			alternateColorSpace = getColorSpace(myPDColorSpace().getAlternate())
					.getColorSpace();
			tintTransform = new TintTransform(myPDColorSpace()
					.getTintTransform());
		}

		@Override
		public float[] fromCIEXYZ(float[] colorvalue) {
			throw new UnsupportedOperationException();
		}

		@Override
		public float[] fromRGB(float[] rgbvalue) {
			throw new UnsupportedOperationException();
		}

		@Override
		public float[] toCIEXYZ(float[] colorvalue) {
			float[] values = colorvalue;
			if (colorvalue.length > getNumComponents()) {
				// will be the case if coming from a transparent image
				values = Arrays.copyOf(colorvalue, getNumComponents());
			}
			return alternateColorSpace.toCIEXYZ(tintTransform.evaluate(values));
		}

		@Override
		public float[] toRGB(float[] colorvalue) {
			return alternateColorSpace
					.toRGB(tintTransform.evaluate(colorvalue));
		}
	}

	public AwtCSDeviceN(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return new DeviceNColorSpace();
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		return CwtAwtImageTools.createColorModel(getColorSpace());
	}

	public int getColorSpaceNumComponents() {
		return myPDColorSpace().getNamedComponents().length;
	}

	protected int getColorSpaceType() {
		switch (getColorSpaceNumComponents()) {
		case 1:
			/*
			 * use TYPE_XYZ because with TYPE_GRAY you actually get gray (AWT
			 * doesn't call the toRGB or toCIEXYZ methods) and there's no
			 * generic 1-component color space
			 */
			return ColorSpace.TYPE_XYZ;
		case 2:
			return ColorSpace.TYPE_2CLR;
		case 3:
			return ColorSpace.TYPE_3CLR;
		case 4:
			return ColorSpace.TYPE_4CLR;
		case 5:
			return ColorSpace.TYPE_5CLR;
		case 6:
			return ColorSpace.TYPE_6CLR;
		case 7:
			return ColorSpace.TYPE_7CLR;
		case 8:
			return ColorSpace.TYPE_8CLR;
		case 9:
			return ColorSpace.TYPE_9CLR;
		case 10:
			return ColorSpace.TYPE_ACLR;
		case 11:
			return ColorSpace.TYPE_BCLR;
		case 12:
			return ColorSpace.TYPE_CCLR;
		case 13:
			return ColorSpace.TYPE_DCLR;
		case 14:
			return ColorSpace.TYPE_ECLR;
		case 15:
			return ColorSpace.TYPE_FCLR;
		default:
			throw new UnsupportedOperationException();
		}
	}

	protected PDCSDeviceN myPDColorSpace() {
		return (PDCSDeviceN) getPDColorSpace();
	}
}
