/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Arrays;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;

/**
 * 
 */
public class AwtCSSeparation extends AwtCSSpecial {

	private class SeparationColorSpace extends ColorSpace {

		private static final long serialVersionUID = 1L;

		private ColorSpace alternateColorSpace;
		private TintTransform tintTransform;

		SeparationColorSpace() {
			/*
			 * use TYPE_XYZ because with TYPE_GRAY you actually get gray (AWT
			 * doesn't call the toRGB or toCIEXYZ methods) and there's no
			 * generic 1-component color space
			 */
			super(ColorSpace.TYPE_XYZ, 1);
			alternateColorSpace = getColorSpace(myPDColorSpace().getAlternate())
					.getColorSpace();
			tintTransform = new TintTransform(myPDColorSpace()
					.getTintTransform());
		}

		@Override
		public float[] fromCIEXYZ(float[] colorvalue) {
			throw new UnsupportedOperationException();
		}

		@Override
		public float[] fromRGB(float[] rgbvalue) {
			throw new UnsupportedOperationException();
		}

		@Override
		public float[] toCIEXYZ(float[] colorvalue) {
			float[] values = colorvalue;
			if (colorvalue.length > 1) {
				// will be the case if coming from a transparent image
				values = Arrays.copyOf(colorvalue, getNumComponents());
			}
			return alternateColorSpace.toCIEXYZ(tintTransform.evaluate(values));
		}

		@Override
		public float[] toRGB(float[] colorvalue) {
			return alternateColorSpace
					.toRGB(tintTransform.evaluate(colorvalue));
		}
	}

	public AwtCSSeparation(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

	@Override
	protected ColorSpace createColorSpace() {
		return new SeparationColorSpace();
	}

	@Override
	public ColorModel getColorModel(PDImage pdImage) {
		return CwtAwtImageTools.createColorModel(getColorSpace());
	}

	@Override
	public int getNumComponents() {
		return 1;
	}

	protected PDCSSeparation myPDColorSpace() {
		return (PDCSSeparation) getPDColorSpace();
	}
}
