/*
 * Copyright (c) 2008, intarsys consulting GmbH
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published by the 
 * Free Software Foundation; either version 3 of the License, 
 * or (at your option) any later version.
 * <p/>
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
 * 
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDFunction;

/**
 * 
 */
abstract public class AwtCSSpecial extends AwtColorSpace {

	protected class TintTransform {

		private final float[][] imageCache;
		private final PDFunction pdFunction;

		TintTransform(PDFunction pdFunction) {
			this.pdFunction = pdFunction;
			imageCache = new float[256][];
		}

		public float[] evaluate(float[] values) {
			/*
			 * A cache might speed up computation considerably. We can't
			 * possibly cache results for every input but we can do so for
			 * simple cases. That is when the size of the float input values is
			 * 1 and the single element probably derives from a byte value (as
			 * is the case when coming from a PDImage). Might be extended to
			 * array sizes larger than 1.
			 */
			int index = -1;
			if (values.length == 1) {
				float byteValue = values[0] * 255;
				if (byteValue == (int) byteValue) {
					index = (int) byteValue;
					if (imageCache[index] != null) {
						return imageCache[index];
					}
				}
			}
			float[] result = pdFunction.evaluate(values);
			if (index != -1) {
				imageCache[index] = result;
			}
			return result;
		}

	}

	public AwtCSSpecial(PDColorSpace pdColorSpace) {
		super(pdColorSpace);
	}

}
