/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.adapter.awt;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsContext;
import de.intarsys.cwt.awt.environment.CwtAwtGraphicsEnvironment;
import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.pdf.pd.PDAxialShading;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.adapter.CommonGraphicsEnvironmentAdapter;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpace;
import de.intarsys.pdf.platform.cwt.color.awt.AwtColorSpaceFactory;
import de.intarsys.pdf.platform.cwt.image.awt.ImageConverterPdf2Awt;
import de.intarsys.pdf.platform.cwt.paint.ColorPaint;
import de.intarsys.pdf.platform.cwt.paint.PatternPaint;
import de.intarsys.pdf.platform.cwt.paint.ShadingPaint;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Image;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.lang.ref.SoftReference;

public class AwtGraphicsEnvironmentAdapter
extends CommonGraphicsEnvironmentAdapter {
    private static AwtGraphicsEnvironmentAdapter ACTIVE;
    private static final Attribute ATTR_BUFFEREDIMAGE;

    static {
        ATTR_BUFFEREDIMAGE = new Attribute("bufferedImage");
    }

    public static AwtGraphicsEnvironmentAdapter get() {
        return ACTIVE;
    }

    public AwtGraphicsEnvironmentAdapter() {
        ACTIVE = this;
    }

    protected float adjustAlpha(float[] rgb, float alpha) {
        float alphaFactor = 0.5f;
        if (rgb != null) {
            float luminance = (rgb[0] + rgb[1] + rgb[2]) / 3.0f;
            alphaFactor = 1.0f - luminance;
        }
        return alpha * alphaFactor;
    }

    public synchronized BufferedImage createImage(PDImage pdImage) {
        BufferedImage result = (BufferedImage)pdImage.getAttribute((Object)ATTR_BUFFEREDIMAGE);
        if (result == null) {
            ImageConverterPdf2Awt converter = new ImageConverterPdf2Awt(pdImage);
            result = converter.getBufferedImage();
            pdImage.setAttribute((Object)ATTR_BUFFEREDIMAGE, (Object)result);
        }
        return result;
    }

    public BufferedImage createImage(PDImage pdImage, float[] rgb) {
        BufferedImage image;
        int red = (int)(rgb[0] * 255.0f);
        int green = (int)(rgb[1] * 255.0f);
        int blue = (int)(rgb[2] * 255.0f);
        String key = "awt-iimage-" + (red << 16 | green << 8 | blue);
        SoftReference ref = (SoftReference)pdImage.getAttribute((Object)key);
        if (ref != null && (image = (BufferedImage)ref.get()) != null) {
            return image;
        }
        image = this.createImage(pdImage);
        byte[] byArray = new byte[6];
        byArray[0] = (byte)red;
        byArray[1] = (byte)green;
        byArray[2] = (byte)blue;
        byArray[3] = (byte)(red == 0 ? 1 : 0);
        byte[] cmap = byArray;
        IndexColorModel colorModel = new IndexColorModel(1, 2, cmap, 0, false, 1);
        image = new BufferedImage(colorModel, image.getRaster(), false, null);
        pdImage.setAttribute((Object)key, new SoftReference<BufferedImage>(image));
        return image;
    }

    protected Paint createPaintColorPaint(ColorPaint paint, boolean adjust) {
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(paint.getPdColorSpace());
        float[] colorValues = paint.getColorValues();
        float[] rgb = colorValues == null ? new float[]{0.0f, 0.0f, 0.0f} : awtColorSpace.getRGB(colorValues);
        float alpha = paint.getAlphaValue();
        if (adjust) {
            alpha = this.adjustAlpha(rgb, alpha);
        }
        return new Color(rgb[0], rgb[1], rgb[2], alpha);
    }

    protected Paint createPaintPatternPaint(PatternPaint paint) {
        return new Color(0.5f, 0.5f, 0.5f, 0.5f);
    }

    protected Paint createPaintShadingPaint(ShadingPaint paint) {
        if (!(paint.getPdShading() instanceof PDAxialShading)) {
            return new Color(0.5f, 0.5f, 0.5f, 0.5f);
        }
        PDAxialShading axialShading = (PDAxialShading)paint.getPdShading();
        float[] coords = axialShading.getCoords();
        float[] domain = axialShading.getDomain();
        PDFunction function = axialShading.getFunction();
        AwtColorSpace awtColorSpace = AwtColorSpaceFactory.get().createColorSpace(paint.getPdShading().getColorSpace());
        float[] rgb = awtColorSpace.getRGB(function.evaluate(new float[]{domain[0]}));
        Color rgbColor1 = new Color(rgb[0], rgb[1], rgb[2]);
        rgb = awtColorSpace.getRGB(function.evaluate(new float[]{domain[1]}));
        Color rgbColor2 = new Color(rgb[0], rgb[1], rgb[2]);
        return new GradientPaint(coords[0], coords[1], rgbColor1, coords[2], coords[3], rgbColor2);
    }

    @Override
    public void drawImage(IGraphicsContext graphicsContext, PDImage pdImage, float x, float y) {
        BufferedImage awtImage = this.createImage(pdImage);
        if (pdImage.isImageMask()) {
            float[] rgb = graphicsContext.getBackgroundColor().getRGBColorComponents(null);
            awtImage = this.createImage(pdImage, rgb);
        }
        float definedWidth = pdImage.getWidth();
        float definedHeight = pdImage.getHeight();
        float realWidth = awtImage.getWidth();
        float realHeight = awtImage.getHeight();
        AffineTransform tempTransform = null;
        if (definedHeight < realHeight || definedWidth < realWidth) {
            tempTransform = graphicsContext.getTransform();
            AffineTransform transform = new AffineTransform();
            transform.scale(definedWidth / realWidth, definedHeight / realHeight);
            graphicsContext.transform(transform);
        }
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        try {
            awtGC.getGraphics().drawImage((Image)awtImage, (int)x, (int)y, null);
        }
        finally {
            if (tempTransform != null) {
                graphicsContext.setTransform(tempTransform);
            }
        }
    }

    @Override
    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtAwtGraphicsEnvironment.get();
    }

    @Override
    public void setBackgroundColorPaint(IGraphicsContext graphicsContext, ColorPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintColorPaint(paint, awtGC.getBlendMode() == BlendMode.MULTIPLY);
        awtGC.setBackgroundPaint(awtPaint);
    }

    @Override
    public void setBackgroundPatternPaint(IGraphicsContext graphicsContext, PatternPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintPatternPaint(paint);
        awtGC.setBackgroundPaint(awtPaint);
    }

    @Override
    public void setBackgroundShadingPaint(IGraphicsContext graphicsContext, ShadingPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintShadingPaint(paint);
        awtGC.setBackgroundPaint(awtPaint);
    }

    @Override
    public void setForegroundColorPaint(IGraphicsContext graphicsContext, ColorPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintColorPaint(paint, awtGC.getBlendMode() == BlendMode.MULTIPLY);
        awtGC.setForegroundPaint(awtPaint);
    }

    @Override
    public void setForegroundPatternPaint(IGraphicsContext graphicsContext, PatternPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintPatternPaint(paint);
        awtGC.setForegroundPaint(awtPaint);
    }

    @Override
    public void setForegroundShadingPaint(IGraphicsContext graphicsContext, ShadingPaint paint) {
        CwtAwtGraphicsContext awtGC = (CwtAwtGraphicsContext)graphicsContext;
        Paint awtPaint = this.createPaintShadingPaint(paint);
        awtGC.setForegroundPaint(awtPaint);
    }
}

