/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSDeviceN;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSSpecial;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Arrays;

public class AwtCSDeviceN
extends AwtCSSpecial {
    public AwtCSDeviceN(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        return new DeviceNColorSpace();
    }

    @Override
    public ColorModel getColorModel(PDImage pdImage) {
        return CwtAwtImageTools.createColorModel((ColorSpace)this.getColorSpace());
    }

    public int getColorSpaceNumComponents() {
        return this.myPDColorSpace().getNamedComponents().length;
    }

    protected int getColorSpaceType() {
        switch (this.getColorSpaceNumComponents()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 12;
            }
            case 3: {
                return 13;
            }
            case 4: {
                return 14;
            }
            case 5: {
                return 15;
            }
            case 6: {
                return 16;
            }
            case 7: {
                return 17;
            }
            case 8: {
                return 18;
            }
            case 9: {
                return 19;
            }
            case 10: {
                return 20;
            }
            case 11: {
                return 21;
            }
            case 12: {
                return 22;
            }
            case 13: {
                return 23;
            }
            case 14: {
                return 24;
            }
            case 15: {
                return 25;
            }
        }
        throw new UnsupportedOperationException();
    }

    protected PDCSDeviceN myPDColorSpace() {
        return (PDCSDeviceN)this.getPDColorSpace();
    }

    private class DeviceNColorSpace
    extends ColorSpace {
        private static final long serialVersionUID = 1L;
        private ColorSpace alternateColorSpace;
        private AwtCSSpecial.TintTransform tintTransform;

        DeviceNColorSpace() {
            super(AwtCSDeviceN.this.getColorSpaceType(), AwtCSDeviceN.this.getColorSpaceNumComponents());
            this.alternateColorSpace = AwtCSDeviceN.getColorSpace(AwtCSDeviceN.this.myPDColorSpace().getAlternate()).getColorSpace();
            this.tintTransform = new AwtCSSpecial.TintTransform(AwtCSDeviceN.this, AwtCSDeviceN.this.myPDColorSpace().getTintTransform());
        }

        @Override
        public float[] fromCIEXYZ(float[] colorvalue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] fromRGB(float[] rgbvalue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] toCIEXYZ(float[] colorvalue) {
            float[] values = colorvalue;
            if (colorvalue.length > this.getNumComponents()) {
                values = Arrays.copyOf(colorvalue, this.getNumComponents());
            }
            return this.alternateColorSpace.toCIEXYZ(this.tintTransform.evaluate(values));
        }

        @Override
        public float[] toRGB(float[] colorvalue) {
            return this.alternateColorSpace.toRGB(this.tintTransform.evaluate(colorvalue));
        }
    }
}

