/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSLab;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSCIEBased;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;

public class AwtCSLab
extends AwtCSCIEBased {
    public AwtCSLab(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        return new LabColorSpace();
    }

    @Override
    public ColorModel getColorModel(PDImage pdImage) {
        return CwtAwtImageTools.createColorModel((ColorSpace)this.getColorSpace());
    }

    @Override
    public int getNumComponents() {
        return 3;
    }

    protected PDCSLab myPDColorSpace() {
        return (PDCSLab)this.getPDColorSpace();
    }

    class LabColorSpace
    extends ColorSpace {
        private static final long serialVersionUID = 1L;

        LabColorSpace() {
            super(13, 3);
        }

        @Override
        public float[] fromCIEXYZ(float[] colorvalue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] fromRGB(float[] rgbvalue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] toCIEXYZ(float[] colorvalue) {
            float[] whitePoint = AwtCSLab.this.myPDColorSpace().getWhitePoint();
            float l = (colorvalue[0] + 16.0f) / 116.0f + colorvalue[1] / 500.0f;
            float m = (colorvalue[0] + 16.0f) / 116.0f;
            float n = (colorvalue[0] + 16.0f) / 116.0f - colorvalue[2] / 200.0f;
            float x = whitePoint[0] * (l >= 0.20689656f ? (float)Math.pow(l, 3.0) : 0.12841855f * (l - 0.13793103f));
            float y = whitePoint[1] * (m >= 0.20689656f ? (float)Math.pow(m, 3.0) : 0.12841855f * (m - 0.13793103f));
            float z = whitePoint[2] * (n >= 0.20689656f ? (float)Math.pow(n, 3.0) : 0.12841855f * (n - 0.13793103f));
            return new float[]{Math.max(Math.min(x, 1.0f), 0.0f), Math.max(Math.min(y, 1.0f), 0.0f), Math.max(Math.min(z, 1.0f), 0.0f)};
        }

        @Override
        public float[] toRGB(float[] colorvalue) {
            return ColorSpace.getInstance(1001).toRGB(this.toCIEXYZ(colorvalue));
        }
    }
}

