/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.color.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.pd.PDCSSeparation;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.platform.cwt.color.awt.AwtCSSpecial;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Arrays;

public class AwtCSSeparation
extends AwtCSSpecial {
    public AwtCSSeparation(PDColorSpace pdColorSpace) {
        super(pdColorSpace);
    }

    @Override
    protected ColorSpace createColorSpace() {
        return new SeparationColorSpace();
    }

    @Override
    public ColorModel getColorModel(PDImage pdImage) {
        return CwtAwtImageTools.createColorModel((ColorSpace)this.getColorSpace());
    }

    @Override
    public int getNumComponents() {
        return 1;
    }

    protected PDCSSeparation myPDColorSpace() {
        return (PDCSSeparation)this.getPDColorSpace();
    }

    private class SeparationColorSpace
    extends ColorSpace {
        private static final long serialVersionUID = 1L;
        private ColorSpace alternateColorSpace;
        private AwtCSSpecial.TintTransform tintTransform;

        SeparationColorSpace() {
            super(0, 1);
            this.alternateColorSpace = AwtCSSeparation.getColorSpace(AwtCSSeparation.this.myPDColorSpace().getAlternate()).getColorSpace();
            this.tintTransform = new AwtCSSpecial.TintTransform(AwtCSSeparation.this, AwtCSSeparation.this.myPDColorSpace().getTintTransform());
        }

        @Override
        public float[] fromCIEXYZ(float[] colorvalue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] fromRGB(float[] rgbvalue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public float[] toCIEXYZ(float[] colorvalue) {
            float[] values = colorvalue;
            if (colorvalue.length > 1) {
                values = Arrays.copyOf(colorvalue, this.getNumComponents());
            }
            return this.alternateColorSpace.toCIEXYZ(this.tintTransform.evaluate(values));
        }

        @Override
        public float[] toRGB(float[] colorvalue) {
            return this.alternateColorSpace.toRGB(this.tintTransform.evaluate(colorvalue));
        }
    }
}

