/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.awt;

import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.awt.AwtGlyphs;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.attribute.Attribute;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;

public class AwtFont
implements IPlatformFont {
    private static final Attribute ATTR_PLATFORMGLYPHS = new Attribute("platformGlyphs");
    protected static final Attribute ATTR_SCALE = new Attribute("platformFontScale");
    protected static final Attribute ATTR_TRANSFORM = new Attribute("platformFontTransform");
    private final PDFont font;
    private final Font awtFont;
    private int highByte = -1;
    private double textSpaceFactor = 1.0;
    private PDGlyphs currentGlyphs = null;
    private boolean symbolic = false;

    protected AwtFont(PDFont font, Font face) {
        this.font = font;
        this.awtFont = face;
        this.textSpaceFactor = 1000.0;
        PDFontDescriptor fontDescriptor = null;
        try {
            fontDescriptor = font.getFontDescriptor();
            this.symbolic = fontDescriptor.isSymbolic();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IPlatformGlyphs basicCreate(PDGlyphs glyphs) throws PlatformFontException {
        int codepoint = glyphs.getCodepoint();
        if (codepoint < 0) {
            return null;
        }
        return new AwtGlyphs(this, glyphs);
    }

    @Override
    public synchronized IPlatformGlyphs createPlatformGlyphs(PDGlyphs glyphs) throws PlatformFontException {
        IPlatformGlyphs result = (IPlatformGlyphs)glyphs.getAttribute((Object)ATTR_PLATFORMGLYPHS);
        if (result == null) {
            result = this.basicCreate(glyphs);
            glyphs.setAttribute((Object)ATTR_PLATFORMGLYPHS, (Object)result);
        }
        return result;
    }

    @Override
    public int getAscent() {
        int result = 10;
        return (int)((double)result * this.getTextSpaceFactor());
    }

    public Font getAwtFont() {
        return this.awtFont;
    }

    @Override
    public Rectangle2D getBBox() {
        Rectangle2D.Double fontBox = new Rectangle2D.Double(0.0, 0.0, 10.0, 12.0);
        int x = (int)(fontBox.getMinX() * this.getTextSpaceFactor());
        int y = (int)(fontBox.getMinY() * this.getTextSpaceFactor());
        int width = (int)(((RectangularShape)fontBox).getWidth() * this.getTextSpaceFactor());
        int height = (int)(((RectangularShape)fontBox).getHeight() * this.getTextSpaceFactor());
        return new Rectangle2D.Float(x, y, width, height);
    }

    @Override
    public int getCharIndex(char unicode) {
        return unicode;
    }

    @Override
    public int getDescent() {
        int result = 2;
        return (int)((double)result * this.getTextSpaceFactor());
    }

    @Override
    public int getHeight() {
        int result = 12;
        return (int)((double)result * this.getTextSpaceFactor());
    }

    public Object getImpl() {
        return this.getAwtFont();
    }

    @Override
    public PDFont getPDFont() {
        return this.font;
    }

    public double getTextSpaceFactor() {
        return this.textSpaceFactor;
    }

    @Override
    public int getUnderlinePosition() {
        return 0;
    }

    @Override
    public int getUnderlineThickness() {
        return 1;
    }

    @Override
    public boolean isBoldStyle() {
        return false;
    }

    @Override
    public boolean isItalicStyle() {
        return false;
    }

    @Override
    public boolean isMonospaced() {
        return false;
    }

    @Override
    public boolean isSymbolFont() {
        return false;
    }

    public boolean isSymbolic() {
        return this.symbolic;
    }

    @Override
    public void saveState(ICSPlatformDevice device, GraphicsState oldState, GraphicsState newState) {
    }

    @Override
    public void textStateChanged(ICSPlatformDevice device) {
        GraphicsState graphicsState = device.getGraphicsState();
        float fontScale = graphicsState.textState.fontSize;
        AffineTransform tempTransform = AffineTransform.getScaleInstance(fontScale * graphicsState.textState.derivedHorizontalScalingFactor, -fontScale);
        graphicsState.setAttribute((Object)ATTR_TRANSFORM, (Object)tempTransform);
    }
}

