/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.awt;

import de.intarsys.cwt.font.IFont;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontDescriptorEmbedded;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.NullPlatformFontFactory;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.PlatformFontTools;
import de.intarsys.pdf.platform.cwt.font.awt.AwtFont;
import de.intarsys.pdf.platform.cwt.font.awt.PACKAGE;
import de.intarsys.pdf.platform.cwt.font.type3.Type3FontFactory;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.stream.StreamTools;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AwtFontFactory
implements IPlatformFontFactory {
    private static final Logger Log = PACKAGE.Log;
    private static final Attribute ATTR_PLATFORMFONT = new Attribute("platformFont");
    private Type3FontFactory type3FontFactory = new Type3FontFactory();
    private NullPlatformFontFactory nullFontFactory = new NullPlatformFontFactory();

    protected static void registerPlatformFont(IAttributeSupport as, IPlatformFont object) {
        as.setAttribute((Object)ATTR_PLATFORMFONT, (Object)object);
    }

    protected IPlatformFont basicCreate(PDFont font) throws PlatformFontException {
        if (font instanceof PDFontType3) {
            return this.type3FontFactory.createPlatformFont(font);
        }
        Font awtFont = null;
        PDFontDescriptor pdDesc = null;
        try {
            pdDesc = font.getFontDescriptor();
        }
        catch (COSRuntimeException cOSRuntimeException) {
            // empty catch block
        }
        if (pdDesc != null) {
            byte[] fontdata = null;
            fontdata = pdDesc.getFontFile();
            if (fontdata != null) {
                awtFont = this.loadFace(1, fontdata);
            } else {
                fontdata = pdDesc.getFontFile2();
                if (fontdata != null) {
                    awtFont = this.loadFace(0, fontdata);
                } else {
                    COSStream stream = pdDesc.cosGetFontFile3();
                    if (stream != null) {
                        fontdata = stream.getDecodedBytes();
                        COSName subtype = stream.getDict().get(PDFontDescriptorEmbedded.DK_Subtype).asName();
                        if (PDFontDescriptorEmbedded.CN_SubType_Type1C.equals((Object)subtype)) {
                            awtFont = this.loadFace(1, fontdata);
                        } else if (!PDFontDescriptorEmbedded.CN_SubType_CIDFontType0C.equals((Object)subtype) && PDFontDescriptorEmbedded.CN_SubType_OpenType.equals((Object)subtype)) {
                            awtFont = this.loadFace(0, fontdata);
                        }
                    }
                }
            }
        }
        if (awtFont == null) {
            awtFont = this.getExternalFont(font);
        }
        if (awtFont == null) {
            Log.log(Level.WARNING, "can't load font '" + font.getBaseFont() + "'");
            return this.nullFontFactory.createPlatformFont(font);
        }
        AwtFont result = new AwtFont(font, awtFont);
        return result;
    }

    @Override
    public synchronized IPlatformFont createPlatformFont(PDFont font) throws PlatformFontException {
        IPlatformFont result = (IPlatformFont)font.getAttribute((Object)ATTR_PLATFORMFONT);
        if (result == null) {
            result = this.basicCreate(font);
            AwtFontFactory.registerPlatformFont((IAttributeSupport)font, result);
        }
        return result;
    }

    protected Font getExternalFont(PDFont pdFont) throws CSException {
        IFont font = PlatformFontTools.getCWTFont(pdFont);
        if (font != null) {
            return this.loadFace(font);
        }
        return null;
    }

    protected Font loadFace(IFont font) {
        InputStream is = null;
        try {
            is = font.getFontProgram().getLocator().getInputStream();
            if ("TrueType".equals(font.getFontType())) {
                return Font.createFont(0, is);
            }
            return Font.createFont(1, is);
        }
        catch (Exception e) {
            StreamTools.close(is);
            return null;
        }
    }

    protected Font loadFace(int format, byte[] data) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        try {
            return Font.createFont(format, is);
        }
        catch (Exception e) {
            StreamTools.close((InputStream)is);
            return null;
        }
    }
}

