/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.awt;

import de.intarsys.cwt.common.ShapeWrapper;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.PlatformFontException;
import de.intarsys.pdf.platform.cwt.font.awt.AwtFont;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;
import de.intarsys.tools.geometry.ApplyTransformationShape;
import de.intarsys.tools.geometry.TransformedShape;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class AwtGlyphs
implements IPlatformGlyphs {
    private static final Shape EMPTY = new GeneralPath();
    private final AwtFont font;
    private final PDGlyphs glyphs;
    private Shape shape;
    private int width;
    private static final AffineTransform TX = new AffineTransform(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});

    protected AwtGlyphs(AwtFont font, PDGlyphs glyphs) throws PlatformFontException {
        this.font = font;
        this.glyphs = glyphs;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Shape createShape() {
        AwtFont awtFont = this.font;
        synchronized (awtFont) {
            Font awtFont2 = this.getFont().getAwtFont();
            FontRenderContext frc = new FontRenderContext(TX, true, true);
            char[] chars = this.getGlyphs().getChars();
            GlyphVector v = awtFont2.createGlyphVector(frc, chars);
            ShapeWrapper iShape = new ShapeWrapper(v.getOutline());
            return iShape;
        }
    }

    public AwtFont getFont() {
        return this.font;
    }

    @Override
    public PDGlyphs getGlyphs() {
        return this.glyphs;
    }

    @Override
    public IPlatformFont getPlatformFont() {
        return this.font;
    }

    public Shape getShape() {
        if (this.shape == null) {
            this.shape = this.createShape();
        }
        return this.shape;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws PlatformFontException {
        AwtFont awtFont = this.font;
        synchronized (awtFont) {
            this.setWidth(10);
        }
    }

    @Override
    public void render(ICSPlatformDevice device) {
        Shape glyphShape = this.getShape();
        if (glyphShape == EMPTY) {
            return;
        }
        GraphicsState graphicsState = device.getGraphicsState();
        IGraphicsContext gc = device.getGraphicsContext();
        AffineTransform fontTransform = (AffineTransform)graphicsState.getAttribute((Object)AwtFont.ATTR_TRANSFORM);
        TransformedShape tempShape = ApplyTransformationShape.create((Shape)glyphShape, (AffineTransform)fontTransform);
        int mode = graphicsState.textState.renderingMode & 3;
        if (mode == 0) {
            gc.fill((Shape)tempShape);
        } else if (mode == 1) {
            gc.draw((Shape)tempShape);
        } else if (mode == 2) {
            gc.fill((Shape)tempShape);
            gc.draw((Shape)tempShape);
        }
        if ((graphicsState.textState.renderingMode & 4) == 4) {
            device.addTextClip((Shape)tempShape);
        }
    }

    public void setWidth(int width) {
        this.width = width;
    }
}

