/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.font.type3;

import de.intarsys.pdf.cds.CDSMatrix;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.GraphicsState;
import de.intarsys.pdf.content.TextState;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.font.PDFontType3;
import de.intarsys.pdf.font.PDGlyphs;
import de.intarsys.pdf.platform.cwt.font.IPlatformFont;
import de.intarsys.pdf.platform.cwt.font.IPlatformGlyphs;
import de.intarsys.pdf.platform.cwt.font.type3.Type3Font;
import de.intarsys.pdf.platform.cwt.rendering.ICSPlatformDevice;

public class Type3Glyphs
implements IPlatformGlyphs {
    private final Type3Font font;
    private final PDFontType3 pdFont;
    private final PDGlyphs glyphs;

    protected Type3Glyphs(Type3Font font, PDGlyphs glyphs) {
        this.font = font;
        this.pdFont = (PDFontType3)font.getPDFont();
        this.glyphs = glyphs;
    }

    @Override
    public PDGlyphs getGlyphs() {
        return this.glyphs;
    }

    @Override
    public IPlatformFont getPlatformFont() {
        return this.font;
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public void render(ICSPlatformDevice device) {
        GraphicsState graphicsState = device.getGraphicsState();
        COSDictionary charProcs = this.pdFont.cosGetCharProcs();
        String glyphName = this.pdFont.getEncoding().getGlyphName(this.glyphs.getCodepoint());
        if (glyphName == null) {
            return;
        }
        COSStream charProc = charProcs.get(COSName.create((String)glyphName)).asStream();
        if (charProc == null) {
            return;
        }
        CSContent charCS = CSContent.createFromCos((COSStream)charProc);
        device.saveState();
        try {
            TextState textState = graphicsState.textState;
            device.transform(textState.fontSize * textState.derivedHorizontalScalingFactor, 0.0f, 0.0f, textState.fontSize, 0.0f, 0.0f);
            CDSMatrix m = this.pdFont.getFontMatrix();
            if (m != null) {
                device.transform(m.getA(), m.getB(), m.getC(), m.getD(), m.getE(), m.getF());
            }
            device.getInterpreter().process(charCS, this.pdFont.getResources());
        }
        finally {
            device.restoreState();
        }
    }
}

