/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.platform.cwt.image.awt;

import de.intarsys.cwt.awt.image.CwtAwtImageTools;
import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSString;
import de.intarsys.pdf.filter.Filter;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDImage;
import de.intarsys.pdf.pd.PDXObject;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.NoSuchElementException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class ImageConverterAwt2Pdf {
    public static final String IMAGEWRITER_JPEG = "JPEG";
    private final BufferedImage bufferedImage;
    private PDImage pdImage;
    private boolean preferJpeg = false;
    private float compressionQuality = 0.75f;

    public ImageConverterAwt2Pdf(BufferedImage bufferedImage) {
        this.bufferedImage = bufferedImage;
    }

    protected PDImage createPDImage() {
        this.pdImage = (PDImage)PDImage.META.createNew();
        this.renderImage();
        if (this.getPDImage().cosGetStream().getFirstFilter() == null) {
            try {
                this.getPDImage().cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.pdImage;
    }

    public float getCompressionQuality() {
        return this.compressionQuality;
    }

    public PDImage getPDImage() {
        if (this.pdImage == null) {
            this.pdImage = this.createPDImage();
        }
        return this.pdImage;
    }

    public boolean isPreferJpeg() {
        return this.preferJpeg;
    }

    protected void renderGray() {
        byte[] bytes;
        byte[] dataElements;
        this.getPDImage().cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
        int pixelSize = this.bufferedImage.getColorModel().getPixelSize();
        this.getPDImage().setBitsPerComponent(pixelSize / this.bufferedImage.getColorModel().getNumComponents());
        if (pixelSize / this.bufferedImage.getColorModel().getNumComponents() != 8) {
            throw new UnsupportedOperationException();
        }
        Raster raster = this.bufferedImage.getData();
        this.getPDImage().setWidth(raster.getWidth());
        this.getPDImage().setHeight(raster.getHeight());
        if (!this.bufferedImage.getColorModel().hasAlpha() && this.preferJpeg && this.renderJpegEncoded()) {
            return;
        }
        try {
            dataElements = (byte[])raster.getDataElements(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), null);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
        if (this.bufferedImage.getColorModel().hasAlpha()) {
            bytes = new byte[dataElements.length / 2];
            byte[] maskBytes = new byte[dataElements.length / 2];
            PDImage mask = (PDImage)PDImage.META.createNew();
            mask.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
            mask.setBitsPerComponent(8);
            mask.setWidth(raster.getWidth());
            mask.setHeight(raster.getHeight());
            int i = 0;
            while (i < bytes.length) {
                bytes[i] = dataElements[i * 2];
                maskBytes[i] = dataElements[i * 2 + 1];
                ++i;
            }
            mask.setBytes(maskBytes);
            this.getPDImage().setSMask((PDXObject)mask);
        } else {
            bytes = new byte[dataElements.length];
            System.arraycopy(dataElements, 0, bytes, 0, dataElements.length);
        }
        this.getPDImage().setBytes(bytes);
    }

    protected void renderImage() {
        ColorModel colorModel = this.bufferedImage.getColorModel();
        if (colorModel instanceof IndexColorModel) {
            this.renderIndexed();
            return;
        }
        if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().equals(ColorSpace.getInstance(1003))) {
            this.renderGray();
            return;
        }
        if (colorModel instanceof ComponentColorModel && colorModel.getColorSpace().isCS_sRGB()) {
            this.renderRGB();
            return;
        }
        colorModel = CwtAwtImageTools.createTransparentColorModel((ColorSpace)ColorSpace.getInstance(1000));
        WritableRaster raster = colorModel.createCompatibleWritableRaster(this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        BufferedImage newImage = new BufferedImage(colorModel, raster, false, null);
        Graphics2D graphics = newImage.createGraphics();
        graphics.clearRect(0, 0, this.bufferedImage.getWidth(), this.bufferedImage.getHeight());
        graphics.drawImage((Image)this.bufferedImage, 0, 0, null);
        graphics.dispose();
        this.renderRGB();
    }

    protected void renderIndexed() {
        byte[] maskBytes;
        IndexColorModel colorModel = (IndexColorModel)this.bufferedImage.getColorModel();
        int[] rgbs = new int[colorModel.getMapSize()];
        colorModel.getRGBs(rgbs);
        byte[] colors = new byte[rgbs.length * 3];
        int index = 0;
        while (index < rgbs.length) {
            colors[index * 3] = (byte)(rgbs[index] >> 16);
            colors[index * 3 + 1] = (byte)(rgbs[index] >> 8);
            colors[index * 3 + 2] = (byte)rgbs[index];
            ++index;
        }
        COSArray colorSpace = COSArray.create((int)4);
        colorSpace.add((COSObject)PDColorSpace.CN_CS_Indexed);
        colorSpace.add((COSObject)PDColorSpace.CN_CS_DeviceRGB);
        colorSpace.add((COSObject)COSInteger.create((int)(colorModel.getMapSize() - 1)));
        colorSpace.add((COSObject)COSString.create((byte[])colors));
        this.getPDImage().cosSetColorSpace(colorSpace);
        int pixelSize = this.bufferedImage.getColorModel().getPixelSize();
        this.getPDImage().setBitsPerComponent(pixelSize);
        Raster raster = this.bufferedImage.getData();
        this.getPDImage().setWidth(raster.getWidth());
        this.getPDImage().setHeight(raster.getHeight());
        int rowSize = (raster.getWidth() * pixelSize + 7) / 8;
        byte[] bytes = new byte[rowSize * raster.getHeight()];
        int transparentPixel = ((IndexColorModel)this.bufferedImage.getColorModel()).getTransparentPixel();
        if (transparentPixel != -1) {
            maskBytes = new byte[raster.getWidth() * raster.getHeight()];
            index = 0;
            while (index < maskBytes.length) {
                maskBytes[index] = -1;
                ++index;
            }
        } else {
            maskBytes = null;
        }
        int row = raster.getMinY();
        while (row < raster.getHeight() - raster.getMinY()) {
            byte[] dataElements;
            try {
                dataElements = (byte[])raster.getDataElements(raster.getMinX(), row, raster.getWidth(), 1, null);
            }
            catch (ClassCastException ex) {
                throw new UnsupportedOperationException();
            }
            int index2 = 0;
            while (index2 < dataElements.length) {
                int byteIndex = index2 * pixelSize / 8 + row * rowSize;
                bytes[byteIndex] = (byte)(bytes[byteIndex] | dataElements[index2] << 8 - pixelSize - index2 * pixelSize % 8);
                if ((dataElements[index2] & 0xFF) == transparentPixel) {
                    maskBytes[row * raster.getWidth() + index2] = 0;
                }
                ++index2;
            }
            ++row;
        }
        if (maskBytes != null) {
            PDImage maskImage = (PDImage)PDImage.META.createNew();
            maskImage.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
            maskImage.setBitsPerComponent(8);
            maskImage.setWidth(raster.getWidth());
            maskImage.setHeight(raster.getHeight());
            maskImage.setBytes(maskBytes);
            maskImage.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
            this.getPDImage().setSMask((PDXObject)maskImage);
        }
        this.getPDImage().setBytes(bytes);
    }

    protected boolean renderJpegEncoded() {
        ByteArrayOutputStream stream;
        ImageWriter writer;
        ImageOutputStream imageStream = null;
        try {
            writer = ImageIO.getImageWritersByFormatName(IMAGEWRITER_JPEG).next();
        }
        catch (NoSuchElementException ex) {
            return false;
        }
        try {
            try {
                stream = new ByteArrayOutputStream();
                imageStream = ImageIO.createImageOutputStream(stream);
                writer.setOutput(imageStream);
                JPEGImageWriteParam iwparam = new JPEGImageWriteParam(Locale.getDefault());
                iwparam.setCompressionMode(2);
                iwparam.setCompressionQuality(this.getCompressionQuality());
                iwparam.setProgressiveMode(3);
                writer.write(null, new IIOImage(this.bufferedImage, null, null), iwparam);
            }
            catch (IOException ex) {
                if (writer != null) {
                    writer.reset();
                    writer.dispose();
                }
                if (imageStream != null) {
                    try {
                        imageStream.flush();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        imageStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return false;
            }
        }
        finally {
            if (writer != null) {
                writer.reset();
                writer.dispose();
            }
            if (imageStream != null) {
                try {
                    imageStream.flush();
                }
                catch (IOException iOException) {}
                try {
                    imageStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        this.getPDImage().cosGetStream().addFilter(Filter.CN_Filter_DCTDecode);
        this.getPDImage().cosGetStream().setEncodedBytes(stream.toByteArray());
        return true;
    }

    protected void renderRGB() {
        byte[] bytes;
        byte[] dataElements;
        this.getPDImage().cosSetColorSpace(PDColorSpace.CN_CS_DeviceRGB);
        int pixelSize = this.bufferedImage.getColorModel().getPixelSize();
        if (pixelSize / this.bufferedImage.getColorModel().getNumComponents() != 8) {
            throw new UnsupportedOperationException();
        }
        this.getPDImage().setBitsPerComponent(8);
        Raster raster = this.bufferedImage.getData();
        this.getPDImage().setWidth(raster.getWidth());
        this.getPDImage().setHeight(raster.getHeight());
        if (!this.bufferedImage.getColorModel().hasAlpha() && this.preferJpeg && this.renderJpegEncoded()) {
            return;
        }
        try {
            dataElements = (byte[])raster.getDataElements(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), null);
        }
        catch (ClassCastException ex) {
            throw new UnsupportedOperationException();
        }
        if (this.bufferedImage.getColorModel().hasAlpha()) {
            bytes = new byte[dataElements.length / 4 * 3];
            byte[] maskBytes = new byte[dataElements.length / 4];
            PDImage mask = (PDImage)PDImage.META.createNew();
            mask.cosSetColorSpace(PDColorSpace.CN_CS_DeviceGray);
            mask.setBitsPerComponent(8);
            mask.setWidth(raster.getWidth());
            mask.setHeight(raster.getHeight());
            int i = 0;
            while (i < dataElements.length / 4) {
                bytes[i * 3] = dataElements[i * 4];
                bytes[i * 3 + 1] = dataElements[i * 4 + 1];
                bytes[i * 3 + 2] = dataElements[i * 4 + 2];
                maskBytes[i] = dataElements[i * 4 + 3];
                ++i;
            }
            mask.setBytes(maskBytes);
            mask.cosGetStream().addFilter(Filter.CN_Filter_FlateDecode);
            this.getPDImage().setSMask((PDXObject)mask);
        } else {
            bytes = new byte[dataElements.length];
            System.arraycopy(dataElements, 0, bytes, 0, dataElements.length);
        }
        this.getPDImage().setBytes(bytes);
    }

    public void setCompressionQuality(float compression) {
        this.compressionQuality = compression;
    }

    public void setPreferJpeg(boolean preferJpeg) {
        this.preferJpeg = preferJpeg;
    }
}

