/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.image;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.ArithmeticDecoder;
import org.jpedal.jbig2.decoders.DecodeIntResult;
import org.jpedal.jbig2.decoders.HuffmanDecoder;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.decoders.MMRDecoder;
import org.jpedal.jbig2.image.BitmapPointer;
import org.jpedal.jbig2.util.BinaryOperation;

public final class JBIG2Bitmap {
    private int width;
    private int height;
    private int line;
    private int bitmapNumber;
    private BitSet data;
    private ArithmeticDecoder arithmeticDecoder;
    private HuffmanDecoder huffmanDecoder;
    private MMRDecoder mmrDecoder;

    public JBIG2Bitmap(int width, int height, ArithmeticDecoder arithmeticDecoder, HuffmanDecoder huffmanDecoder, MMRDecoder mmrDecoder) {
        this.width = width;
        this.height = height;
        this.arithmeticDecoder = arithmeticDecoder;
        this.huffmanDecoder = huffmanDecoder;
        this.mmrDecoder = mmrDecoder;
        this.line = width + 7 >> 3;
        this.data = new BitSet(width * height);
    }

    /*
     * Unable to fully structure code
     */
    public void readBitmap(boolean useMMR, int template, boolean typicalPredictionGenericDecodingOn, boolean useSkip, JBIG2Bitmap skipBitmap, short[] adaptiveTemplateX, short[] adaptiveTemplateY, int mmrDataLength) throws IOException, JBIG2Exception {
        block64: {
            block62: {
                block63: {
                    if (!useMMR) break block62;
                    this.mmrDecoder.reset();
                    referenceLine = new int[this.width + 2];
                    codingLine = new int[this.width + 2];
                    codingLine[0] = codingLine[1] = this.width;
                    row = 0;
                    while (row < this.height) {
                        i = 0;
                        while (codingLine[i] < this.width) {
                            referenceLine[i] = codingLine[i];
                            ++i;
                        }
                        v0 = this.width;
                        referenceLine[i + 1] = v0;
                        referenceLine[i] = v0;
                        referenceI = 0;
                        codingI = 0;
                        a0 = 0;
                        block25: do {
                            code1 = this.mmrDecoder.get2DCode();
                            switch (code1) {
                                case 0: {
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    a0 = referenceLine[referenceI + 1];
                                    referenceI += 2;
                                    break;
                                }
                                case 1: {
                                    if (codingI & true) {
                                        code1 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getBlackCode();
                                            code1 += code3;
                                        } while (code3 >= 64);
                                        code2 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getWhiteCode();
                                            code2 += code3;
                                        } while (code3 >= 64);
                                    } else {
                                        code1 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getWhiteCode();
                                            code1 += code3;
                                        } while (code3 >= 64);
                                        code2 = 0;
                                        do {
                                            code3 = this.mmrDecoder.getBlackCode();
                                            code2 += code3;
                                        } while (code3 >= 64);
                                    }
                                    if (code1 <= 0 && code2 <= 0) continue block25;
                                    v1 = codingI++;
                                    v2 = a0 + code1;
                                    codingLine[v1] = v2;
                                    a0 = v2;
                                    v3 = codingI++;
                                    v4 = a0 + code2;
                                    codingLine[v3] = v4;
                                    a0 = v4;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 2: {
                                    v5 = codingI++;
                                    v6 = referenceLine[referenceI];
                                    codingLine[v5] = v6;
                                    a0 = v6;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    break;
                                }
                                case 3: {
                                    v7 = codingI++;
                                    v8 = referenceLine[referenceI] + 1;
                                    codingLine[v7] = v8;
                                    a0 = v8;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 5: {
                                    v9 = codingI++;
                                    v10 = referenceLine[referenceI] + 2;
                                    codingLine[v9] = v10;
                                    a0 = v10;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 7: {
                                    v11 = codingI++;
                                    v12 = referenceLine[referenceI] + 3;
                                    codingLine[v11] = v12;
                                    a0 = v12;
                                    if (referenceLine[referenceI] >= this.width) continue block25;
                                    ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 4: {
                                    v13 = codingI++;
                                    v14 = referenceLine[referenceI] - 1;
                                    codingLine[v13] = v14;
                                    a0 = v14;
                                    referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 6: {
                                    v15 = codingI++;
                                    v16 = referenceLine[referenceI] - 2;
                                    codingLine[v15] = v16;
                                    a0 = v16;
                                    referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                case 8: {
                                    v17 = codingI++;
                                    v18 = referenceLine[referenceI] - 3;
                                    codingLine[v17] = v18;
                                    a0 = v18;
                                    referenceI = referenceI > 0 ? --referenceI : ++referenceI;
                                    while (referenceLine[referenceI] <= a0 && referenceLine[referenceI] < this.width) {
                                        referenceI += 2;
                                    }
                                    continue block25;
                                }
                                default: {
                                    if (!JBIG2StreamDecoder.debug) continue block25;
                                    System.out.println("Illegal code in JBIG2 MMR bitmap data");
                                }
                            }
                        } while (a0 < this.width);
                        codingLine[codingI++] = this.width;
                        j = 0;
                        while (codingLine[j] < this.width) {
                            col = codingLine[j];
                            while (col < codingLine[j + 1]) {
                                this.setPixel(col, row, 1);
                                ++col;
                            }
                            j += 2;
                        }
                        ++row;
                    }
                    if (mmrDataLength < 0) break block63;
                    this.mmrDecoder.skipTo(mmrDataLength);
                    break block64;
                }
                if (this.mmrDecoder.get24Bits() == 4097L || !JBIG2StreamDecoder.debug) break block64;
                System.out.println("Missing EOFB in JBIG2 MMR bitmap data");
                break block64;
            }
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            atPtr0 = new BitmapPointer(this);
            atPtr1 = new BitmapPointer(this);
            atPtr2 = new BitmapPointer(this);
            atPtr3 = new BitmapPointer(this);
            ltpCX = 0L;
            if (typicalPredictionGenericDecodingOn) {
                switch (template) {
                    case 0: {
                        ltpCX = 14675L;
                        break;
                    }
                    case 1: {
                        ltpCX = 1946L;
                        break;
                    }
                    case 2: {
                        ltpCX = 227L;
                        break;
                    }
                    case 3: {
                        ltpCX = 394L;
                    }
                }
            }
            ltp = false;
            row = 0;
            while (row < this.height) {
                if (!typicalPredictionGenericDecodingOn) ** GOTO lbl-1000
                bit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.genericRegionStats);
                if (bit != 0) {
                    v19 = ltp = ltp == false;
                }
                if (ltp) {
                    this.duplicateRow(row, row - 1);
                } else lbl-1000:
                // 2 sources

                {
                    switch (template) {
                        case 0: {
                            cxPtr0.setPointer(0, row - 2);
                            cx0 = cxPtr0.nextPixel();
                            cx0 = BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel();
                            cxPtr1.setPointer(0, row - 1);
                            cx1 = cxPtr1.nextPixel();
                            cx1 = BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel();
                            cx1 = BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel();
                            cx2 = 0L;
                            atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                            atPtr1.setPointer(adaptiveTemplateX[1], row + adaptiveTemplateY[1]);
                            atPtr2.setPointer(adaptiveTemplateX[2], row + adaptiveTemplateY[2]);
                            atPtr3.setPointer(adaptiveTemplateX[3], row + adaptiveTemplateY[3]);
                            col = 0;
                            while (col < this.width) {
                                cx = BinaryOperation.bit32Shift(cx0, 13, 0) | BinaryOperation.bit32Shift(cx1, 8, 0) | BinaryOperation.bit32Shift(cx2, 4, 0) | (long)(atPtr0.nextPixel() << 3) | (long)(atPtr1.nextPixel() << 2) | (long)(atPtr2.nextPixel() << 1) | (long)atPtr3.nextPixel();
                                if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                    pixel = 0;
                                } else {
                                    pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                    if (pixel != 0) {
                                        this.setPixel(col, row, 1);
                                    }
                                }
                                cx0 = (BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel()) & 7L;
                                cx1 = (BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel()) & 31L;
                                cx2 = (BinaryOperation.bit32Shift(cx2, 1, 0) | (long)pixel) & 15L;
                                ++col;
                            }
                            break;
                        }
                        case 1: {
                            cxPtr0.setPointer(0, row - 2);
                            cx0 = cxPtr0.nextPixel();
                            cx0 = BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel();
                            cx0 = BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel();
                            cxPtr1.setPointer(0, row - 1);
                            cx1 = cxPtr1.nextPixel();
                            cx1 = BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel();
                            cx1 = BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel();
                            cx2 = 0L;
                            atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                            col = 0;
                            while (col < this.width) {
                                cx = BinaryOperation.bit32Shift(cx0, 9, 0) | BinaryOperation.bit32Shift(cx1, 4, 0) | BinaryOperation.bit32Shift(cx2, 1, 0) | (long)atPtr0.nextPixel();
                                if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                    pixel = 0;
                                } else {
                                    pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                    if (pixel != 0) {
                                        this.setPixel(col, row, 1);
                                    }
                                }
                                cx0 = (BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel()) & 15L;
                                cx1 = (BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel()) & 31L;
                                cx2 = (BinaryOperation.bit32Shift(cx2, 1, 0) | (long)pixel) & 7L;
                                ++col;
                            }
                            break;
                        }
                        case 2: {
                            cxPtr0.setPointer(0, row - 2);
                            cx0 = cxPtr0.nextPixel();
                            cx0 = BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel();
                            cxPtr1.setPointer(0, row - 1);
                            cx1 = cxPtr1.nextPixel();
                            cx1 = BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel();
                            cx2 = 0L;
                            atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                            col = 0;
                            while (col < this.width) {
                                cx = BinaryOperation.bit32Shift(cx0, 7, 0) | BinaryOperation.bit32Shift(cx1, 3, 0) | BinaryOperation.bit32Shift(cx2, 1, 0) | (long)atPtr0.nextPixel();
                                if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                    pixel = 0;
                                } else {
                                    pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                    if (pixel != 0) {
                                        this.setPixel(col, row, 1);
                                    }
                                }
                                cx0 = (BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel()) & 7L;
                                cx1 = (BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel()) & 15L;
                                cx2 = (BinaryOperation.bit32Shift(cx2, 1, 0) | (long)pixel) & 3L;
                                ++col;
                            }
                            break;
                        }
                        case 3: {
                            cxPtr1.setPointer(0, row - 1);
                            cx1 = cxPtr1.nextPixel();
                            cx1 = BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel();
                            cx2 = 0L;
                            atPtr0.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                            col = 0;
                            while (col < this.width) {
                                cx = BinaryOperation.bit32Shift(cx1, 5, 0) | BinaryOperation.bit32Shift(cx2, 1, 0) | (long)atPtr0.nextPixel();
                                if (useSkip && skipBitmap.getPixel(col, row) != 0) {
                                    pixel = 0;
                                } else {
                                    pixel = this.arithmeticDecoder.decodeBit(cx, this.arithmeticDecoder.genericRegionStats);
                                    if (pixel != 0) {
                                        this.setPixel(col, row, 1);
                                    }
                                }
                                cx1 = (BinaryOperation.bit32Shift(cx1, 1, 0) | (long)cxPtr1.nextPixel()) & 31L;
                                cx2 = (BinaryOperation.bit32Shift(cx2, 1, 0) | (long)pixel) & 15L;
                                ++col;
                            }
                            break;
                        }
                    }
                }
                ++row;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void readGenericRefinementRegion(int template, boolean typicalPredictionGenericRefinementOn, JBIG2Bitmap referredToBitmap, int referenceDX, int referenceDY, short[] adaptiveTemplateX, short[] adaptiveTemplateY) throws IOException, JBIG2Exception {
        if (template != 0) {
            ltpCX = 8L;
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            cxPtr2 = new BitmapPointer(referredToBitmap);
            cxPtr3 = new BitmapPointer(referredToBitmap);
            cxPtr4 = new BitmapPointer(referredToBitmap);
            cxPtr5 = new BitmapPointer(this);
            cxPtr6 = new BitmapPointer(this);
            typicalPredictionGenericRefinementCXPtr0 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr1 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr2 = new BitmapPointer(referredToBitmap);
        } else {
            ltpCX = 16L;
            cxPtr0 = new BitmapPointer(this);
            cxPtr1 = new BitmapPointer(this);
            cxPtr2 = new BitmapPointer(referredToBitmap);
            cxPtr3 = new BitmapPointer(referredToBitmap);
            cxPtr4 = new BitmapPointer(referredToBitmap);
            cxPtr5 = new BitmapPointer(this);
            cxPtr6 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr0 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr1 = new BitmapPointer(referredToBitmap);
            typicalPredictionGenericRefinementCXPtr2 = new BitmapPointer(referredToBitmap);
        }
        ltp = false;
        row = 0;
        while (row < this.height) {
            block20: {
                block19: {
                    if (template == 0) break block19;
                    cxPtr0.setPointer(0, row - 1);
                    cx0 = cxPtr0.nextPixel();
                    cxPtr1.setPointer(-1, row);
                    cxPtr2.setPointer(-referenceDX, row - 1 - referenceDY);
                    cxPtr3.setPointer(-1 - referenceDX, row - referenceDY);
                    cx3 = cxPtr3.nextPixel();
                    cx3 = BinaryOperation.bit32Shift(cx3, 1, 0) | (long)cxPtr3.nextPixel();
                    cxPtr4.setPointer(-referenceDX, row + 1 - referenceDY);
                    cx4 = cxPtr4.nextPixel();
                    typicalPredictionGenericRefinementCX2 = 0L;
                    typicalPredictionGenericRefinementCX1 = 0L;
                    typicalPredictionGenericRefinementCX0 = 0L;
                    if (typicalPredictionGenericRefinementOn) {
                        typicalPredictionGenericRefinementCXPtr0.setPointer(-1 - referenceDX, row - 1 - referenceDY);
                        typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCXPtr0.nextPixel();
                        typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX0, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                        typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX0, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                        typicalPredictionGenericRefinementCXPtr1.setPointer(-1 - referenceDX, row - referenceDY);
                        typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCXPtr1.nextPixel();
                        typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX1, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                        typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX1, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                        typicalPredictionGenericRefinementCXPtr2.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                        typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCXPtr2.nextPixel();
                        typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX2, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                        typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX2, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    }
                    col = 0;
                    while (col < this.width) {
                        cx0 = (BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel()) & 7L;
                        cx3 = (BinaryOperation.bit32Shift(cx3, 1, 0) | (long)cxPtr3.nextPixel()) & 7L;
                        cx4 = (BinaryOperation.bit32Shift(cx4, 1, 0) | (long)cxPtr4.nextPixel()) & 3L;
                        if (!typicalPredictionGenericRefinementOn) ** GOTO lbl-1000
                        typicalPredictionGenericRefinementCX0 = (BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX0, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel()) & 7L;
                        typicalPredictionGenericRefinementCX1 = (BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX1, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel()) & 7L;
                        typicalPredictionGenericRefinementCX2 = (BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX2, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel()) & 7L;
                        decodeBit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.refinementRegionStats);
                        if (decodeBit != 0) {
                            v0 = ltp = ltp == false;
                        }
                        if (typicalPredictionGenericRefinementCX0 == 0L && typicalPredictionGenericRefinementCX1 == 0L && typicalPredictionGenericRefinementCX2 == 0L) {
                            this.setPixel(col, row, 0);
                        } else if (typicalPredictionGenericRefinementCX0 == 7L && typicalPredictionGenericRefinementCX1 == 7L && typicalPredictionGenericRefinementCX2 == 7L) {
                            this.setPixel(col, row, 1);
                        } else if ((pixel = this.arithmeticDecoder.decodeBit(cx = BinaryOperation.bit32Shift(cx0, 7, 0) | (long)(cxPtr1.nextPixel() << 6) | (long)(cxPtr2.nextPixel() << 5) | BinaryOperation.bit32Shift(cx3, 2, 0) | cx4, this.arithmeticDecoder.refinementRegionStats)) == 1) {
                            this.setPixel(col, row, 1);
                        }
                        ++col;
                    }
                    break block20;
                }
                cxPtr0.setPointer(0, row - 1);
                cx0 = cxPtr0.nextPixel();
                cxPtr1.setPointer(-1, row);
                cxPtr2.setPointer(-referenceDX, row - 1 - referenceDY);
                cx2 = cxPtr2.nextPixel();
                cxPtr3.setPointer(-1 - referenceDX, row - referenceDY);
                cx3 = cxPtr3.nextPixel();
                cx3 = BinaryOperation.bit32Shift(cx3, 1, 0) | (long)cxPtr3.nextPixel();
                cxPtr4.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                cx4 = cxPtr4.nextPixel();
                cx4 = BinaryOperation.bit32Shift(cx4, 1, 0) | (long)cxPtr4.nextPixel();
                cxPtr5.setPointer(adaptiveTemplateX[0], row + adaptiveTemplateY[0]);
                cxPtr6.setPointer(adaptiveTemplateX[1] - referenceDX, row + adaptiveTemplateY[1] - referenceDY);
                typicalPredictionGenericRefinementCX2 = 0L;
                typicalPredictionGenericRefinementCX1 = 0L;
                typicalPredictionGenericRefinementCX0 = 0L;
                if (typicalPredictionGenericRefinementOn) {
                    typicalPredictionGenericRefinementCXPtr0.setPointer(-1 - referenceDX, row - 1 - referenceDY);
                    typicalPredictionGenericRefinementCX0 = typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX0, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCX0 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX0, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel();
                    typicalPredictionGenericRefinementCXPtr1.setPointer(-1 - referenceDX, row - referenceDY);
                    typicalPredictionGenericRefinementCX1 = typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX1, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCX1 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX1, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel();
                    typicalPredictionGenericRefinementCXPtr2.setPointer(-1 - referenceDX, row + 1 - referenceDY);
                    typicalPredictionGenericRefinementCX2 = typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX2, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                    typicalPredictionGenericRefinementCX2 = BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX2, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel();
                }
                col = 0;
                while (col < this.width) {
                    cx0 = (BinaryOperation.bit32Shift(cx0, 1, 0) | (long)cxPtr0.nextPixel()) & 3L;
                    cx2 = (BinaryOperation.bit32Shift(cx2, 1, 0) | (long)cxPtr2.nextPixel()) & 3L;
                    cx3 = (BinaryOperation.bit32Shift(cx3, 1, 0) | (long)cxPtr3.nextPixel()) & 7L;
                    cx4 = (BinaryOperation.bit32Shift(cx4, 1, 0) | (long)cxPtr4.nextPixel()) & 7L;
                    if (!typicalPredictionGenericRefinementOn) ** GOTO lbl-1000
                    typicalPredictionGenericRefinementCX0 = (BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX0, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr0.nextPixel()) & 7L;
                    typicalPredictionGenericRefinementCX1 = (BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX1, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr1.nextPixel()) & 7L;
                    typicalPredictionGenericRefinementCX2 = (BinaryOperation.bit32Shift(typicalPredictionGenericRefinementCX2, 1, 0) | (long)typicalPredictionGenericRefinementCXPtr2.nextPixel()) & 7L;
                    decodeBit = this.arithmeticDecoder.decodeBit(ltpCX, this.arithmeticDecoder.refinementRegionStats);
                    if (decodeBit == 1) {
                        v1 = ltp = ltp == false;
                    }
                    if (typicalPredictionGenericRefinementCX0 == 0L && typicalPredictionGenericRefinementCX1 == 0L && typicalPredictionGenericRefinementCX2 == 0L) {
                        this.setPixel(col, row, 0);
                    } else if (typicalPredictionGenericRefinementCX0 == 7L && typicalPredictionGenericRefinementCX1 == 7L && typicalPredictionGenericRefinementCX2 == 7L) {
                        this.setPixel(col, row, 1);
                    } else if ((pixel = this.arithmeticDecoder.decodeBit(cx = BinaryOperation.bit32Shift(cx0, 11, 0) | (long)(cxPtr1.nextPixel() << 10) | BinaryOperation.bit32Shift(cx2, 8, 0) | BinaryOperation.bit32Shift(cx3, 5, 0) | BinaryOperation.bit32Shift(cx4, 2, 0) | (long)(cxPtr5.nextPixel() << 1) | (long)cxPtr6.nextPixel(), this.arithmeticDecoder.refinementRegionStats)) == 1) {
                        this.setPixel(col, row, 1);
                    }
                    ++col;
                }
            }
            ++row;
        }
    }

    public void readTextRegion(boolean huffman, boolean symbolRefine, int noOfSymbolInstances, int logStrips, int noOfSymbols, int[][] symbolCodeTable, int symbolCodeLength, JBIG2Bitmap[] symbols, int defaultPixel, int combinationOperator, boolean transposed, int referenceCorner, int sOffset, int[][] huffmanFSTable, int[][] huffmanDSTable, int[][] huffmanDTTable, int[][] huffmanRDWTable, int[][] huffmanRDHTable, int[][] huffmanRDXTable, int[][] huffmanRDYTable, int[][] huffmanRSizeTable, int template, short[] symbolRegionAdaptiveTemplateX, short[] symbolRegionAdaptiveTemplateY, JBIG2StreamDecoder decoder) throws JBIG2Exception, IOException {
        int strips = 1 << logStrips;
        this.clear(defaultPixel);
        int t = huffman ? this.huffmanDecoder.decodeInt(huffmanDTTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
        t *= -strips;
        int firstS = 0;
        block12: for (int currentInstance = 0; currentInstance < noOfSymbolInstances; ++currentInstance) {
            int dt = huffman ? this.huffmanDecoder.decodeInt(huffmanDTTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadtStats).intResult();
            t += dt * strips;
            int ds = huffman ? this.huffmanDecoder.decodeInt(huffmanFSTable).intResult() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iafsStats).intResult();
            int s = firstS += ds;
            while (true) {
                dt = strips == 1 ? 0 : (huffman ? decoder.readBits(logStrips) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iaitStats).intResult());
                int tt = t + dt;
                long symbolID = huffman ? (symbolCodeTable != null ? (long)this.huffmanDecoder.decodeInt(symbolCodeTable).intResult() : (long)decoder.readBits(symbolCodeLength)) : this.arithmeticDecoder.decodeIAID(symbolCodeLength, this.arithmeticDecoder.iaidStats);
                if (symbolID >= (long)noOfSymbols) {
                    if (!JBIG2StreamDecoder.debug) continue block12;
                    System.out.println("Invalid symbol number in JBIG2 text region");
                    continue block12;
                }
                JBIG2Bitmap symbolBitmap = null;
                int ri = symbolRefine ? (huffman ? decoder.readBit() : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iariStats).intResult()) : 0;
                if (ri != 0) {
                    int refinementDeltaY;
                    int refinementDeltaX;
                    int refinementDeltaHeight;
                    int refinementDeltaWidth;
                    if (huffman) {
                        refinementDeltaWidth = this.huffmanDecoder.decodeInt(huffmanRDWTable).intResult();
                        refinementDeltaHeight = this.huffmanDecoder.decodeInt(huffmanRDHTable).intResult();
                        refinementDeltaX = this.huffmanDecoder.decodeInt(huffmanRDXTable).intResult();
                        refinementDeltaY = this.huffmanDecoder.decodeInt(huffmanRDYTable).intResult();
                        decoder.consumeRemainingBits();
                        this.arithmeticDecoder.start();
                    } else {
                        refinementDeltaWidth = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardwStats).intResult();
                        refinementDeltaHeight = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardhStats).intResult();
                        refinementDeltaX = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardxStats).intResult();
                        refinementDeltaY = this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iardyStats).intResult();
                    }
                    refinementDeltaX = (refinementDeltaWidth >= 0 ? refinementDeltaWidth : refinementDeltaWidth - 1) / 2 + refinementDeltaX;
                    refinementDeltaY = (refinementDeltaHeight >= 0 ? refinementDeltaHeight : refinementDeltaHeight - 1) / 2 + refinementDeltaY;
                    symbolBitmap = new JBIG2Bitmap(refinementDeltaWidth + symbols[(int)symbolID].width, refinementDeltaHeight + symbols[(int)symbolID].height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
                    symbolBitmap.readGenericRefinementRegion(template, false, symbols[(int)symbolID], refinementDeltaX, refinementDeltaY, symbolRegionAdaptiveTemplateX, symbolRegionAdaptiveTemplateY);
                } else {
                    symbolBitmap = symbols[(int)symbolID];
                }
                int bitmapWidth = symbolBitmap.width - 1;
                int bitmapHeight = symbolBitmap.height - 1;
                if (transposed) {
                    switch (referenceCorner) {
                        case 0: {
                            this.combine(symbolBitmap, tt, s, combinationOperator);
                            break;
                        }
                        case 1: {
                            this.combine(symbolBitmap, tt, s, combinationOperator);
                            break;
                        }
                        case 2: {
                            this.combine(symbolBitmap, tt - bitmapWidth, s, combinationOperator);
                            break;
                        }
                        case 3: {
                            this.combine(symbolBitmap, tt - bitmapWidth, s, combinationOperator);
                        }
                    }
                    s += bitmapHeight;
                    continue block12;
                }
                switch (referenceCorner) {
                    case 0: {
                        this.combine(symbolBitmap, s, tt - bitmapHeight, combinationOperator);
                        break;
                    }
                    case 1: {
                        this.combine(symbolBitmap, s, tt, combinationOperator);
                        break;
                    }
                    case 2: {
                        this.combine(symbolBitmap, s, tt - bitmapHeight, combinationOperator);
                        break;
                    }
                    case 3: {
                        this.combine(symbolBitmap, s, tt, combinationOperator);
                    }
                }
                s += bitmapWidth;
                DecodeIntResult decodeIntResult = huffman ? this.huffmanDecoder.decodeInt(huffmanDSTable) : this.arithmeticDecoder.decodeInt(this.arithmeticDecoder.iadsStats);
                if (!decodeIntResult.booleanResult()) continue block12;
                ds = decodeIntResult.intResult();
                s += sOffset + ds;
            }
        }
    }

    public void clear(int defPixel) {
        this.data.set(0, this.data.size(), defPixel == 1);
    }

    public void combine(JBIG2Bitmap bitmap, int x, int y, long combOp) {
        int srcWidth = bitmap.width;
        int srcHeight = bitmap.height;
        int srcRow = 0;
        int srcCol = 0;
        int row = y;
        while (row > -1 && row < y + srcHeight) {
            int col = x;
            while (col < x + srcWidth) {
                int srcPixel = bitmap.getPixel(srcCol, srcRow);
                switch ((int)combOp) {
                    case 0: {
                        this.setPixel(col, row, this.getPixel(col, row) | srcPixel);
                        break;
                    }
                    case 1: {
                        this.setPixel(col, row, this.getPixel(col, row) & srcPixel);
                        break;
                    }
                    case 2: {
                        this.setPixel(col, row, this.getPixel(col, row) ^ srcPixel);
                        break;
                    }
                    case 3: {
                        if (this.getPixel(col, row) == 1 && srcPixel == 1 || this.getPixel(col, row) == 0 && srcPixel == 0) {
                            this.setPixel(col, row, 1);
                            break;
                        }
                        this.setPixel(col, row, 0);
                        break;
                    }
                    case 4: {
                        this.setPixel(col, row, srcPixel);
                    }
                }
                ++srcCol;
                ++col;
            }
            srcCol = 0;
            ++srcRow;
            ++row;
        }
    }

    private void duplicateRow(int yDest, int ySrc) {
        int i = 0;
        while (i < this.width) {
            this.setPixel(i, yDest, this.getPixel(i, ySrc));
            ++i;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public byte[] getData(boolean switchPixelColor) {
        byte[] bytes = new byte[this.height * this.line];
        int count = 0;
        int offset = 0;
        int row = 0;
        while (row < this.height) {
            int col = 0;
            while (col < this.width) {
                if (this.data.get(count)) {
                    int bite = (count + offset) / 8;
                    int bit = (count + offset) % 8;
                    int n = bite;
                    bytes[n] = (byte)(bytes[n] | 1 << 7 - bit);
                }
                ++count;
                ++col;
            }
            offset = this.line * 8 * (row + 1) - count;
            ++row;
        }
        if (switchPixelColor) {
            int i = 0;
            while (i < bytes.length) {
                int n = i++;
                bytes[n] = (byte)(bytes[n] ^ 0xFF);
            }
        }
        return bytes;
    }

    public JBIG2Bitmap getSlice(int x, int y, int width, int height) {
        JBIG2Bitmap slice = new JBIG2Bitmap(width, height, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder);
        int sliceRow = 0;
        int sliceCol = 0;
        int row = y;
        while (row < height) {
            int col = x;
            while (col < x + width) {
                slice.setPixel(sliceCol, sliceRow, this.getPixel(col, row));
                ++sliceCol;
                ++col;
            }
            sliceCol = 0;
            ++sliceRow;
            ++row;
        }
        return slice;
    }

    private void setPixel(int col, int row, BitSet data, int value) {
        int index = row * this.width + col;
        data.set(index, value == 1);
    }

    public void setPixel(int col, int row, int value) {
        this.setPixel(col, row, this.data, value);
    }

    public int getPixel(int col, int row) {
        return this.data.get(row * this.width + col) ? 1 : 0;
    }

    public void expand(int newHeight, int defaultPixel) {
        BitSet newData = new BitSet(newHeight * this.width);
        int row = 0;
        while (row < this.height) {
            int col = 0;
            while (col < this.width) {
                this.setPixel(col, row, newData, this.getPixel(col, row));
                ++col;
            }
            ++row;
        }
        this.height = newHeight;
        this.data = newData;
    }

    public void setBitmapNumber(int segmentNumber) {
        this.bitmapNumber = segmentNumber;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }

    public BufferedImage getBufferedImage() {
        byte[] bytes = this.getData(true);
        if (bytes == null) {
            return null;
        }
        int len = bytes.length;
        byte[] copy = new byte[len];
        System.arraycopy(bytes, 0, copy, 0, len);
        DataBufferByte db = new DataBufferByte(copy, copy.length);
        WritableRaster raster = Raster.createPackedRaster(db, this.width, this.height, 1, null);
        BufferedImage image = new BufferedImage(this.width, this.height, 12);
        image.setData(raster);
        return image;
    }

    static final class FastBitSet {
        byte[][] bytes;
        int w;
        int h;

        public FastBitSet(int width, int height) {
            this.bytes = new byte[height][(width + 7) / 8];
            this.w = width;
            this.h = height;
        }

        public byte getByte(int row, int col) {
            int offset = col / 8;
            int mod = col % 8;
            if (mod == 0) {
                return this.bytes[row][offset];
            }
            byte leftMask = (byte)(255 >> 8 - mod);
            byte rightMask = (byte)(255 << mod);
            byte left = (byte)((this.bytes[row][offset] & leftMask) << 8 - mod);
            if (offset + 1 >= this.bytes[row].length) {
                System.out.println("returning");
                return left;
            }
            byte right = (byte)((this.bytes[row][offset + 1] & rightMask) >> mod);
            return (byte)(left | right);
        }

        public void setByte(int row, int col, byte bits) {
            int offset = col / 8;
            int mod = col % 8;
            if (mod == 0) {
                this.bytes[row][offset] = bits;
            } else {
                byte left = (byte)(bits >> mod);
                byte leftMask = (byte)(255 << 8 - mod);
                byte[] byArray = this.bytes[row];
                int n = offset;
                byArray[n] = (byte)(byArray[n] & leftMask);
                byte[] byArray2 = this.bytes[row];
                int n2 = offset;
                byArray2[n2] = (byte)(byArray2[n2] | left);
                if (offset + 1 >= this.bytes[row].length) {
                    return;
                }
                byte right = (byte)(bits << 8 - mod);
                byte rightMask = (byte)(255 >> mod);
                byte[] byArray3 = this.bytes[row];
                int n3 = offset + 1;
                byArray3[n3] = (byte)(byArray3[n3] & rightMask);
                byte[] byArray4 = this.bytes[row];
                int n4 = offset + 1;
                byArray4[n4] = (byte)(byArray4[n4] | right);
            }
        }

        public void set(int row, int col) {
            byte bit = (byte)(1 << col % 8);
            byte[] byArray = this.bytes[row];
            int n = col / 8;
            byArray[n] = (byte)(byArray[n] | bit);
        }

        public void clear(int row, int col) {
            byte bit = (byte)(1 << col % 8);
            byte[] byArray = this.bytes[row];
            int n = col / 8;
            byArray[n] = (byte)(byArray[n] & ~bit);
        }

        public boolean get(int row, int col) {
            byte bit = (byte)(1 << col % 8);
            return (this.bytes[row][col / 8] & bit) != 0;
        }

        public void reset(boolean set) {
            int i = 0;
            while (i < this.bytes.length) {
                Arrays.fill(this.bytes[i], set ? (byte)-1 : 0);
                ++i;
            }
        }
    }
}

