/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import info.clearthought.layout.TableLayout;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientDataManager;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.ClientPrimaryDataDirectory;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.Const;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.EdalLoginHelper;
import de.ipk_gatersleben.bit.bi.edal.rmi.client.util.StackTraceUtil;
import de.ipk_gatersleben.bit.bi.edal.rmi.server.Authentication;

public class EdalConfigDialog extends JDialog {
	private static final long serialVersionUID = 1L;

	/**
	 * Return value if cancel is chosen.
	 */
	public static final int CANCEL_OPTION = 1;
	/**
	 * Return value if approve (yes, ok) is chosen.
	 */
	public static final int APPROVE_OPTION = 0;

	public int returnvalue;

	public static ClientDataManager client;
	public static ClientPrimaryDataDirectory rootDirectory;
	private boolean islogin = false;

	private JPanel detialpanel = new JPanel();

	private JButton savebtn;
	private JButton cancelbtn;
	private JLabel infolabel;

	public EdalConfigDialog() {
		addWindowListener(createAppCloser());

		setTitle(Const.CONFIGURATION_TITLE_STR);

		JPanel contents = (JPanel) getContentPane();
		contents.setLayout(new BorderLayout());

		final double detailsize[][] = { { 0.1, 0.3, 0.5, 0.1 },
				{ 5, 30, 5, 30, 5, 30, 5, 30, 30 } };
		final TableLayout detaillayout = new TableLayout(detailsize);
		detialpanel.setLayout(detaillayout);

		serveraddresslabel = new JLabel("Server Address:");
		detialpanel.add(serveraddresslabel, "1,1");

		serveraddresstxt = new JTextField();
		detialpanel.add(serveraddresstxt, "2,1");

		serverportlabel = new JLabel("Server Port:");
		detialpanel.add(serverportlabel, "1,3");

		serverporttxt = new JTextField();
		detialpanel.add(serverporttxt, "2,3");

		serverusernamelabel = new JLabel("User Name:");
		detialpanel.add(serverusernamelabel, "1,5");

		serverusernametxt = new JTextField();
		detialpanel.add(serverusernametxt, "2,5");

		serverpasswordlabel = new JLabel("Password:");
		detialpanel.add(serverpasswordlabel, "1,7");

		serverpasswordtxt = new JPasswordField();
		detialpanel.add(serverpasswordtxt, "2,7");

		infolabel = new JLabel("");
		infolabel.setForeground(Color.RED);
		detialpanel.add(infolabel, "1,8,2,8");

		contents.add(detialpanel, BorderLayout.CENTER);

		contents.add(createbuttonpanel(), BorderLayout.SOUTH);

		EdalLoginHelper helper = new EdalLoginHelper();
		helper.initdata(serveraddresstxt, serverporttxt, serverusernametxt,
				serverpasswordtxt);

		this.setSize(new Dimension(400, (int) (400 * 0.618)));
	}

	public String getServeraddress() {
		return serveraddresstxt.getText().trim();
	}

	public int getServerport() {
		return Integer.parseInt(serverporttxt.getText().trim());
	}

	public String getUsername() {
		return serverusernametxt.getText().trim();
	}

	public String getPassword() {
		return serverpasswordtxt.getText().trim();
	}

	public int showOpenDialog() {
		setModal(true);
		setLocationRelativeTo(null);
		setVisible(true);
		return returnvalue;
	}

	private JPanel createbuttonpanel() {
		savebtn = new JButton(okAction);
		cancelbtn = new JButton(cancelAction);

		JPanel buttonPane = new JPanel(new FlowLayout(FlowLayout.CENTER, 5, 5));
		buttonPane.add(savebtn);
		buttonPane.add(cancelbtn);
		
		this.getRootPane().setDefaultButton(savebtn);

		return buttonPane;
	}

	private boolean checkerror() {
		final String serveraddresstxtText = serveraddresstxt.getText();
		if (serveraddresstxtText.trim().length() == 0) {
			mustfill(serveraddresslabel);
			JOptionPane.showMessageDialog(null, "Please input Server Address!",
					Const.CONFIGURATION_TITLE_STR, JOptionPane.ERROR_MESSAGE);
			return false;
		} else {
			resetfill(serveraddresslabel);
		}

		final String serverporttxtText = serverporttxt.getText();
		if (serverporttxtText.trim().length() == 0) {
			mustfill(serverportlabel);
			JOptionPane.showMessageDialog(null, "Please input Server Port!",
					Const.CONFIGURATION_TITLE_STR, JOptionPane.ERROR_MESSAGE);
			return false;
		} else {
			resetfill(serverportlabel);
		}

		try {
			Integer.parseInt(serverporttxtText.trim());
		} catch (final Exception e) {
			JOptionPane.showMessageDialog(null,
					"Server Port should be Integer!",
					Const.CONFIGURATION_TITLE_STR, JOptionPane.ERROR_MESSAGE);
			return false;
		}

		final String serverusernametxtText = serverusernametxt.getText();
		if (serverusernametxtText.trim().length() == 0) {
			mustfill(serverusernamelabel);
			JOptionPane.showMessageDialog(null, "Please input User Name!",
					Const.CONFIGURATION_TITLE_STR, JOptionPane.ERROR_MESSAGE);
			return false;
		} else {
			resetfill(serverusernamelabel);
		}

		final String serverpasswordtxtText = serverpasswordtxt.getText();
		if (serverpasswordtxtText.trim().length() == 0) {
			mustfill(serverpasswordlabel);
			JOptionPane.showMessageDialog(null, "Please input Password!",
					Const.CONFIGURATION_TITLE_STR, JOptionPane.ERROR_MESSAGE);
			return false;
		} else {
			resetfill(serverpasswordlabel);
		}

		return true;
	}

	private void resetfill(JLabel label) {
		label.setForeground(Color.BLACK);
		String originaltext = label.getText();
		if (originaltext.startsWith("*")) {
			originaltext = originaltext.substring(1);
		}
		label.setText(originaltext);
	}

	private void mustfill(JLabel label) {
		label.setForeground(Color.RED);
		label.setText("*" + label.getText());
	}

	private Action okAction = new AbstractAction(Const.SAVE_BTN_STR) {
		private static final long serialVersionUID = 1L;

		public void actionPerformed(ActionEvent e) {
			infolabel.setText("");
			if (!checkerror()) {
				return;
			}
			if (loginremoteserver(getServeraddress(), getServerport(),
					getUsername(), getPassword())) {
				returnvalue = APPROVE_OPTION;
				dispose();
			}
		}
	};

	private boolean loginremoteserver(String serveraddress, int serverport,
			String username, String password) {
		try {
			Authentication auth = new Authentication(username, password);
			client = new ClientDataManager(serverport, serveraddress, auth);
			rootDirectory = client.getRootDirectory();
			islogin = true;
			EdalLoginHelper.client = client;
			EdalLoginHelper.rootDirectory = rootDirectory;
		} catch (Exception e) {
			islogin = false;
			ClientDataManager.logger.error(StackTraceUtil.getStackTrace(e));
			infolabel.setText(e.getMessage());
		}

		return islogin;
	}

	private Action cancelAction = new AbstractAction(Const.CANCEL_BTN_STR) {
		private static final long serialVersionUID = 1L;

		public void actionPerformed(ActionEvent e) {
			returnvalue = CANCEL_OPTION;
			dispose();
		}
	};
	private JLabel serveraddresslabel;
	private JTextField serveraddresstxt;
	private JLabel serverportlabel;
	private JTextField serverporttxt;
	private JLabel serverusernamelabel;
	private JTextField serverusernametxt;
	private JLabel serverpasswordlabel;
	private JTextField serverpasswordtxt;

	private WindowListener createAppCloser() {
		return new WindowAdapter() {
			@Override
			public void windowClosing(final WindowEvent we) {
				returnvalue = CANCEL_OPTION;
				dispose();
			}
		};
	}
}
