/*
 *  Copyright (c) 2011 Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the GNU Lesser Public License v2.1
 *  which accompanies this distribution, and is available at
 *  http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 *
 *  Contributors:
 *      Leibniz Institute of Plant Genetics and Crop Plant Research (IPK), Gatersleben, Germany - initial API and implementation
 */
package de.ipk_gatersleben.bit.bi.edal.rmi.client.gui;

import javax.swing.table.DefaultTableModel;
/**
 *  The <code>EDALTableModel</code> can be set up to display any data
 *  model which implements the 
 *  <code>TableModel</code> interface with a couple of lines of code:  <p>
 *  <pre>
 *  	EDALTableModel myData = new EDALTableModel(data,columnNames); 
 *  	JTable table = new JTable(myData);
 *  </pre><p>
 * we implement this class only because we want to make the table is readonly,
 * so the isCellEditable function return false
 * <p>
 * @version 1.0
 * @author Jinbo Chen
 */
public class EdalTableModel extends DefaultTableModel{
	private static final long serialVersionUID = 1L;
	
	public EdalTableModel(Object[][] data, Object[] columnNames)
	{
		super(data, columnNames);
	}
	public boolean isCellEditable(int rowIndex, int columnIndex) {
		return false;
	}
}
